/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner.db.model.schema;

import com.google.cloud.spanner.Dialect;
import io.debezium.connector.spanner.db.metadata.TableId;
import io.debezium.connector.spanner.db.model.schema.Column;
import io.debezium.connector.spanner.db.model.schema.TableSchema;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SpannerSchema {
    private final Map<TableId, TableSchema> tables;

    public SpannerSchema(Map<TableId, TableSchema> tables) {
        this.tables = tables;
    }

    public TableSchema getTable(TableId tableId) {
        return this.tables.get(tableId);
    }

    public static SpannerSchemaBuilder builder() {
        return new SpannerSchemaBuilder();
    }

    public Set<TableId> getAllTables() {
        return this.tables.keySet();
    }

    public static class SpannerSchemaBuilder {
        private final Map<String, List<Column>> tableMap = new HashMap<String, List<Column>>();
        private final Map<String, List<String>> tableToPrimaryColumnMap = new HashMap<String, List<String>>();

        private SpannerSchemaBuilder() {
        }

        public void addColumn(String tableName, String columnName, String type, long ordinalPosition, boolean nullable, Dialect dialect) {
            List<Object> columns;
            if (this.tableMap.containsKey(tableName)) {
                columns = this.tableMap.get(tableName);
            } else {
                columns = new ArrayList();
                this.tableMap.put(tableName, columns);
            }
            columns.add(Column.create(columnName, type, this.tableToPrimaryColumnMap.get(tableName).contains(columnName), ordinalPosition, nullable, dialect));
        }

        public void addPrimaryColumn(String tableName, String columnName) {
            List<Object> primaryColumns;
            if (this.tableToPrimaryColumnMap.containsKey(tableName)) {
                primaryColumns = this.tableToPrimaryColumnMap.get(tableName);
            } else {
                primaryColumns = new ArrayList();
                this.tableToPrimaryColumnMap.put(tableName, primaryColumns);
            }
            primaryColumns.add(columnName);
        }

        public SpannerSchema build() {
            HashMap<TableId, TableSchema> tables = new HashMap<TableId, TableSchema>();
            this.tableMap.forEach((tableName, columns) -> {
                TableId tableId = TableId.getTableId(tableName);
                TableSchema table = new TableSchema((String)tableName, (List<Column>)columns);
                tables.put(tableId, table);
            });
            return new SpannerSchema(tables);
        }
    }
}

