/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner.metrics;

import com.google.cloud.Timestamp;
import io.debezium.connector.spanner.SpannerConnectorConfig;
import io.debezium.connector.spanner.SpannerConnectorTask;
import io.debezium.connector.spanner.SpannerErrorHandler;
import io.debezium.connector.spanner.db.model.InitialPartition;
import io.debezium.connector.spanner.function.BlockingSupplier;
import io.debezium.connector.spanner.metrics.MetricsEventPublisher;
import io.debezium.connector.spanner.metrics.event.ActiveQueriesUpdateMetricEvent;
import io.debezium.connector.spanner.metrics.event.ChildPartitionsMetricEvent;
import io.debezium.connector.spanner.metrics.event.DelayChangeStreamEventsMetricEvent;
import io.debezium.connector.spanner.metrics.event.LatencyMetricEvent;
import io.debezium.connector.spanner.metrics.event.NewQueueMetricEvent;
import io.debezium.connector.spanner.metrics.event.OffsetReceivingTimeMetricEvent;
import io.debezium.connector.spanner.metrics.event.PartitionOffsetLagMetricEvent;
import io.debezium.connector.spanner.metrics.event.RebalanceMetricEvent;
import io.debezium.connector.spanner.metrics.event.RuntimeErrorMetricEvent;
import io.debezium.connector.spanner.metrics.event.SpannerEventQueueUpdateEvent;
import io.debezium.connector.spanner.metrics.event.StuckHeartbeatIntervalsMetricEvent;
import io.debezium.connector.spanner.metrics.event.TaskStateChangeQueueUpdateMetricEvent;
import io.debezium.connector.spanner.metrics.event.TaskSyncContextMetricEvent;
import io.debezium.connector.spanner.metrics.latency.LatencyCalculator;
import io.debezium.connector.spanner.metrics.latency.Statistics;
import io.debezium.connector.spanner.task.TaskSyncContext;
import io.debezium.spi.schema.DataCollectionId;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpannerMeter {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpannerMeter.class);
    private final Set<DataCollectionId> capturedTables = ConcurrentHashMap.newKeySet();
    private final AtomicInteger detectedPartitionCount = new AtomicInteger(0);
    private final AtomicInteger numberOfQueriesIssuedCount = new AtomicInteger(0);
    private final AtomicInteger numberOfActiveQueries = new AtomicInteger(0);
    private final AtomicInteger stuckHeartbeatIntervals = new AtomicInteger(0);
    private final AtomicInteger errorCount = new AtomicInteger(0);
    private final AtomicInteger spannerEventQueueTotalCapacity = new AtomicInteger(0);
    private final AtomicInteger spannerEventQueueRemainingCapacity = new AtomicInteger(0);
    private final AtomicInteger taskStateChangeEventQueueRemainingCapacity = new AtomicInteger(0);
    private final MetricsEventPublisher metricsEventPublisher;
    private final BlockingSupplier<Timestamp> lowWatermarkSupplier;
    private volatile TaskSyncContext taskSyncContext;
    private final SpannerConnectorTask spannerConnectorTask;
    private final AtomicInteger rebalanceAnswersActual = new AtomicInteger();
    private final AtomicInteger rebalanceAnswersExpected = new AtomicInteger();
    private final Statistics totalLatency;
    private final Statistics connectorLatency;
    private final Statistics spannerLatency;
    private final Statistics commitToEmitLatency;
    private final Statistics commitToPublishLatency;
    private final Statistics emitToPublishLatency;
    private final Statistics ownConnectorLatency;
    private final Statistics lowWatermarkLagLatency;
    private final Statistics partitionOffsetLagStatistics;
    private final Statistics receivingTimeOffsetStatistics;
    private final Statistics delayChangeStreamEvents;
    private final SpannerConnectorConfig connectorConfig;
    private final SpannerErrorHandler spannerErrorHandler;

    public SpannerMeter(SpannerConnectorTask task, SpannerConnectorConfig connectorConfig, SpannerErrorHandler errorHandler, BlockingSupplier<Timestamp> lowWatermarkSupplier) {
        this.metricsEventPublisher = new MetricsEventPublisher();
        this.spannerConnectorTask = task;
        this.connectorConfig = connectorConfig;
        this.spannerErrorHandler = errorHandler;
        this.lowWatermarkSupplier = lowWatermarkSupplier;
        this.totalLatency = new Statistics(connectorConfig.percentageMetricsClearInterval(), this::onError);
        this.connectorLatency = new Statistics(connectorConfig.percentageMetricsClearInterval(), this::onError);
        this.spannerLatency = new Statistics(connectorConfig.percentageMetricsClearInterval(), this::onError);
        this.commitToEmitLatency = new Statistics(connectorConfig.percentageMetricsClearInterval(), this::onError);
        this.commitToPublishLatency = new Statistics(connectorConfig.percentageMetricsClearInterval(), this::onError);
        this.emitToPublishLatency = new Statistics(connectorConfig.percentageMetricsClearInterval(), this::onError);
        this.lowWatermarkLagLatency = new Statistics(connectorConfig.percentageMetricsClearInterval(), this::onError);
        this.ownConnectorLatency = new Statistics(connectorConfig.percentageMetricsClearInterval(), this::onError);
        this.partitionOffsetLagStatistics = new Statistics(connectorConfig.percentageMetricsClearInterval(), this::onError);
        this.receivingTimeOffsetStatistics = new Statistics(connectorConfig.percentageMetricsClearInterval(), this::onError);
        this.delayChangeStreamEvents = new Statistics(connectorConfig.percentageMetricsClearInterval(), this::onError);
        this.metricsEventPublisher.subscribe(ChildPartitionsMetricEvent.class, event -> this.detectedPartitionCount.addAndGet(event.getNumberPartitions()));
        this.metricsEventPublisher.subscribe(NewQueueMetricEvent.class, event -> this.numberOfQueriesIssuedCount.incrementAndGet());
        this.metricsEventPublisher.subscribe(ActiveQueriesUpdateMetricEvent.class, event -> this.numberOfActiveQueries.set(event.getActiveQueries()));
        this.metricsEventPublisher.subscribe(StuckHeartbeatIntervalsMetricEvent.class, event -> this.stuckHeartbeatIntervals.set(event.getStuckHeartbeatIntervals()));
        this.metricsEventPublisher.subscribe(RuntimeErrorMetricEvent.class, event -> this.errorCount.incrementAndGet());
        this.metricsEventPublisher.subscribe(TaskSyncContextMetricEvent.class, event -> {
            this.taskSyncContext = event.getTaskSyncContext();
        });
        this.metricsEventPublisher.subscribe(LatencyMetricEvent.class, event -> {
            if (event.getTotalLatency() != null) {
                this.totalLatency.update(event.getTotalLatency());
            }
            if (event.getReadToEmitLatency() != null) {
                this.connectorLatency.update(event.getReadToEmitLatency());
            }
            if (event.getSpannerLatency() != null) {
                this.spannerLatency.update(event.getSpannerLatency());
            }
            if (event.getCommitToEmitLatency() != null) {
                this.commitToEmitLatency.update(event.getCommitToEmitLatency());
            }
            if (event.getCommitToPublishLatency() != null) {
                this.commitToPublishLatency.update(event.getCommitToPublishLatency());
            }
            if (event.getEmitToPublishLatency() != null) {
                this.emitToPublishLatency.update(event.getEmitToPublishLatency());
            }
            if (event.getLowWatermarkLag() != null) {
                this.lowWatermarkLagLatency.update(event.getLowWatermarkLag());
            }
            if (event.getOwnConnectorLatency() != null) {
                this.ownConnectorLatency.update(event.getOwnConnectorLatency());
            }
        });
        this.metricsEventPublisher.subscribe(SpannerEventQueueUpdateEvent.class, event -> {
            this.spannerEventQueueTotalCapacity.set(event.getTotalCapacity());
            this.spannerEventQueueRemainingCapacity.set(event.getRemainingCapacity());
        });
        this.metricsEventPublisher.subscribe(PartitionOffsetLagMetricEvent.class, event -> {
            if (InitialPartition.isInitialPartition(event.getToken())) {
                return;
            }
            this.partitionOffsetLagStatistics.update(event.getOffsetLag());
        });
        this.metricsEventPublisher.subscribe(RebalanceMetricEvent.class, event -> {
            this.rebalanceAnswersActual.set(event.getRebalanceAnswersActual());
            this.rebalanceAnswersExpected.set(event.getRebalanceAnswersExpected());
        });
        this.metricsEventPublisher.subscribe(OffsetReceivingTimeMetricEvent.class, event -> this.receivingTimeOffsetStatistics.update(event.getTime()));
        this.metricsEventPublisher.subscribe(DelayChangeStreamEventsMetricEvent.class, event -> this.delayChangeStreamEvents.update(event.getDelayChangeStreamEvents()));
        this.metricsEventPublisher.subscribe(TaskStateChangeQueueUpdateMetricEvent.class, event -> this.taskStateChangeEventQueueRemainingCapacity.set(event.getRemainingCapacity()));
    }

    private void onError(Throwable throwable) {
        this.spannerErrorHandler.setProducerThrowable(throwable);
    }

    public MetricsEventPublisher getMetricsEventPublisher() {
        return this.metricsEventPublisher;
    }

    public void captureTable(DataCollectionId dataCollectionId) {
        this.capturedTables.add(dataCollectionId);
    }

    public Set<DataCollectionId> getCapturedTables() {
        return this.capturedTables;
    }

    public void reset() {
        this.capturedTables.clear();
        this.totalLatency.reset();
        this.connectorLatency.reset();
        this.spannerLatency.reset();
        this.commitToEmitLatency.reset();
        this.commitToPublishLatency.reset();
        this.emitToPublishLatency.reset();
        this.ownConnectorLatency.reset();
        this.partitionOffsetLagStatistics.reset();
        this.lowWatermarkLagLatency.reset();
        this.receivingTimeOffsetStatistics.reset();
        this.delayChangeStreamEvents.reset();
    }

    public void start() {
        this.totalLatency.start();
        this.connectorLatency.start();
        this.spannerLatency.start();
        this.commitToEmitLatency.start();
        this.commitToPublishLatency.start();
        this.emitToPublishLatency.start();
        this.ownConnectorLatency.start();
        this.partitionOffsetLagStatistics.start();
        this.lowWatermarkLagLatency.start();
        this.receivingTimeOffsetStatistics.start();
        this.delayChangeStreamEvents.start();
    }

    public void shutdown() {
        this.connectorLatency.shutdown();
        LOGGER.info("Task UID {}, Spanner meter, shutdown connector latency", (Object)this.getTaskUid());
        this.totalLatency.shutdown();
        LOGGER.info("Task UID {}, Spanner meter, shutdown total latency", (Object)this.getTaskUid());
        this.spannerLatency.shutdown();
        LOGGER.info("Task UID {}, Spanner meter, shutdown spanner latency", (Object)this.getTaskUid());
        this.commitToEmitLatency.shutdown();
        LOGGER.info("Task UID {}, Spanner meter, shutdown committoemit latency", (Object)this.getTaskUid());
        this.commitToPublishLatency.shutdown();
        LOGGER.info("Task UID {}, Spanner meter, shutdown committopublish latency", (Object)this.getTaskUid());
        this.emitToPublishLatency.shutdown();
        LOGGER.info("Task UID {}, Spanner meter, shutdown emittopublish latency", (Object)this.getTaskUid());
        this.ownConnectorLatency.shutdown();
        LOGGER.info("Task UID {}, Spanner meter, shutdown ownConnectorLatency latency", (Object)this.getTaskUid());
        this.partitionOffsetLagStatistics.shutdown();
        LOGGER.info("Task UID {}, Spanner meter, shutdown partitionOffsetLagStatistics latency", (Object)this.getTaskUid());
        this.lowWatermarkLagLatency.shutdown();
        LOGGER.info("Task UID {}, Spanner meter, shutdown lowWatermarkLagLatency latency", (Object)this.getTaskUid());
        this.receivingTimeOffsetStatistics.shutdown();
        LOGGER.info("Task UID {}, Spanner meter, shutdown receivingTimeOffsetStatistics", (Object)this.getTaskUid());
        this.delayChangeStreamEvents.shutdown();
        LOGGER.info("Task UID {}, Spanner meter, shutdown delayChangeStreamEvents", (Object)this.getTaskUid());
    }

    public void finishTask() {
        this.spannerConnectorTask.finish();
    }

    public void restartTask() {
        this.spannerConnectorTask.restart();
    }

    public TaskSyncContext getTaskSyncContext() {
        return this.taskSyncContext;
    }

    public String getTaskUid() {
        return this.spannerConnectorTask.getTaskUid();
    }

    public Statistics getTotalLatency() {
        return this.totalLatency;
    }

    public Statistics getConnectorLatency() {
        return this.connectorLatency;
    }

    public Statistics getSpannerLatency() {
        return this.spannerLatency;
    }

    public Statistics getCommitToEmitLatency() {
        return this.commitToEmitLatency;
    }

    public Statistics getCommitToPublishLatency() {
        return this.commitToPublishLatency;
    }

    public Statistics getEmitToPublishLatency() {
        return this.emitToPublishLatency;
    }

    public Statistics getLowWatermarkLagLatency() {
        return this.lowWatermarkLagLatency;
    }

    public Statistics getOwnConnectorLatency() {
        return this.ownConnectorLatency;
    }

    public Statistics getPartitionOffsetLagStatistics() {
        return this.partitionOffsetLagStatistics;
    }

    public Statistics getOffsetReceivingTimeStatistics() {
        return this.receivingTimeOffsetStatistics;
    }

    public Long getLowWatermarkLag() throws InterruptedException {
        if (!this.connectorConfig.isLowWatermarkEnabled()) {
            return null;
        }
        return LatencyCalculator.getTimeBehindLowWatermark(this.lowWatermarkSupplier.get());
    }

    public Timestamp getLowWatermark() throws InterruptedException {
        if (!this.connectorConfig.isLowWatermarkEnabled()) {
            return null;
        }
        return this.lowWatermarkSupplier.get();
    }

    public int getNumberOfPartitionsDetected() {
        return this.detectedPartitionCount.get();
    }

    public int getNumberOfQueriesIssuedTotal() {
        return this.numberOfQueriesIssuedCount.get();
    }

    public int getNumberOfActiveQueries() {
        return this.numberOfActiveQueries.get();
    }

    public int getStuckHeartbeatIntervals() {
        return this.stuckHeartbeatIntervals.get();
    }

    public Statistics getDelayChangeStreamEvents() {
        return this.delayChangeStreamEvents;
    }

    public int getErrorCount() {
        return this.errorCount.get();
    }

    public int getSpannerEventQueueTotalCapacity() {
        return this.spannerEventQueueTotalCapacity.get();
    }

    public int getSpannerEventQueueRemainingCapacity() {
        return this.spannerEventQueueRemainingCapacity.get();
    }

    public int getTaskStateChangeEventQueueRemainingCapacity() {
        return this.taskStateChangeEventQueueRemainingCapacity.get();
    }

    public long getRebalanceGenerationId() {
        return this.taskSyncContext.getRebalanceGenerationId();
    }

    public int getRebalanceAnswersActual() {
        return this.rebalanceAnswersActual.get();
    }

    public int getRebalanceAnswersExpected() {
        return this.rebalanceAnswersExpected.get();
    }

    public boolean isLeader() {
        return this.taskSyncContext.isLeader();
    }
}

