/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner.kafka.internal;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.ConsumerGroupDescription;
import org.apache.kafka.clients.admin.DescribeConsumerGroupsResult;
import org.apache.kafka.clients.admin.MemberDescription;
import org.apache.kafka.common.KafkaFuture;

public class KafkaConsumerAdminService {
    private final AdminClient adminClient;
    private final String consumerGroup;

    public KafkaConsumerAdminService(AdminClient adminClient, String consumerGroup) {
        this.adminClient = adminClient;
        this.consumerGroup = consumerGroup;
    }

    public Set<String> getActiveConsumerGroupMembers() {
        DescribeConsumerGroupsResult describeConsumerGroupsResult = this.adminClient.describeConsumerGroups(List.of(this.consumerGroup));
        Map kafkaFutureMap = describeConsumerGroupsResult.describedGroups();
        Set entries = kafkaFutureMap.entrySet();
        HashSet<String> result = new HashSet<String>();
        for (Map.Entry entry : entries) {
            KafkaFuture value = (KafkaFuture)entry.getValue();
            try {
                ConsumerGroupDescription desc = (ConsumerGroupDescription)value.get();
                Set consumerIds = desc.members().stream().map(MemberDescription::consumerId).collect(Collectors.toSet());
                result.addAll(consumerIds);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }
}

