/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner.task;

import io.debezium.connector.spanner.kafka.internal.model.PartitionState;
import io.debezium.connector.spanner.kafka.internal.model.PartitionStateEnum;
import io.debezium.connector.spanner.kafka.internal.model.TaskState;
import io.debezium.connector.spanner.task.TaskSyncContext;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class TaskStateUtil {
    private TaskStateUtil() {
    }

    public static Map<String, TaskState> filterSurvivedTasksStates(Map<String, TaskState> taskStates, Collection<String> survivedTasksUids) {
        return taskStates.entrySet().stream().filter(e -> survivedTasksUids.contains(e.getKey())).collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public static Map<Boolean, Map<String, TaskState>> splitSurvivedAndObsoleteTaskStates(Map<String, TaskState> taskStates, Collection<String> survivedTasksUids) {
        return taskStates.entrySet().stream().collect(Collectors.partitioningBy(e -> survivedTasksUids.contains(e.getKey()), Collectors.toUnmodifiableMap(Map.Entry::getKey, Map.Entry::getValue)));
    }

    public static long numOwnedAndAssignedPartitions(TaskSyncContext taskSyncContext) {
        Stream<PartitionState> assignedPartitions = taskSyncContext.getTaskStates().values().stream().flatMap(t -> t.getSharedPartitions().stream()).filter(p -> TaskStateUtil.inProgressPartitionState(p.getState())).filter(p -> p.getAssigneeTaskUid().equals(taskSyncContext.getTaskUid()));
        Stream<PartitionState> ownedPartitions = taskSyncContext.getCurrentTaskState().getPartitions().stream().filter(p -> TaskStateUtil.inProgressPartitionState(p.getState()));
        return Stream.concat(ownedPartitions, assignedPartitions).distinct().count();
    }

    public static int totalInProgressPartitions(TaskSyncContext taskSyncContext) {
        return TaskStateUtil.allFilteredPartitionTokens(taskSyncContext, partition -> TaskStateUtil.inProgressPartitionState(partition.getState())).size();
    }

    public static int totalFinishedPartitions(TaskSyncContext taskSyncContext) {
        return TaskStateUtil.allFilteredPartitionTokens(taskSyncContext, partition -> !TaskStateUtil.inProgressPartitionState(partition.getState())).size();
    }

    public static Set<String> allPartitionTokens(TaskSyncContext taskSyncContext) {
        return TaskStateUtil.allFilteredPartitionTokens(taskSyncContext, partition -> true);
    }

    private static Set<String> allFilteredPartitionTokens(TaskSyncContext taskSyncContext, Predicate<PartitionState> partitionFilter) {
        Collection<TaskState> allTaskStates = taskSyncContext.getAllTaskStates().values();
        Set allOwnedPartitions = allTaskStates.stream().flatMap(t -> t.getPartitions().stream()).filter(partitionFilter).map(PartitionState::getToken).collect(Collectors.toSet());
        Set allSharedPartitions = allTaskStates.stream().flatMap(t -> t.getSharedPartitions().stream()).filter(p -> !allOwnedPartitions.contains(p)).filter(partitionFilter).map(PartitionState::getToken).collect(Collectors.toSet());
        HashSet<String> result = new HashSet<String>(allOwnedPartitions.size() + allSharedPartitions.size());
        result.addAll(allOwnedPartitions);
        result.addAll(allSharedPartitions);
        return result;
    }

    public static boolean inProgressPartitionState(PartitionStateEnum state) {
        return state != PartitionStateEnum.FINISHED && state != PartitionStateEnum.REMOVED;
    }
}

