/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner.kafka.internal;

import io.debezium.connector.spanner.SpannerConnectorConfig;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.serialization.StringDeserializer;

public class RebalancingConsumerFactory<K, V> {
    private final SpannerConnectorConfig config;

    public RebalancingConsumerFactory(SpannerConnectorConfig config) {
        this.config = config;
    }

    public SpannerConnectorConfig getConfig() {
        return this.config;
    }

    private Consumer<K, V> createConsumer(String consumerGroup) {
        Properties props = this.config.kafkaProps(Map.of("group.id", consumerGroup, "key.deserializer", StringDeserializer.class.getName(), "value.deserializer", StringDeserializer.class.getName(), "auto.offset.reset", "earliest", "enable.auto.commit", false));
        return new KafkaConsumer(props);
    }

    public Consumer<K, V> createSubscribeConsumer(String consumerGroup, String topic, ConsumerRebalanceListener rebalanceListener) {
        Consumer<K, V> consumer = this.createConsumer(consumerGroup);
        consumer.subscribe(Collections.singletonList(topic), rebalanceListener);
        return consumer;
    }
}

