/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner.metrics.latency;

import com.google.common.util.concurrent.AtomicDouble;
import io.debezium.connector.spanner.metrics.latency.QuantileMeter;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;

public class Statistics {
    private final AtomicLong minValue = new AtomicLong(Long.MAX_VALUE);
    private final AtomicLong maxValue = new AtomicLong(0L);
    private final AtomicDouble averageValue = new AtomicDouble(0.0);
    private final AtomicLong lastValue = new AtomicLong(Long.MAX_VALUE);
    private final AtomicLong count = new AtomicLong(0L);
    private final QuantileMeter quantileMeter;

    public Statistics(Duration percentageMetricsClearInterval, Consumer<Throwable> errorConsumer) {
        this.quantileMeter = new QuantileMeter(percentageMetricsClearInterval, errorConsumer);
    }

    public synchronized void reset() {
        this.minValue.set(Long.MAX_VALUE);
        this.maxValue.set(0L);
        this.averageValue.set(0.0);
        this.lastValue.set(Long.MAX_VALUE);
        this.count.set(0L);
        this.quantileMeter.reset();
    }

    public void start() {
        this.quantileMeter.start();
    }

    public void shutdown() {
        this.quantileMeter.shutdown();
    }

    public synchronized void update(long value) {
        if (this.minValue.get() > value) {
            this.minValue.set(value);
        }
        if (this.maxValue.get() < value) {
            this.maxValue.set(value);
        }
        this.count.incrementAndGet();
        this.averageValue.set((this.averageValue.get() * (double)(this.count.get() - 1L) + (double)value) / (double)this.count.get());
        this.lastValue.set(value);
        this.quantileMeter.addValue(value);
    }

    public Long getMinValue() {
        return this.count.get() == 0L ? null : Long.valueOf(this.minValue.get());
    }

    public Long getMaxValue() {
        return this.count.get() == 0L ? null : Long.valueOf(this.maxValue.get());
    }

    public Double getAverageValue() {
        return this.count.get() == 0L ? null : Double.valueOf(this.averageValue.get());
    }

    public Long getLastValue() {
        return this.count.get() == 0L ? null : Long.valueOf(this.lastValue.get());
    }

    public Double getValueAtP50() {
        return this.quantileMeter.getValueAtQuantile(0.5);
    }

    public Double getValueAtP95() {
        return this.quantileMeter.getValueAtQuantile(0.95);
    }

    public Double getValueAtP99() {
        return this.quantileMeter.getValueAtQuantile(0.99);
    }
}

