/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner.processor;

import com.google.common.annotations.VisibleForTesting;
import io.debezium.config.CommonConnectorConfig;
import io.debezium.connector.spanner.SpannerConnectorConfig;
import io.debezium.connector.spanner.SpannerPartition;
import io.debezium.connector.spanner.context.offset.SpannerOffsetContext;
import io.debezium.connector.spanner.db.model.Mod;
import io.debezium.connector.spanner.db.model.ModType;
import io.debezium.connector.spanner.processor.SourceRecordUtils;
import io.debezium.connector.spanner.schema.KafkaSpannerTableSchema;
import io.debezium.data.Envelope;
import io.debezium.pipeline.AbstractChangeRecordEmitter;
import io.debezium.pipeline.spi.ChangeRecordEmitter;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.pipeline.spi.Partition;
import io.debezium.schema.DataCollectionSchema;
import io.debezium.util.Clock;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.header.ConnectHeaders;

public class SpannerChangeRecordEmitter
extends AbstractChangeRecordEmitter<SpannerPartition, KafkaSpannerTableSchema> {
    private final ModType modType;
    private final Mod mod;
    private final String recordUid;

    public SpannerChangeRecordEmitter(String recordUid, ModType modType, Mod mod, SpannerPartition partition, SpannerOffsetContext offsetContext, Clock clock, SpannerConnectorConfig connectorConfig) {
        super((Partition)partition, (OffsetContext)offsetContext, clock, (CommonConnectorConfig)connectorConfig);
        this.modType = modType;
        this.mod = mod;
        this.recordUid = recordUid;
    }

    public Envelope.Operation getOperation() {
        switch (this.modType) {
            case DELETE: {
                return Envelope.Operation.DELETE;
            }
            case INSERT: {
                return Envelope.Operation.CREATE;
            }
            case UPDATE: {
                return Envelope.Operation.UPDATE;
            }
        }
        throw new IllegalArgumentException("Unsupported operation: " + this.modType);
    }

    public void emitChangeRecords(DataCollectionSchema schema, ChangeRecordEmitter.Receiver<SpannerPartition> receiver) throws InterruptedException {
        KafkaSpannerTableSchema tableSchema = (KafkaSpannerTableSchema)schema;
        Envelope.Operation operation = this.getOperation();
        switch (operation) {
            case CREATE: {
                this.emitCreateRecord(receiver, tableSchema);
                break;
            }
            case UPDATE: {
                this.emitUpdateRecord(receiver, tableSchema);
                break;
            }
            case DELETE: {
                this.emitDeleteRecord(receiver, tableSchema);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported operation: " + operation);
            }
        }
    }

    protected void emitCreateRecord(ChangeRecordEmitter.Receiver<SpannerPartition> receiver, KafkaSpannerTableSchema tableSchema) throws InterruptedException {
        Struct newKey = tableSchema.getKeyStructFromMod(this.mod);
        Struct newValue = tableSchema.getNewValueStructFromMod(this.mod);
        Struct envelope = this.getEnvelopeCreate(tableSchema, newValue);
        receiver.changeRecord((Partition)((SpannerPartition)this.getPartition()), (DataCollectionSchema)tableSchema, Envelope.Operation.CREATE, (Object)newKey, envelope, this.getOffset(), this.getHeaders());
    }

    @VisibleForTesting
    Struct getEnvelopeCreate(KafkaSpannerTableSchema tableSchema, Struct newValue) {
        return tableSchema.getEnvelopeSchema().create((Object)newValue, this.getOffset().getSourceInfo(), this.getClock().currentTimeAsInstant());
    }

    protected void emitUpdateRecord(ChangeRecordEmitter.Receiver<SpannerPartition> receiver, KafkaSpannerTableSchema tableSchema) throws InterruptedException {
        Struct key = tableSchema.getKeyStructFromMod(this.mod);
        Struct newValue = tableSchema.getNewValueStructFromMod(this.mod);
        Struct oldValue = tableSchema.getOldValueStructFromMod(this.mod);
        Struct envelope = this.getEnvelopeUpdate(tableSchema, newValue, oldValue);
        receiver.changeRecord((Partition)((SpannerPartition)this.getPartition()), (DataCollectionSchema)tableSchema, Envelope.Operation.UPDATE, (Object)key, envelope, this.getOffset(), this.getHeaders());
    }

    @VisibleForTesting
    Struct getEnvelopeUpdate(KafkaSpannerTableSchema tableSchema, Struct newValue, Struct oldValue) {
        return tableSchema.getEnvelopeSchema().update((Object)oldValue, newValue, this.getOffset().getSourceInfo(), this.getClock().currentTimeAsInstant());
    }

    protected void emitDeleteRecord(ChangeRecordEmitter.Receiver<SpannerPartition> receiver, KafkaSpannerTableSchema tableSchema) throws InterruptedException {
        Struct oldKey = tableSchema.getKeyStructFromMod(this.mod);
        Struct oldValue = tableSchema.getOldValueStructFromMod(this.mod);
        Struct envelope = this.getEnvelopeDelete(tableSchema, oldValue);
        receiver.changeRecord((Partition)((SpannerPartition)this.getPartition()), (DataCollectionSchema)tableSchema, Envelope.Operation.DELETE, (Object)oldKey, envelope, this.getOffset(), this.getHeaders());
    }

    @VisibleForTesting
    Struct getEnvelopeDelete(KafkaSpannerTableSchema tableSchema, Struct oldValue) {
        return tableSchema.getEnvelopeSchema().delete((Object)oldValue, this.getOffset().getSourceInfo(), this.getClock().currentTimeAsInstant());
    }

    protected void emitReadRecord(ChangeRecordEmitter.Receiver<SpannerPartition> receiver, KafkaSpannerTableSchema tableSchema) {
        throw new UnsupportedOperationException("Unsupported read operation");
    }

    private ConnectHeaders getHeaders() {
        return SourceRecordUtils.from(this.recordUid);
    }
}

