/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner.config.validation;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.debezium.config.Configuration;
import io.debezium.config.Field;
import java.io.File;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldValidator {
    private static final Logger LOGGER = LoggerFactory.getLogger(FieldValidator.class);
    private static final String HEARTBEAT_INTERVAL_LIMITATIONS_MSG = "Heartbeat interval must be between 100 and 300000";
    private static final String FIELD_NOT_SPECIFIED_MSG = "The field is not specified";
    private static final String VALUE_IS_INVALID_MSG = "The '{}' value is invalid: {}";
    private static final String PATH_FIELD_INCORRECT_MSG = "path field is incorrect";
    private static final String JSON_FIELD_DATA_INCORRECT_MSG = "JSON field data is incorrect";
    private static final String INVALID_DATE_MSG = "Invalid date. Should be with format yyyy-MM-dd'T'HH:mm:ssZ";
    private static final String ONLY_OLD_AND_NEW_VALUES_ALLOWED = "Only OLD_AND_NEW_VALUES is allowed";

    private FieldValidator() {
    }

    public static int isCorrectHeartBeatInterval(Configuration config, Field field, Field.ValidationOutput problems) {
        long interval = config.getLong(field);
        if (interval > 300000L || interval < 100L) {
            problems.accept(field, (Object)interval, HEARTBEAT_INTERVAL_LIMITATIONS_MSG);
            return 1;
        }
        return 0;
    }

    public static int isNotBlank(Configuration config, Field field, Field.ValidationOutput problems) {
        String value = config.getString(field);
        if (!FieldValidator.isSpecified(value)) {
            String errorMsg = FIELD_NOT_SPECIFIED_MSG;
            LOGGER.error(VALUE_IS_INVALID_MSG, (Object)field, (Object)errorMsg);
            problems.accept(field, (Object)value, errorMsg);
            return 1;
        }
        return 0;
    }

    public static int isCorrectPath(Configuration config, Field field, Field.ValidationOutput problems) {
        String value = config.getString(field);
        if (value == null) {
            return 0;
        }
        File file = new File(value);
        if (!file.exists() || file.isDirectory()) {
            problems.accept(field, (Object)value, PATH_FIELD_INCORRECT_MSG);
            return 1;
        }
        return 0;
    }

    public static int isCorrectJson(Configuration config, Field field, Field.ValidationOutput problems) {
        String value = config.getString(field);
        if (value == null) {
            return 0;
        }
        if (value.isBlank()) {
            problems.accept(field, (Object)value, JSON_FIELD_DATA_INCORRECT_MSG);
            return 1;
        }
        try {
            new ObjectMapper().readTree(value);
        }
        catch (JsonProcessingException e) {
            problems.accept(field, (Object)value, JSON_FIELD_DATA_INCORRECT_MSG);
            return 1;
        }
        return 0;
    }

    public static int isCorrectCaptureMode(Configuration config, Field field, Field.ValidationOutput problems) {
        String value = config.getString(field);
        if (value != null && !"OLD_AND_NEW_VALUES".equals(value)) {
            String errorMsg = ONLY_OLD_AND_NEW_VALUES_ALLOWED;
            LOGGER.error(VALUE_IS_INVALID_MSG, (Object)field, (Object)errorMsg);
            problems.accept(field, (Object)value, errorMsg);
            return 1;
        }
        return 0;
    }

    public static int isCorrectDateTime(Configuration config, Field field, Field.ValidationOutput problems) {
        String dateTime = config.getString(field);
        if (dateTime == null) {
            return 0;
        }
        try {
            DateTimeFormatter.ISO_INSTANT.parse(dateTime);
        }
        catch (Exception ex) {
            problems.accept(field, (Object)dateTime, INVALID_DATE_MSG);
            return 1;
        }
        return 0;
    }

    public static boolean isSpecified(String value) {
        return !Objects.isNull(value) && !value.isBlank();
    }
}

