/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner;

import io.debezium.connector.spanner.FinishingPartitionManager;
import io.debezium.util.Clock;
import io.debezium.util.Metronome;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FinishPartitionWatchDog {
    private static final Logger LOGGER = LoggerFactory.getLogger(FinishPartitionWatchDog.class);
    private volatile Thread thread;
    private final Map<String, Instant> partition = new HashMap<String, Instant>();
    private final Duration pollInterval = Duration.ofMillis(60000L);
    private final Duration sleepInterval = Duration.ofMillis(100L);
    private final Clock clock = Clock.system();

    public FinishPartitionWatchDog(FinishingPartitionManager finishingPartitionManager, Duration timeout, Consumer<List<String>> errorHandler) {
        this.thread = new Thread(() -> {
            Metronome metronome = Metronome.sleeper((Duration)this.pollInterval, (Clock)this.clock);
            Instant lastUpdatedTime = Instant.now();
            while (!Thread.currentThread().isInterrupted()) {
                Set<String> pendingToFinish = finishingPartitionManager.getPendingFinishPartitions();
                Set<String> pending = finishingPartitionManager.getPendingPartitions();
                pendingToFinish.forEach(token -> this.partition.computeIfAbsent((String)token, token1 -> Instant.now()));
                if (Instant.now().isAfter(lastUpdatedTime.plus(Duration.ofSeconds(600L)))) {
                    LOGGER.info("Get pending partitions: {}", pendingToFinish);
                    LOGGER.info("Get pending total partitions: {}", pending);
                    lastUpdatedTime = Instant.now();
                }
                Iterator<Map.Entry<String, Instant>> itr = this.partition.entrySet().iterator();
                while (itr.hasNext()) {
                    Map.Entry<String, Instant> entry = itr.next();
                    if (pendingToFinish.contains(entry.getKey())) continue;
                    itr.remove();
                }
                ArrayList tokens = new ArrayList();
                Instant currentTime = Instant.now();
                this.partition.forEach((token, instant) -> {
                    if (currentTime.isAfter(instant.plus(timeout))) {
                        tokens.add(token);
                    }
                });
                if (!tokens.isEmpty()) {
                    LOGGER.warn("Partitions awaiting finish : {}, timeout: {}", tokens, (Object)timeout);
                    errorHandler.accept(tokens);
                }
                try {
                    metronome.pause();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return;
                }
            }
        }, "SpannerConnector-FinishingPartitionWatchDog");
        this.thread.start();
    }

    public void stop() {
        LOGGER.info("Interrupting SpannerConnector-FinishingPartitionWatchDog");
        this.thread.interrupt();
        Metronome metronome = Metronome.sleeper((Duration)this.sleepInterval, (Clock)this.clock);
        while (!this.thread.getState().equals((Object)Thread.State.TERMINATED)) {
            try {
                metronome.pause();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        this.thread = null;
    }
}

