/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner.db.model.schema;

import com.google.cloud.spanner.Dialect;
import com.google.common.base.Objects;
import io.debezium.connector.spanner.db.model.schema.ColumnType;
import io.debezium.connector.spanner.db.model.schema.DataType;

public class Column {
    private final String name;
    private final ColumnType type;
    private final boolean primaryKey;
    private final long ordinalPosition;
    private final Boolean nullable;

    public Column(String name, ColumnType type, boolean primaryKey, long ordinalPosition, Boolean nullable) {
        this.name = name;
        this.type = type;
        this.primaryKey = primaryKey;
        this.ordinalPosition = ordinalPosition;
        this.nullable = nullable;
    }

    public String getName() {
        return this.name;
    }

    public ColumnType getType() {
        return this.type;
    }

    public boolean isPrimaryKey() {
        return this.primaryKey;
    }

    public long getOrdinalPosition() {
        return this.ordinalPosition;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public static Column create(String name, String spannerType, boolean primaryKey, long ordinalPosition, boolean nullable, Dialect dialect) {
        return new Column(name, Column.parseColumnType(spannerType, dialect), primaryKey, ordinalPosition, nullable);
    }

    private static ColumnType parseColumnType(String spannerType, Dialect dialect) {
        spannerType = spannerType.toUpperCase();
        switch (dialect) {
            case GOOGLE_STANDARD_SQL: {
                if ("BOOL".equals(spannerType)) {
                    return new ColumnType(DataType.BOOL);
                }
                if ("INT64".equals(spannerType)) {
                    return new ColumnType(DataType.INT64);
                }
                if ("FLOAT64".equals(spannerType)) {
                    return new ColumnType(DataType.FLOAT64);
                }
                if (spannerType.startsWith("STRING")) {
                    return new ColumnType(DataType.STRING);
                }
                if (spannerType.startsWith("BYTES")) {
                    return new ColumnType(DataType.BYTES);
                }
                if ("TIMESTAMP".equals(spannerType)) {
                    return new ColumnType(DataType.TIMESTAMP);
                }
                if ("DATE".equals(spannerType)) {
                    return new ColumnType(DataType.DATE);
                }
                if ("NUMERIC".equals(spannerType)) {
                    return new ColumnType(DataType.NUMERIC);
                }
                if ("JSON".equals(spannerType)) {
                    return new ColumnType(DataType.JSON);
                }
                if (spannerType.startsWith("ARRAY")) {
                    String spannerArrayType = spannerType.substring(6, spannerType.length() - 1);
                    ColumnType itemType = Column.parseColumnType(spannerArrayType, dialect);
                    return new ColumnType(DataType.ARRAY, itemType);
                }
                throw new IllegalArgumentException("Unknown spanner type " + spannerType);
            }
            case POSTGRESQL: {
                if (spannerType.endsWith("[]")) {
                    String spannerArrayType = spannerType.substring(0, spannerType.length() - 2);
                    ColumnType itemType = Column.parseColumnType(spannerArrayType, dialect);
                    return new ColumnType(DataType.ARRAY, itemType);
                }
                if ("BOOLEAN".equals(spannerType)) {
                    return new ColumnType(DataType.BOOL);
                }
                if ("BIGINT".equals(spannerType)) {
                    return new ColumnType(DataType.INT64);
                }
                if ("DOUBLE PRECISION".equals(spannerType)) {
                    return new ColumnType(DataType.FLOAT64);
                }
                if (spannerType.startsWith("CHARACTER VARYING") || "TEXT".equals(spannerType)) {
                    return new ColumnType(DataType.STRING);
                }
                if ("BYTEA".equals(spannerType)) {
                    return new ColumnType(DataType.BYTES);
                }
                if ("TIMESTAMP WITH TIME ZONE".equals(spannerType)) {
                    return new ColumnType(DataType.TIMESTAMP);
                }
                if ("DATE".equals(spannerType)) {
                    return new ColumnType(DataType.DATE);
                }
                if (spannerType.startsWith("NUMERIC")) {
                    return new ColumnType(DataType.NUMERIC);
                }
                if ("SPANNER.COMMIT_TIMESTAMP".equals(spannerType)) {
                    return new ColumnType(DataType.TIMESTAMP);
                }
                if ("JSONB".equals(spannerType)) {
                    return new ColumnType(DataType.JSON);
                }
                throw new IllegalArgumentException("Unknown spanner type " + spannerType);
            }
        }
        throw new IllegalArgumentException("Unrecognized dialect: " + dialect.name());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Column column = (Column)o;
        return this.primaryKey == column.primaryKey && this.ordinalPosition == column.ordinalPosition && Objects.equal((Object)this.name, (Object)column.name) && Objects.equal((Object)this.type, (Object)column.type);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name, this.type, this.primaryKey, this.ordinalPosition});
    }
}

