/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner.db.mapper;

import com.google.cloud.Timestamp;
import com.google.cloud.spanner.Dialect;
import com.google.cloud.spanner.Struct;
import com.google.cloud.spanner.Type;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Sets;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.Value;
import com.google.protobuf.util.JsonFormat;
import io.debezium.connector.spanner.db.dao.ChangeStreamResultSet;
import io.debezium.connector.spanner.db.dao.ChangeStreamResultSetMetadata;
import io.debezium.connector.spanner.db.mapper.MapperUtils;
import io.debezium.connector.spanner.db.mapper.parser.ColumnTypeParser;
import io.debezium.connector.spanner.db.model.ChildPartition;
import io.debezium.connector.spanner.db.model.InitialPartition;
import io.debezium.connector.spanner.db.model.Mod;
import io.debezium.connector.spanner.db.model.ModType;
import io.debezium.connector.spanner.db.model.Partition;
import io.debezium.connector.spanner.db.model.StreamEventMetadata;
import io.debezium.connector.spanner.db.model.ValueCaptureType;
import io.debezium.connector.spanner.db.model.event.ChangeStreamEvent;
import io.debezium.connector.spanner.db.model.event.ChildPartitionsEvent;
import io.debezium.connector.spanner.db.model.event.DataChangeEvent;
import io.debezium.connector.spanner.db.model.event.HeartbeatEvent;
import io.debezium.connector.spanner.db.model.schema.Column;
import io.debezium.connector.spanner.db.model.schema.ColumnType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ChangeStreamRecordMapper {
    private final JsonFormat.Printer printer;
    private final JsonFormat.Parser parser;
    private static final String DATA_CHANGE_RECORD_COLUMN = "data_change_record";
    private static final String HEARTBEAT_RECORD_COLUMN = "heartbeat_record";
    private static final String CHILD_PARTITIONS_RECORD_COLUMN = "child_partitions_record";
    private static final String COMMIT_TIMESTAMP_COLUMN = "commit_timestamp";
    private static final String SERVER_TRANSACTION_ID_COLUMN = "server_transaction_id";
    private static final String IS_LAST_RECORD_IN_TRANSACTION_IN_PARTITION_COLUMN = "is_last_record_in_transaction_in_partition";
    private static final String RECORD_SEQUENCE_COLUMN = "record_sequence";
    private static final String TABLE_NAME_COLUMN = "table_name";
    private static final String COLUMN_TYPES_COLUMN = "column_types";
    private static final String MODS_COLUMN = "mods";
    private static final String MOD_TYPE_COLUMN = "mod_type";
    private static final String VALUE_CAPTURE_TYPE_COLUMN = "value_capture_type";
    private static final String NUMBER_OF_RECORDS_IN_TRANSACTION_COLUMN = "number_of_records_in_transaction";
    private static final String NUMBER_OF_PARTITIONS_IN_TRANSACTION_COLUMN = "number_of_partitions_in_transaction";
    private static final String NAME_COLUMN = "name";
    private static final String TYPE_COLUMN = "type";
    private static final String IS_PRIMARY_KEY_COLUMN = "is_primary_key";
    private static final String ORDINAL_POSITION_COLUMN = "ordinal_position";
    private static final String KEYS_COLUMN = "keys";
    private static final String OLD_VALUES_COLUMN = "old_values";
    private static final String NEW_VALUES_COLUMN = "new_values";
    private static final String TIMESTAMP_COLUMN = "timestamp";
    private static final String START_TIMESTAMP_COLUMN = "start_timestamp";
    private static final String CHILD_PARTITIONS_COLUMN = "child_partitions";
    private static final String PARENT_PARTITION_TOKENS_COLUMN = "parent_partition_tokens";
    private static final String TOKEN_COLUMN = "token";
    private static final String TRANSACTION_TAG = "transaction_tag";
    private static final String SYSTEM_TRANSACTION = "is_system_transaction";
    private final Dialect dialect;

    public ChangeStreamRecordMapper(Dialect dialect) {
        this.dialect = dialect;
        this.printer = JsonFormat.printer().preservingProtoFieldNames().omittingInsignificantWhitespace();
        this.parser = JsonFormat.parser().ignoringUnknownFields();
    }

    public List<ChangeStreamEvent> toChangeStreamEvents(Partition partition, ChangeStreamResultSet resultSet, ChangeStreamResultSetMetadata resultSetMetadata) {
        if (this.isPostgres()) {
            return Collections.singletonList(this.toStreamEventJson(partition, resultSet.getPgJsonb(0), resultSetMetadata));
        }
        return resultSet.getCurrentRowAsStruct().getStructList(0).stream().flatMap(struct -> this.toStreamEvent(partition, (Struct)struct, resultSetMetadata)).collect(Collectors.toList());
    }

    Stream<ChangeStreamEvent> toStreamEvent(Partition partition, Struct row, ChangeStreamResultSetMetadata resultSetMetadata) {
        Stream<DataChangeEvent> dataChangeEvents = row.getStructList(DATA_CHANGE_RECORD_COLUMN).stream().filter(this::isNonNullDataChangeRecord).map(struct -> this.toDataChangeEvent(partition, (Struct)struct, resultSetMetadata));
        Stream<HeartbeatEvent> heartbeatEvents = row.getStructList(HEARTBEAT_RECORD_COLUMN).stream().filter(this::isNonNullHeartbeatRecord).map(struct -> this.toHeartbeatEvent(partition, (Struct)struct, resultSetMetadata));
        Stream<ChildPartitionsEvent> childPartitionsEvents = row.getStructList(CHILD_PARTITIONS_RECORD_COLUMN).stream().filter(this::isNonNullChildPartitionsRecord).map(struct -> this.toChildPartitionsEvent(partition, (Struct)struct, resultSetMetadata));
        return Stream.concat(Stream.concat(dataChangeEvents, heartbeatEvents), childPartitionsEvents);
    }

    ChangeStreamEvent toStreamEventJson(Partition partition, String row, ChangeStreamResultSetMetadata resultSetMetadata) {
        Value.Builder valueBuilder = Value.newBuilder();
        try {
            this.parser.merge(row, (Message.Builder)valueBuilder);
        }
        catch (InvalidProtocolBufferException exc) {
            throw new IllegalArgumentException("Failed to parse record into proto: " + row);
        }
        Value value = valueBuilder.build();
        if (this.isNonNullDataChangeRecordJson(value)) {
            return this.toDataChangeEventJson(partition, value, resultSetMetadata);
        }
        if (this.isNonNullHeartbeatRecordJson(value)) {
            return this.toHeartbeatRecordJson(partition, value, resultSetMetadata);
        }
        if (this.isNonNullChildPartitionsRecordJson(value)) {
            return this.toChildPartitionsRecordJson(partition, value, resultSetMetadata);
        }
        throw new IllegalArgumentException("Unknown change stream record type " + row);
    }

    private HeartbeatEvent toHeartbeatRecordJson(Partition partition, Value row, ChangeStreamResultSetMetadata resultSetMetadata) {
        Value heartBeatRecordValue = Optional.ofNullable((Value)row.getStructValue().getFieldsMap().get(HEARTBEAT_RECORD_COLUMN)).orElseThrow(IllegalArgumentException::new);
        Map valueMap = heartBeatRecordValue.getStructValue().getFieldsMap();
        String heartbeatTimestamp = Optional.ofNullable((Value)valueMap.get(TIMESTAMP_COLUMN)).orElseThrow(IllegalArgumentException::new).getStringValue();
        return new HeartbeatEvent(Timestamp.parseTimestamp((String)heartbeatTimestamp), this.streamEventMetadataFrom(partition, Timestamp.parseTimestamp((String)heartbeatTimestamp), resultSetMetadata));
    }

    private ChildPartitionsEvent toChildPartitionsRecordJson(Partition partition, Value row, ChangeStreamResultSetMetadata resultSetMetadata) {
        Value childPartitionsRecordValue = Optional.ofNullable((Value)row.getStructValue().getFieldsMap().get(CHILD_PARTITIONS_RECORD_COLUMN)).orElseThrow(IllegalArgumentException::new);
        Map valueMap = childPartitionsRecordValue.getStructValue().getFieldsMap();
        String startTimestamp = Optional.ofNullable((Value)valueMap.get(START_TIMESTAMP_COLUMN)).orElseThrow(IllegalArgumentException::new).getStringValue();
        return new ChildPartitionsEvent(Timestamp.parseTimestamp((String)startTimestamp), Optional.ofNullable((Value)valueMap.get(RECORD_SEQUENCE_COLUMN)).orElseThrow(IllegalArgumentException::new).getStringValue(), Optional.ofNullable((Value)valueMap.get(CHILD_PARTITIONS_COLUMN)).orElseThrow(IllegalArgumentException::new).getListValue().getValuesList().stream().map(value -> this.childPartitionJsonFrom(partition.getToken(), (Value)value)).collect(Collectors.toList()), this.streamEventMetadataFrom(partition, Timestamp.parseTimestamp((String)startTimestamp), resultSetMetadata));
    }

    private ChildPartition childPartitionJsonFrom(String partitionToken, Value row) {
        Map valueMap = row.getStructValue().getFieldsMap();
        HashSet parentTokens = Sets.newHashSet();
        for (Value parentToken : Optional.ofNullable((Value)valueMap.get(PARENT_PARTITION_TOKENS_COLUMN)).orElseThrow(IllegalArgumentException::new).getListValue().getValuesList()) {
            parentTokens.add(parentToken.getStringValue());
        }
        if (InitialPartition.isInitialPartition(partitionToken)) {
            parentTokens.add(partitionToken);
        }
        return new ChildPartition(Optional.ofNullable((Value)valueMap.get(TOKEN_COLUMN)).orElseThrow(IllegalArgumentException::new).getStringValue(), parentTokens);
    }

    private boolean isNonNullDataChangeRecordJson(Value row) {
        return row.getStructValue().getFieldsMap().containsKey(DATA_CHANGE_RECORD_COLUMN);
    }

    boolean isNonNullDataChangeRecord(Struct row) {
        return !row.isNull(COMMIT_TIMESTAMP_COLUMN);
    }

    boolean isNonNullHeartbeatRecord(Struct row) {
        return !row.isNull(TIMESTAMP_COLUMN);
    }

    boolean isNonNullChildPartitionsRecord(Struct row) {
        return !row.isNull(START_TIMESTAMP_COLUMN);
    }

    private boolean isNonNullHeartbeatRecordJson(Value row) {
        return row.getStructValue().getFieldsMap().containsKey(HEARTBEAT_RECORD_COLUMN);
    }

    private boolean isNonNullChildPartitionsRecordJson(Value row) {
        return row.getStructValue().getFieldsMap().containsKey(CHILD_PARTITIONS_RECORD_COLUMN);
    }

    DataChangeEvent toDataChangeEvent(Partition partition, Struct row, ChangeStreamResultSetMetadata resultSetMetadata) {
        Timestamp commitTimestamp = row.getTimestamp(COMMIT_TIMESTAMP_COLUMN);
        return new DataChangeEvent(partition.getToken(), commitTimestamp, row.getString(SERVER_TRANSACTION_ID_COLUMN), row.getBoolean(IS_LAST_RECORD_IN_TRANSACTION_IN_PARTITION_COLUMN), row.getString(RECORD_SEQUENCE_COLUMN), row.getString(TABLE_NAME_COLUMN), row.getStructList(COLUMN_TYPES_COLUMN).stream().map(this::columnTypeFrom).collect(Collectors.toList()), this.modListFrom(row.getStructList(MODS_COLUMN)), this.modTypeFrom(row.getString(MOD_TYPE_COLUMN)), this.valueCaptureTypeFrom(row.getString(VALUE_CAPTURE_TYPE_COLUMN)), row.getLong(NUMBER_OF_RECORDS_IN_TRANSACTION_COLUMN), row.getLong(NUMBER_OF_PARTITIONS_IN_TRANSACTION_COLUMN), row.getString(TRANSACTION_TAG), row.getBoolean(SYSTEM_TRANSACTION), this.streamEventMetadataFrom(partition, commitTimestamp, resultSetMetadata));
    }

    DataChangeEvent toDataChangeEventJson(Partition partition, Value row, ChangeStreamResultSetMetadata resultSetMetadata) {
        Value dataChangeRecordValue = Optional.ofNullable((Value)row.getStructValue().getFieldsMap().get(DATA_CHANGE_RECORD_COLUMN)).orElseThrow(IllegalArgumentException::new);
        Map valueMap = dataChangeRecordValue.getStructValue().getFieldsMap();
        String commitTimestamp = Optional.ofNullable((Value)valueMap.get(COMMIT_TIMESTAMP_COLUMN)).orElseThrow(IllegalArgumentException::new).getStringValue();
        AtomicInteger modIndex = new AtomicInteger();
        List<Mod> mods = Optional.ofNullable((Value)valueMap.get(MODS_COLUMN)).orElseThrow(IllegalArgumentException::new).getListValue().getValuesList().stream().map(mod -> {
            modIndex.getAndIncrement();
            return this.modJsonFrom((Value)mod, modIndex.get());
        }).collect(Collectors.toList());
        return new DataChangeEvent(partition.getToken(), Timestamp.parseTimestamp((String)commitTimestamp), Optional.ofNullable((Value)valueMap.get(SERVER_TRANSACTION_ID_COLUMN)).orElseThrow(IllegalArgumentException::new).getStringValue(), Optional.ofNullable((Value)valueMap.get(IS_LAST_RECORD_IN_TRANSACTION_IN_PARTITION_COLUMN)).orElseThrow(IllegalArgumentException::new).getBoolValue(), Optional.ofNullable((Value)valueMap.get(RECORD_SEQUENCE_COLUMN)).orElseThrow(IllegalArgumentException::new).getStringValue(), Optional.ofNullable((Value)valueMap.get(TABLE_NAME_COLUMN)).orElseThrow(IllegalArgumentException::new).getStringValue(), Optional.ofNullable((Value)valueMap.get(COLUMN_TYPES_COLUMN)).orElseThrow(IllegalArgumentException::new).getListValue().getValuesList().stream().map(this::columnTypeJsonFrom).collect(Collectors.toList()), mods, this.modTypeFrom(Optional.ofNullable((Value)valueMap.get(MOD_TYPE_COLUMN)).orElseThrow(IllegalArgumentException::new).getStringValue()), this.valueCaptureTypeFrom(Optional.ofNullable((Value)valueMap.get(VALUE_CAPTURE_TYPE_COLUMN)).orElseThrow(IllegalArgumentException::new).getStringValue()), (long)Optional.ofNullable((Value)valueMap.get(NUMBER_OF_RECORDS_IN_TRANSACTION_COLUMN)).orElseThrow(IllegalArgumentException::new).getNumberValue(), (long)Optional.ofNullable((Value)valueMap.get(NUMBER_OF_PARTITIONS_IN_TRANSACTION_COLUMN)).orElseThrow(IllegalArgumentException::new).getNumberValue(), Optional.ofNullable((Value)valueMap.get(TRANSACTION_TAG)).orElseThrow(IllegalArgumentException::new).getStringValue(), Optional.ofNullable((Value)valueMap.get(SYSTEM_TRANSACTION)).orElseThrow(IllegalArgumentException::new).getBoolValue(), this.streamEventMetadataFrom(partition, Timestamp.parseTimestamp((String)commitTimestamp), resultSetMetadata));
    }

    private Column columnTypeJsonFrom(Value row) {
        Map valueMap = row.getStructValue().getFieldsMap();
        try {
            String type = this.printer.print((MessageOrBuilder)Optional.ofNullable((Value)valueMap.get(TYPE_COLUMN)).orElseThrow(IllegalArgumentException::new));
            ColumnType columnType = ColumnTypeParser.parse(type);
            return new Column(Optional.ofNullable((Value)valueMap.get(NAME_COLUMN)).orElseThrow(IllegalArgumentException::new).getStringValue(), columnType, Optional.ofNullable((Value)valueMap.get(IS_PRIMARY_KEY_COLUMN)).orElseThrow(IllegalArgumentException::new).getBoolValue(), (long)Optional.ofNullable((Value)valueMap.get(ORDINAL_POSITION_COLUMN)).orElseThrow(IllegalArgumentException::new).getNumberValue(), null);
        }
        catch (InvalidProtocolBufferException exc) {
            throw new IllegalArgumentException("Failed to print type: " + row);
        }
    }

    private Mod modJsonFrom(Value row, int modNumber) {
        try {
            Map valueMap = row.getStructValue().getFieldsMap();
            String keys = this.printer.print((MessageOrBuilder)Optional.ofNullable((Value)valueMap.get(KEYS_COLUMN)).orElseThrow(IllegalArgumentException::new));
            String oldValues = !valueMap.containsKey(OLD_VALUES_COLUMN) ? null : this.printer.print((MessageOrBuilder)Optional.ofNullable((Value)valueMap.get(OLD_VALUES_COLUMN)).orElseThrow(IllegalArgumentException::new));
            String newValues = !valueMap.containsKey(NEW_VALUES_COLUMN) ? null : this.printer.print((MessageOrBuilder)Optional.ofNullable((Value)valueMap.get(NEW_VALUES_COLUMN)).orElseThrow(IllegalArgumentException::new));
            return new Mod(modNumber, MapperUtils.getJsonNode(keys), MapperUtils.getJsonNode(oldValues), MapperUtils.getJsonNode(newValues));
        }
        catch (InvalidProtocolBufferException exc) {
            throw new IllegalArgumentException("Failed to print mod: " + row);
        }
    }

    private ValueCaptureType valueCaptureTypeFrom(String name) {
        try {
            return ValueCaptureType.valueOf(name);
        }
        catch (IllegalArgumentException e) {
            return ValueCaptureType.UNKNOWN;
        }
    }

    private ModType modTypeFrom(String name) {
        try {
            return ModType.valueOf(name);
        }
        catch (IllegalArgumentException e) {
            return ModType.UNKNOWN;
        }
    }

    @VisibleForTesting
    HeartbeatEvent toHeartbeatEvent(Partition partition, Struct row, ChangeStreamResultSetMetadata resultSetMetadata) {
        Timestamp timestamp = row.getTimestamp(TIMESTAMP_COLUMN);
        return new HeartbeatEvent(timestamp, this.streamEventMetadataFrom(partition, timestamp, resultSetMetadata));
    }

    @VisibleForTesting
    ChildPartitionsEvent toChildPartitionsEvent(Partition partition, Struct row, ChangeStreamResultSetMetadata resultSetMetadata) {
        Timestamp startTimestamp = row.getTimestamp(START_TIMESTAMP_COLUMN);
        return new ChildPartitionsEvent(startTimestamp, row.getString(RECORD_SEQUENCE_COLUMN), row.getStructList(CHILD_PARTITIONS_COLUMN).stream().map(struct -> this.childPartitionFrom(partition.getToken(), (Struct)struct)).collect(Collectors.toList()), this.streamEventMetadataFrom(partition, startTimestamp, resultSetMetadata));
    }

    @VisibleForTesting
    Column columnTypeFrom(Struct struct) {
        String type = this.getJsonString(struct, TYPE_COLUMN);
        ColumnType columnType = ColumnTypeParser.parse(type);
        return new Column(struct.getString(NAME_COLUMN), columnType, struct.getBoolean(IS_PRIMARY_KEY_COLUMN), struct.getLong(ORDINAL_POSITION_COLUMN), null);
    }

    List<Mod> modListFrom(List<Struct> list) {
        ArrayList<Mod> mods = new ArrayList<Mod>(list.size());
        for (Struct struct : list) {
            mods.add(this.modFrom(mods.size(), struct));
        }
        return mods;
    }

    @VisibleForTesting
    Mod modFrom(int modNumber, Struct struct) {
        String keys = this.getJsonString(struct, KEYS_COLUMN);
        String oldValues = struct.isNull(OLD_VALUES_COLUMN) ? null : this.getJsonString(struct, OLD_VALUES_COLUMN);
        String newValues = struct.isNull(NEW_VALUES_COLUMN) ? null : this.getJsonString(struct, NEW_VALUES_COLUMN);
        return new Mod(modNumber, MapperUtils.getJsonNode(keys), MapperUtils.getJsonNode(oldValues), MapperUtils.getJsonNode(newValues));
    }

    @VisibleForTesting
    ChildPartition childPartitionFrom(String partitionToken, Struct struct) {
        HashSet<String> parentTokens = new HashSet<String>(struct.getStringList(PARENT_PARTITION_TOKENS_COLUMN));
        if (InitialPartition.isInitialPartition(partitionToken)) {
            parentTokens.add(partitionToken);
        }
        return new ChildPartition(struct.getString(TOKEN_COLUMN), Collections.unmodifiableSet(parentTokens));
    }

    @VisibleForTesting
    StreamEventMetadata streamEventMetadataFrom(Partition partition, Timestamp recordTimestamp, ChangeStreamResultSetMetadata resultSetMetadata) {
        return StreamEventMetadata.newBuilder().withRecordTimestamp(recordTimestamp).withPartitionToken(partition.getToken()).withPartitionStartTimestamp(partition.getStartTimestamp()).withPartitionEndTimestamp(partition.getEndTimestamp()).withQueryStartedAt(resultSetMetadata.getQueryStartedAt()).withRecordStreamStartedAt(resultSetMetadata.getRecordStreamStartedAt()).withRecordStreamEndedAt(resultSetMetadata.getRecordStreamEndedAt()).withRecordReadAt(resultSetMetadata.getRecordReadAt()).withTotalStreamTimeMillis(resultSetMetadata.getTotalStreamDuration().getMillis()).withNumberOfRecordsRead(resultSetMetadata.getNumberOfRecordsRead()).build();
    }

    @VisibleForTesting
    String getJsonString(Struct struct, String columnName) {
        if (struct.getColumnType(columnName).equals((Object)Type.json())) {
            return struct.getJson(columnName);
        }
        if (struct.getColumnType(columnName).equals((Object)Type.string())) {
            return struct.getString(columnName);
        }
        throw new IllegalArgumentException("Can not extract string from value " + columnName);
    }

    private boolean isPostgres() {
        return this.dialect == Dialect.POSTGRESQL;
    }
}

