/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner.kafka.internal;

import io.debezium.connector.spanner.SpannerConnectorConfig;
import io.debezium.connector.spanner.kafka.KafkaUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.DescribeTopicsResult;
import org.apache.kafka.clients.admin.NewPartitions;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.KafkaFuture;

public class KafkaInternalTopicAdminService {
    private final AdminClient adminClient;
    private final SpannerConnectorConfig config;

    public KafkaInternalTopicAdminService(AdminClient adminClient, SpannerConnectorConfig config) {
        this.adminClient = adminClient;
        this.config = config;
    }

    public void createAdjustRebalanceTopic() {
        try {
            String rebalancingTopic = this.config.rebalancingTopic();
            int maxTasks = this.config.getMaxTasks();
            Map rebalancingTopicPassThroughProps = this.config.getConfig().subset("connector.spanner.rebalancing.topic.config.", true).asMap();
            if (!this.topicExists(rebalancingTopic)) {
                this.createTopic(rebalancingTopic, Optional.of(maxTasks), rebalancingTopicPassThroughProps);
                return;
            }
            if (this.partitionCount(rebalancingTopic) < maxTasks) {
                this.increasePartitions(rebalancingTopic, maxTasks);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            throw new KafkaException((Throwable)e);
        }
    }

    public void createVerifySyncTopic() {
        try {
            String syncTopic = this.config.taskSyncTopic();
            if (!this.topicExists(syncTopic)) {
                HashMap<String, String> topicProps = new HashMap<String, String>();
                topicProps.put("cleanup.policy", this.config.syncCleanupPolicy());
                topicProps.put("retention.ms", String.valueOf(this.config.syncRetentionMs()));
                topicProps.put("segment.ms", String.valueOf(this.config.syncSegmentMs()));
                topicProps.put("min.cleanable.dirty.ratio", this.config.syncMinCleanableDirtyRatio());
                topicProps.put("max.message.bytes", this.config.syncTopicMaxMessageSize());
                Map syncTopicPassThroughProps = this.config.getConfig().subset("connector.spanner.sync.topic.config.", true).asMap();
                if (!syncTopicPassThroughProps.isEmpty()) {
                    topicProps.putAll(syncTopicPassThroughProps);
                }
                this.createTopic(syncTopic, Optional.of(1), topicProps);
                return;
            }
            if (this.partitionCount(syncTopic) != 1) {
                throw new IllegalStateException("Sync topic must only contain 1 partition");
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            throw new KafkaException((Throwable)e);
        }
    }

    private boolean topicExists(String topic) throws ExecutionException, InterruptedException {
        return KafkaUtils.topicExists(this.adminClient, topic);
    }

    private void createTopic(String topic, Optional<Integer> numPartitions, Map<String, String> configs) throws ExecutionException, InterruptedException {
        KafkaUtils.createTopic(this.adminClient, topic, numPartitions, configs);
    }

    private void increasePartitions(String topic, int maxTasks) {
        this.adminClient.createPartitions(Map.of(topic, NewPartitions.increaseTo((int)maxTasks)));
    }

    private int partitionCount(String topic) throws ExecutionException, InterruptedException {
        DescribeTopicsResult result = this.adminClient.describeTopics(List.of(topic));
        KafkaFuture description = (KafkaFuture)result.topicNameValues().get(topic);
        return ((TopicDescription)description.get()).partitions().size();
    }
}

