/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner;

import com.google.cloud.Timestamp;
import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.Configuration;
import io.debezium.connector.SourceInfoStructMaker;
import io.debezium.connector.spanner.Module;
import io.debezium.connector.spanner.SpannerSourceInfoStructMaker;
import io.debezium.connector.spanner.config.BaseSpannerConnectorConfig;
import io.debezium.connector.spanner.context.source.SourceInfo;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpannerConnectorConfig
extends BaseSpannerConnectorConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpannerConnectorConfig.class);

    public SpannerConnectorConfig(Configuration config) {
        super(config, config.getString("name"), 0);
        LOGGER.debug("prop fields {}", (Object)ALL_FIELDS);
    }

    public String getContextName() {
        return Module.contextName();
    }

    public String getConnectorName() {
        return this.getConfig().getString("name");
    }

    protected SourceInfoStructMaker<SourceInfo> getSourceInfoStructMaker(CommonConnectorConfig.Version version) {
        return new SpannerSourceInfoStructMaker(Module.name(), Module.version(), this);
    }

    public boolean isSchemaChangesHistoryEnabled() {
        return false;
    }

    public boolean isSchemaCommentsHistoryEnabled() {
        return false;
    }

    public Duration getHeartbeatInterval() {
        return this.getConfig().getDuration(SPANNER_HEART_BEAT_INTERVAL, (TemporalUnit)ChronoUnit.MILLIS);
    }

    public boolean shouldProvideTransactionMetadata() {
        return false;
    }

    public CommonConnectorConfig.EventProcessingFailureHandlingMode getEventProcessingFailureHandlingMode() {
        return CommonConnectorConfig.EventProcessingFailureHandlingMode.FAIL;
    }

    public Properties kafkaProps(Map<?, ?> props) {
        Properties properties = new Properties();
        Map spannerKafkaProps = this.getConfig().subset("kafka.internal.client.", true).asMap();
        if (!spannerKafkaProps.isEmpty()) {
            properties.putAll((Map<?, ?>)spannerKafkaProps);
        }
        properties.setProperty("bootstrap.servers", this.bootStrapServer());
        properties.put("max.request.size", (Object)104858800);
        properties.put("max.partition.fetch.bytes", (Object)104858800);
        properties.putAll(props);
        return properties;
    }

    public int getMaxMissedHeartbeats() {
        return this.getConfig().getInteger(MAX_MISSED_HEARTBEATS);
    }

    public Duration getLowWatermarkStampInterval() {
        return this.getConfig().getDuration(LOW_WATERMARK_STAMP_INTERVAL, (TemporalUnit)ChronoUnit.MILLIS);
    }

    public String projectId() {
        return this.getConfig().getString("gcp.spanner.project.id");
    }

    public String instanceId() {
        return this.getConfig().getString("gcp.spanner.instance.id");
    }

    public String databaseId() {
        return this.getConfig().getString("gcp.spanner.database.id");
    }

    public String databaseRole() {
        return this.getConfig().getString("gcp.spanner.database.role");
    }

    public String spannerHost() {
        return this.getConfig().getString("gcp.spanner.host");
    }

    public String changeStreamName() {
        return this.getConfig().getString("gcp.spanner.change.stream");
    }

    public Timestamp startTime() {
        String timestamp = this.getConfig().getString("gcp.spanner.start.time", this.startTime);
        return Timestamp.parseTimestamp((String)timestamp);
    }

    public Timestamp endTime() {
        String timestamp = this.getConfig().getString("gcp.spanner.end.time");
        return timestamp == null ? null : Timestamp.parseTimestamp((String)timestamp);
    }

    public int queueCapacity() {
        return this.getConfig().getInteger(STREAM_EVENT_QUEUE_CAPACITY, ((Integer)STREAM_EVENT_QUEUE_CAPACITY.defaultValue()).intValue());
    }

    public String gcpSpannerCredentialsJson() {
        return this.getConfig().getString("gcp.spanner.credentials.json");
    }

    public String gcpSpannerCredentialsPath() {
        return this.getConfig().getString("gcp.spanner.credentials.path");
    }

    public String tableExcludeList() {
        return this.getConfig().getString(TABLE_EXCLUDE_LIST);
    }

    public String tableIncludeList() {
        return this.getConfig().getString(TABLE_INCLUDE_LIST);
    }

    public String bootStrapServer() {
        String valueFromConfig = this.getConfig().getString(SYNC_KAFKA_BOOTSTRAP_SERVERS);
        if (StringUtils.isNotBlank((CharSequence)valueFromConfig)) {
            return valueFromConfig;
        }
        String valueFromConnect = System.getenv("CONNECT_BOOTSTRAP_SERVERS");
        if (StringUtils.isNotBlank((CharSequence)valueFromConnect)) {
            return valueFromConnect;
        }
        return "localhost:9092";
    }

    public String rebalancingTopic() {
        return this.getConfig().getString(REBALANCING_TOPIC) + this.getConnectorName();
    }

    public int rebalancingPollDuration() {
        return this.getConfig().getInteger(REBALANCING_POLL_DURATION);
    }

    public int rebalancingCommitOffsetsTimeout() {
        return this.getConfig().getInteger(REBALANCING_COMMIT_OFFSETS_TIMEOUT);
    }

    public int rebalancingCommitOffsetsInterval() {
        return this.getConfig().getInteger(REBALANCING_COMMIT_OFFSETS_INTERVAL_MS);
    }

    public Duration rebalancingTaskWaitingTimeout() {
        return this.getConfig().getDuration(REBALANCING_TASK_WAITING_TIMEOUT, (TemporalUnit)ChronoUnit.MILLIS);
    }

    public int syncEventPublisherWaitingTimeout() {
        return this.getConfig().getInteger(SYNC_EVENT_PUBLISH_WAITING_TIMEOUT);
    }

    public int syncPollDuration() {
        return this.getConfig().getInteger(SYNC_POLL_DURATION);
    }

    public int syncCommitOffsetsTimeout() {
        return this.getConfig().getInteger(SYNC_COMMIT_OFFSETS_TIMEOUT);
    }

    public int syncCommitOffsetsInterval() {
        return this.getConfig().getInteger(SYNC_COMMIT_OFFSETS_INTERVAL_MS);
    }

    public int syncRequestTimeout() {
        return this.getConfig().getInteger(SYNC_REQUEST_TIMEOUT);
    }

    public int syncDeliveryTimeout() {
        return this.getConfig().getInteger(SYNC_DELIVERY_TIMEOUT);
    }

    public String taskSyncTopic() {
        return this.getConfig().getString(SYNC_TOPIC) + this.getConnectorName();
    }

    public String syncCleanupPolicy() {
        return this.getConfig().getString(SYNC_CLEANUP_POLICY);
    }

    public int syncRetentionMs() {
        return this.getConfig().getInteger(SYNC_RETENTION_MS);
    }

    public int syncSegmentMs() {
        return this.getConfig().getInteger(SYNC_SEGMENT_MS);
    }

    public String syncMinCleanableDirtyRatio() {
        return this.getConfig().getString(SYNC_MIN_CLEANABLE_DIRTY_RATIO);
    }

    public int getMaxTasks() {
        return this.getConfig().getInteger(MAX_TASKS);
    }

    public int getMinTasks() {
        return this.getConfig().getInteger(MIN_TASKS);
    }

    public int getDesiredPartitionsTasks() {
        return this.getConfig().getInteger(DESIRED_PARTITIONS_TASKS);
    }

    public boolean isLowWatermarkEnabled() {
        return this.getConfig().getBoolean(LOW_WATERMARK_ENABLED_FIELD);
    }

    public long getLowWatermarkUpdatePeriodMs() {
        return this.getConfig().getLong(LOW_WATERMARK_UPDATE_PERIOD_MS_FIELD, ((Long)LOW_WATERMARK_UPDATE_PERIOD_MS_FIELD.defaultValue()).longValue());
    }

    public boolean isScalerMonitorEnabled() {
        return this.getConfig().getBoolean(SCALER_MONITOR_ENABLED);
    }

    public boolean isLoggingJsonEnabled() {
        return this.getConfig().getBoolean(LOGGING_JSON_ENABLED);
    }

    public boolean isFinishingPartitionAfterCommit() {
        return this.getConfig().getBoolean(CONNECTOR_SPANNER_PARTITION_FINISHING_AFTER_COMMIT_FIELD);
    }

    public int taskStateChangeEventQueueCapacity() {
        return this.getConfig().getInteger(TASK_STATE_CHANGE_EVENT_QUEUE_CAPACITY, ((Integer)TASK_STATE_CHANGE_EVENT_QUEUE_CAPACITY.defaultValue()).intValue());
    }

    public Duration percentageMetricsClearInterval() {
        return this.getConfig().getDuration(PERCENTAGE_METRICS_CLEAR_INTERVAL, (TemporalUnit)ChronoUnit.MILLIS);
    }

    public boolean failOverloadedTask() {
        return this.getConfig().getBoolean(TASKS_FAIL_OVERLOADED);
    }

    public long failOverloadedTaskInterval() {
        return this.getConfig().getLong(TASKS_FAIL_OVERLOADED_CHECK_INTERVAL);
    }

    public int getTopicNumPartitions() {
        return this.getConfig().getInteger(TOPIC_DEFAULT_AUTO_CREATION_PARTITIONS_FIELD);
    }

    public String syncTopicMaxMessageSize() {
        return this.getConfig().getString(SYNC_TOPIC_MAX_MESSAGE_BYTES);
    }
}

