/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner.db.stream;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class PartitionThreadPool {
    private final Map<String, Thread> threadMap = new HashMap<String, Thread>();

    public synchronized boolean submit(String token, Runnable runnable) {
        if (this.threadMap.containsKey(token)) {
            return false;
        }
        this.clean();
        Thread thread = new Thread(runnable, "SpannerConnector-PartitionThreadPool");
        this.threadMap.put(token, thread);
        thread.start();
        return true;
    }

    public synchronized void stop(String token) {
        this.clean();
        Thread thread = this.threadMap.get(token);
        if (thread != null) {
            thread.interrupt();
        }
        this.threadMap.remove(token);
    }

    public synchronized void shutdown() {
        this.clean();
        this.threadMap.values().forEach(Thread::interrupt);
        while (!this.threadMap.values().stream().allMatch(thread -> thread.getState().equals((Object)Thread.State.TERMINATED))) {
        }
    }

    private synchronized void clean() {
        Set<String> tokens = this.threadMap.entrySet().stream().filter(entry -> ((Thread)entry.getValue()).getState().equals((Object)Thread.State.TERMINATED)).map(Map.Entry::getKey).collect(Collectors.toSet());
        tokens.forEach(this.threadMap::remove);
    }

    public synchronized Set<String> getActiveThreads() {
        this.clean();
        return Set.copyOf(this.threadMap.keySet());
    }
}

