/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.postgresql.snapshot.mode;

import io.debezium.connector.postgresql.PostgresConnectorConfig;
import io.debezium.connector.postgresql.snapshot.mode.InitialSnapshotter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InitialOnlySnapshotter
extends InitialSnapshotter {
    private static final Logger LOGGER = LoggerFactory.getLogger(InitialOnlySnapshotter.class);

    @Override
    public String name() {
        return PostgresConnectorConfig.SnapshotMode.INITIAL_ONLY.getValue();
    }

    @Override
    public boolean shouldStream() {
        return false;
    }

    @Override
    public boolean shouldSnapshot() {
        if (!this.offsetContextExists) {
            LOGGER.info("Taking initial snapshot for new datasource");
            return true;
        }
        if (this.isSnapshotInProgress) {
            LOGGER.info("Found previous incomplete snapshot");
            return true;
        }
        LOGGER.info("Previous initial snapshot completed, no snapshot will be performed");
        return false;
    }
}

