/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.postgresql.snapshot;

import io.debezium.DebeziumException;
import io.debezium.bean.spi.BeanRegistry;
import io.debezium.bean.spi.BeanRegistryAware;
import io.debezium.config.Configuration;
import io.debezium.connector.postgresql.PostgresConnectorConfig;
import io.debezium.service.spi.ServiceProvider;
import io.debezium.service.spi.ServiceRegistry;
import io.debezium.snapshot.spi.SnapshotLock;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.stream.StreamSupport;

public class SnapshotLockProvider
implements ServiceProvider<SnapshotLock> {
    public SnapshotLock createService(Configuration configuration, ServiceRegistry serviceRegistry) {
        BeanRegistry beanRegistry = (BeanRegistry)serviceRegistry.tryGetService(BeanRegistry.class);
        PostgresConnectorConfig postgresConnectorConfig = (PostgresConnectorConfig)((Object)beanRegistry.lookupByName("ConnectorConfig", PostgresConnectorConfig.class));
        PostgresConnectorConfig.SnapshotLockingMode configuredSnapshotLockingMode = postgresConnectorConfig.snapshotLockingMode();
        String snapshotLockingModeCustomName = postgresConnectorConfig.snapshotLockingModeCustomName();
        String snapshotLockingMode = PostgresConnectorConfig.SnapshotLockingMode.CUSTOM.equals((Object)configuredSnapshotLockingMode) && !snapshotLockingModeCustomName.isEmpty() ? snapshotLockingModeCustomName : configuredSnapshotLockingMode.getValue();
        Optional<SnapshotLock> snapshotLock = StreamSupport.stream(ServiceLoader.load(SnapshotLock.class).spliterator(), false).filter(s -> s.name().equals(snapshotLockingMode)).findAny();
        return snapshotLock.map(s -> {
            s.configure(configuration.asMap());
            if (s instanceof BeanRegistryAware) {
                ((BeanRegistryAware)s).injectBeanRegistry(beanRegistry);
            }
            return s;
        }).orElseThrow(() -> new DebeziumException(String.format("Unable to find %s snapshot locking mode. Please check your configuration.", snapshotLockingMode)));
    }

    public Class<SnapshotLock> getServiceClass() {
        return SnapshotLock.class;
    }
}

