/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.postgresql.rest;

import io.debezium.DebeziumException;
import io.debezium.config.Configuration;
import io.debezium.connector.postgresql.Module;
import io.debezium.connector.postgresql.PostgresConnector;
import io.debezium.connector.postgresql.PostgresConnectorConfig;
import io.debezium.connector.postgresql.connection.PostgresConnection;
import io.debezium.rest.ConnectionValidationResource;
import io.debezium.rest.FilterValidationResource;
import io.debezium.rest.SchemaResource;
import io.debezium.rest.model.DataCollection;
import java.sql.SQLException;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.kafka.connect.connector.Connector;

@Path(value="/debezium/postgres")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class DebeziumPostgresConnectorResource
implements SchemaResource,
ConnectionValidationResource,
FilterValidationResource {
    public static final String BASE_PATH = "/debezium/postgres";
    public static final String VERSION_ENDPOINT = "/version";

    @GET
    @Path(value="/version")
    public String getConnectorVersion() {
        return Module.version();
    }

    public Connector getConnector() {
        return new PostgresConnector();
    }

    public List<DataCollection> getMatchingCollections(Configuration configuration) {
        PostgresConnectorConfig config = new PostgresConnectorConfig(configuration);
        PostgresConnection connection = new PostgresConnection(config.getJdbcConfig(), "Debezium General");
        try {
            Set tables = connection.readTableNames(config.databaseName(), null, null, new String[]{"TABLE"});
            List<DataCollection> list = tables.stream().filter(tableId -> config.getTableFilters().dataCollectionFilter().isIncluded(tableId)).map(tableId -> new DataCollection(tableId.schema(), tableId.table())).collect(Collectors.toList());
            return list;
        }
        catch (SQLException e) {
            throw new DebeziumException((Throwable)e);
        }
        finally {
            try {
                connection.close();
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                throwable2.addSuppressed(throwable);
            }
        }
    }

    public String getSchemaFilePath() {
        return "/META-INF/resources/postgres.json";
    }
}

