/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.postgresql.connection;

import io.debezium.connector.postgresql.PostgresStreamingChangeEventSource;
import io.debezium.connector.postgresql.PostgresType;
import io.debezium.connector.postgresql.TypeRegistry;
import io.debezium.connector.postgresql.connection.ReplicationMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplicationMessageColumnValueResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReplicationMessageColumnValueResolver.class);

    public static Object resolveValue(String columnName, PostgresType type, String fullType, ReplicationMessage.ColumnValue value, PostgresStreamingChangeEventSource.PgConnectionSupplier connection, boolean includeUnknownDatatypes, TypeRegistry typeRegistry) {
        if (value.isNull()) {
            return null;
        }
        if (!type.isRootType()) {
            return ReplicationMessageColumnValueResolver.resolveValue(columnName, type.getParentType(), fullType, value, connection, includeUnknownDatatypes, typeRegistry);
        }
        if (value.isArray(type)) {
            return value.asArray(columnName, type, fullType, connection);
        }
        if (type.isEnumType()) {
            return value.asString();
        }
        switch (type.getName()) {
            case "boolean": 
            case "bool": {
                return value.asBoolean();
            }
            case "hstore": {
                return value.asString();
            }
            case "integer": 
            case "int": 
            case "int4": 
            case "smallint": 
            case "int2": 
            case "smallserial": 
            case "serial": 
            case "serial2": 
            case "serial4": {
                return value.asInteger();
            }
            case "bigint": 
            case "bigserial": 
            case "int8": 
            case "oid": {
                return value.asLong();
            }
            case "real": 
            case "float4": {
                return value.asFloat();
            }
            case "double precision": 
            case "float8": {
                return value.asDouble();
            }
            case "numeric": 
            case "decimal": {
                return value.asDecimal();
            }
            case "character": 
            case "char": 
            case "character varying": 
            case "varchar": 
            case "bpchar": 
            case "text": {
                return value.asString();
            }
            case "date": {
                return value.asLocalDate();
            }
            case "timestamp with time zone": 
            case "timestamptz": {
                return value.asOffsetDateTimeAtUtc();
            }
            case "timestamp": 
            case "timestamp without time zone": {
                return value.asInstant();
            }
            case "time": {
                return value.asTime();
            }
            case "time without time zone": {
                return value.asLocalTime();
            }
            case "time with time zone": 
            case "timetz": {
                return value.asOffsetTimeUtc();
            }
            case "bytea": {
                return value.asByteArray();
            }
            case "box": {
                return value.asBox();
            }
            case "circle": {
                return value.asCircle();
            }
            case "interval": {
                return value.asInterval();
            }
            case "line": {
                return value.asLine();
            }
            case "lseg": {
                return value.asLseg();
            }
            case "money": {
                return value.asMoney();
            }
            case "path": {
                return value.asPath();
            }
            case "point": {
                return value.asPoint();
            }
            case "polygon": {
                return value.asPolygon();
            }
            case "geometry": 
            case "geography": {
                return value.asString();
            }
            case "citext": 
            case "bit": 
            case "bit varying": 
            case "varbit": 
            case "json": 
            case "jsonb": 
            case "xml": 
            case "uuid": 
            case "tsrange": 
            case "tstzrange": 
            case "daterange": 
            case "inet": 
            case "cidr": 
            case "macaddr": 
            case "macaddr8": 
            case "int4range": 
            case "numrange": 
            case "int8range": 
            case "ltree": 
            case "isbn": {
                return value.asString();
            }
        }
        return value.asDefault(typeRegistry, type.getOid(), columnName, fullType, includeUnknownDatatypes, connection);
    }
}

