/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.postgresql.pipeline.txmetadata;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.connector.postgresql.PostgresOffsetContext;
import io.debezium.function.BlockingConsumer;
import io.debezium.pipeline.source.spi.EventMetadataProvider;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.pipeline.txmetadata.TransactionMonitor;
import io.debezium.util.SchemaNameAdjuster;
import java.time.Instant;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceRecord;

public class PostgresTransactionMonitor
extends TransactionMonitor {
    public PostgresTransactionMonitor(CommonConnectorConfig connectorConfig, EventMetadataProvider eventMetadataProvider, SchemaNameAdjuster schemaNameAdjuster, BlockingConsumer<SourceRecord> sender, String topicName) {
        super(connectorConfig, eventMetadataProvider, schemaNameAdjuster, sender, topicName);
    }

    protected Struct prepareTxKey(OffsetContext offsetContext) {
        return this.adjustTxId(new Struct(this.transactionKeySchema), offsetContext);
    }

    protected Struct prepareTxBeginValue(OffsetContext offsetContext, Instant timestamp) {
        return this.adjustTxId(super.prepareTxBeginValue(offsetContext, timestamp), offsetContext);
    }

    protected Struct prepareTxEndValue(OffsetContext offsetContext, Instant timestamp) {
        return this.adjustTxId(super.prepareTxEndValue(offsetContext, timestamp), offsetContext);
    }

    protected Struct prepareTxStruct(OffsetContext offsetContext, long dataCollectionEventOrder, Struct value) {
        return this.adjustTxId(super.prepareTxStruct(offsetContext, dataCollectionEventOrder, value), offsetContext);
    }

    private Struct adjustTxId(Struct txStruct, OffsetContext offsetContext) {
        String lsn = Long.toString(((PostgresOffsetContext)offsetContext).asOffsetState().lastSeenLsn().asLong());
        String txId = offsetContext.getTransactionContext().getTransactionId();
        txStruct.put("id", (Object)String.format("%s:%s", txId, lsn));
        return txStruct;
    }
}

