/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.postgresql;

import io.debezium.annotation.Immutable;
import io.debezium.connector.postgresql.PostgresConnectorConfig;
import io.debezium.relational.Selectors;
import io.debezium.relational.Tables;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;

@Immutable
public class Filters {
    protected static final List<String> SYSTEM_SCHEMAS = Arrays.asList("pg_catalog", "information_schema");
    protected static final String SYSTEM_SCHEMA_EXCLUDE_LIST = String.join((CharSequence)",", SYSTEM_SCHEMAS);
    protected static final Predicate<String> IS_SYSTEM_SCHEMA = SYSTEM_SCHEMAS::contains;
    protected static final String TEMP_TABLE_EXCLUDE_LIST = ".*\\.pg_temp.*";
    private final Tables.TableFilter tableFilter;

    public Filters(PostgresConnectorConfig config) {
        Object schemaExcludeList = config.schemaExcludeList();
        schemaExcludeList = schemaExcludeList != null ? (String)schemaExcludeList + "," + SYSTEM_SCHEMA_EXCLUDE_LIST : SYSTEM_SCHEMA_EXCLUDE_LIST;
        Object tableExcludeList = config.tableExcludeList();
        tableExcludeList = tableExcludeList != null ? (String)tableExcludeList + ",.*\\.pg_temp.*" : TEMP_TABLE_EXCLUDE_LIST;
        this.tableFilter = Tables.TableFilter.fromPredicate((Predicate)Selectors.tableSelector().includeTables(config.tableIncludeList()).excludeTables((String)tableExcludeList).includeSchemas(config.schemaIncludeList()).excludeSchemas((String)schemaExcludeList).build());
    }

    protected Tables.TableFilter tableFilter() {
        return this.tableFilter;
    }
}

