/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.postgresql;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import io.debezium.config.CommonConnectorConfig;
import io.debezium.connector.postgresql.PostgisGeometry;
import io.debezium.connector.postgresql.PostgresConnectorConfig;
import io.debezium.connector.postgresql.PostgresType;
import io.debezium.connector.postgresql.TypeRegistry;
import io.debezium.connector.postgresql.UnchangedToastedReplicationMessageColumn;
import io.debezium.connector.postgresql.data.Ltree;
import io.debezium.connector.postgresql.proto.PgProto;
import io.debezium.data.Bits;
import io.debezium.data.Enum;
import io.debezium.data.Json;
import io.debezium.data.SpecialValueDecimal;
import io.debezium.data.Uuid;
import io.debezium.data.VariableScaleDecimal;
import io.debezium.data.geometry.Geography;
import io.debezium.data.geometry.Geometry;
import io.debezium.data.geometry.Point;
import io.debezium.jdbc.JdbcValueConverters;
import io.debezium.jdbc.TemporalPrecisionMode;
import io.debezium.relational.Column;
import io.debezium.relational.ValueConverter;
import io.debezium.time.Conversions;
import io.debezium.time.Date;
import io.debezium.time.Interval;
import io.debezium.time.MicroDuration;
import io.debezium.time.MicroTime;
import io.debezium.time.MicroTimestamp;
import io.debezium.time.NanoTime;
import io.debezium.time.ZonedTime;
import io.debezium.time.ZonedTimestamp;
import io.debezium.util.NumberConversions;
import io.debezium.util.Strings;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.kafka.connect.data.Decimal;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.errors.ConnectException;
import org.postgresql.geometric.PGpoint;
import org.postgresql.jdbc.PgArray;
import org.postgresql.util.HStoreConverter;
import org.postgresql.util.PGInterval;
import org.postgresql.util.PGobject;

public class PostgresValueConverter
extends JdbcValueConverters {
    public static final Timestamp POSITIVE_INFINITY_TIMESTAMP = new Timestamp(9223372036825200000L);
    public static final Instant POSITIVE_INFINITY_INSTANT = Conversions.toInstantFromMicros((long)9223372036825200000L);
    public static final LocalDateTime POSITIVE_INFINITY_LOCAL_DATE_TIME = LocalDateTime.ofInstant(POSITIVE_INFINITY_INSTANT, ZoneOffset.UTC);
    public static final OffsetDateTime POSITIVE_INFINITY_OFFSET_DATE_TIME = OffsetDateTime.ofInstant(Conversions.toInstantFromMillis((long)9223372036825200000L), ZoneOffset.UTC);
    public static final Timestamp NEGATIVE_INFINITY_TIMESTAMP = new Timestamp(-9223372036832400000L);
    public static final Instant NEGATIVE_INFINITY_INSTANT = Conversions.toInstantFromMicros((long)-9223372036832400000L);
    public static final LocalDateTime NEGATIVE_INFINITY_LOCAL_DATE_TIME = LocalDateTime.ofInstant(NEGATIVE_INFINITY_INSTANT, ZoneOffset.UTC);
    public static final OffsetDateTime NEGATIVE_INFINITY_OFFSET_DATE_TIME = OffsetDateTime.ofInstant(Conversions.toInstantFromMillis((long)-9223372036832400000L), ZoneOffset.UTC);
    private static final int VARIABLE_SCALE_DECIMAL_LENGTH = 131089;
    public static final String N_A_N = "NaN";
    public static final String POSITIVE_INFINITY = "Infinity";
    public static final String NEGATIVE_INFINITY = "-Infinity";
    private static final BigDecimal MICROSECONDS_PER_SECOND = new BigDecimal(1000000);
    private static final DateTimeFormatter TIME_WITH_TIMEZONE_FORMATTER = new DateTimeFormatterBuilder().appendPattern("HH:mm:ss").appendFraction(ChronoField.MICRO_OF_SECOND, 0, 6, true).appendPattern("[XXX][XX][X]").toFormatter();
    private final boolean includeUnknownDatatypes;
    private final TypeRegistry typeRegistry;
    private final PostgresConnectorConfig.HStoreHandlingMode hStoreMode;
    private final PostgresConnectorConfig.IntervalHandlingMode intervalMode;
    private final Charset databaseCharset;
    private final JsonFactory jsonFactory;
    private final String toastPlaceholderString;
    private final byte[] toastPlaceholderBinary;

    protected PostgresValueConverter(Charset databaseCharset, JdbcValueConverters.DecimalMode decimalMode, TemporalPrecisionMode temporalPrecisionMode, ZoneOffset defaultOffset, JdbcValueConverters.BigIntUnsignedMode bigIntUnsignedMode, boolean includeUnknownDatatypes, TypeRegistry typeRegistry, PostgresConnectorConfig.HStoreHandlingMode hStoreMode, CommonConnectorConfig.BinaryHandlingMode binaryMode, PostgresConnectorConfig.IntervalHandlingMode intervalMode, byte[] toastPlaceholder) {
        super(decimalMode, temporalPrecisionMode, defaultOffset, null, bigIntUnsignedMode, binaryMode);
        this.databaseCharset = databaseCharset;
        this.jsonFactory = new JsonFactory();
        this.includeUnknownDatatypes = includeUnknownDatatypes;
        this.typeRegistry = typeRegistry;
        this.hStoreMode = hStoreMode;
        this.intervalMode = intervalMode;
        this.toastPlaceholderBinary = toastPlaceholder;
        this.toastPlaceholderString = new String(toastPlaceholder);
    }

    public SchemaBuilder schemaBuilder(Column column) {
        int oidValue = column.nativeType();
        switch (oidValue) {
            case 1560: 
            case 1561: 
            case 1562: {
                return column.length() > 1 ? Bits.builder((int)column.length()) : SchemaBuilder.bool();
            }
            case 1186: {
                return this.intervalMode == PostgresConnectorConfig.IntervalHandlingMode.STRING ? Interval.builder() : MicroDuration.builder();
            }
            case 1184: {
                return ZonedTimestamp.builder();
            }
            case 1266: {
                return ZonedTime.builder();
            }
            case 26: {
                return SchemaBuilder.int64();
            }
            case 114: 
            case 3802: {
                return Json.builder();
            }
            case 650: 
            case 774: 
            case 829: 
            case 869: 
            case 3904: 
            case 3906: 
            case 3908: 
            case 3910: 
            case 3912: 
            case 3926: {
                return SchemaBuilder.string();
            }
            case 2950: {
                return Uuid.builder();
            }
            case 600: {
                return Point.builder();
            }
            case 790: {
                return Decimal.builder((int)2);
            }
            case 1700: {
                return this.numericSchema(column);
            }
            case 17: {
                return this.binaryMode.getSchema();
            }
            case 1005: {
                return SchemaBuilder.array((Schema)SchemaBuilder.OPTIONAL_INT16_SCHEMA);
            }
            case 1007: {
                return SchemaBuilder.array((Schema)SchemaBuilder.OPTIONAL_INT32_SCHEMA);
            }
            case 1016: {
                return SchemaBuilder.array((Schema)SchemaBuilder.OPTIONAL_INT64_SCHEMA);
            }
            case 651: 
            case 775: 
            case 1002: 
            case 1009: 
            case 1014: 
            case 1015: 
            case 1040: 
            case 1041: 
            case 3905: 
            case 3907: 
            case 3909: 
            case 3911: 
            case 3913: 
            case 3927: {
                return SchemaBuilder.array((Schema)SchemaBuilder.OPTIONAL_STRING_SCHEMA);
            }
            case 1231: {
                return SchemaBuilder.array((Schema)this.numericSchema(column).optional().build());
            }
            case 1021: {
                return SchemaBuilder.array((Schema)Schema.OPTIONAL_FLOAT32_SCHEMA);
            }
            case 1022: {
                return SchemaBuilder.array((Schema)Schema.OPTIONAL_FLOAT64_SCHEMA);
            }
            case 1000: {
                return SchemaBuilder.array((Schema)SchemaBuilder.OPTIONAL_BOOLEAN_SCHEMA);
            }
            case 1182: {
                if (this.adaptiveTimePrecisionMode || this.adaptiveTimeMicrosecondsPrecisionMode) {
                    return SchemaBuilder.array((Schema)Date.builder().optional().build());
                }
                return SchemaBuilder.array((Schema)org.apache.kafka.connect.data.Date.builder().optional().build());
            }
            case 2951: {
                return SchemaBuilder.array((Schema)Uuid.builder().optional().build());
            }
            case 199: 
            case 3807: {
                return SchemaBuilder.array((Schema)Json.builder().optional().build());
            }
            case 1183: {
                return SchemaBuilder.array((Schema)MicroTime.builder().optional().build());
            }
            case 1270: {
                return SchemaBuilder.array((Schema)ZonedTime.builder().optional().build());
            }
            case 1115: {
                if (this.adaptiveTimePrecisionMode || this.adaptiveTimeMicrosecondsPrecisionMode) {
                    if (this.getTimePrecision(column) <= 3) {
                        return SchemaBuilder.array((Schema)io.debezium.time.Timestamp.builder().optional().build());
                    }
                    if (this.getTimePrecision(column) <= 6) {
                        return SchemaBuilder.array((Schema)MicroTimestamp.builder().optional().build());
                    }
                    return SchemaBuilder.array((Schema)NanoTime.builder().optional().build());
                }
                return SchemaBuilder.array((Schema)org.apache.kafka.connect.data.Timestamp.builder().optional().build());
            }
            case 1185: {
                return SchemaBuilder.array((Schema)ZonedTimestamp.builder().optional().build());
            }
            case 143: 
            case 791: 
            case 1001: 
            case 1003: 
            case 1017: 
            case 1028: 
            case 1187: 
            case 1563: 
            case 2201: {
                return null;
            }
        }
        if (oidValue == this.typeRegistry.geometryOid()) {
            return Geometry.builder();
        }
        if (oidValue == this.typeRegistry.geographyOid()) {
            return Geography.builder();
        }
        if (oidValue == this.typeRegistry.citextOid()) {
            return SchemaBuilder.string();
        }
        if (oidValue == this.typeRegistry.geometryArrayOid()) {
            return SchemaBuilder.array((Schema)Geometry.builder().optional().build());
        }
        if (oidValue == this.typeRegistry.hstoreOid()) {
            return this.hstoreSchema();
        }
        if (oidValue == this.typeRegistry.ltreeOid()) {
            return Ltree.builder();
        }
        if (oidValue == this.typeRegistry.hstoreArrayOid()) {
            return SchemaBuilder.array((Schema)this.hstoreSchema().optional().build());
        }
        if (oidValue == this.typeRegistry.geographyArrayOid()) {
            return SchemaBuilder.array((Schema)Geography.builder().optional().build());
        }
        if (oidValue == this.typeRegistry.citextArrayOid()) {
            return SchemaBuilder.array((Schema)SchemaBuilder.OPTIONAL_STRING_SCHEMA);
        }
        if (oidValue == this.typeRegistry.ltreeArrayOid()) {
            return SchemaBuilder.array((Schema)Ltree.builder().optional().build());
        }
        PostgresType resolvedType = this.typeRegistry.get(oidValue);
        if (resolvedType.isEnumType()) {
            return Enum.builder((String)Strings.join((CharSequence)",", resolvedType.getEnumValues()));
        }
        if (resolvedType.isArrayType() && resolvedType.getElementType().isEnumType()) {
            List<String> enumValues = resolvedType.getElementType().getEnumValues();
            return SchemaBuilder.array((Schema)Enum.builder((String)Strings.join((CharSequence)",", enumValues)));
        }
        SchemaBuilder jdbcSchemaBuilder = super.schemaBuilder(column);
        if (jdbcSchemaBuilder == null) {
            return this.includeUnknownDatatypes ? this.binaryMode.getSchema() : null;
        }
        return jdbcSchemaBuilder;
    }

    private SchemaBuilder numericSchema(Column column) {
        if (this.decimalMode == JdbcValueConverters.DecimalMode.PRECISE && this.isVariableScaleDecimal(column)) {
            return VariableScaleDecimal.builder();
        }
        return SpecialValueDecimal.builder((JdbcValueConverters.DecimalMode)this.decimalMode, (int)column.length(), (int)column.scale().orElseGet(() -> 0));
    }

    private SchemaBuilder hstoreSchema() {
        if (this.hStoreMode == PostgresConnectorConfig.HStoreHandlingMode.JSON) {
            return Json.builder();
        }
        return SchemaBuilder.map((Schema)SchemaBuilder.STRING_SCHEMA, (Schema)SchemaBuilder.OPTIONAL_STRING_SCHEMA);
    }

    public ValueConverter converter(Column column, Field fieldDefn) {
        int oidValue = column.nativeType();
        switch (oidValue) {
            case 1560: 
            case 1562: {
                return this.convertBits(column, fieldDefn);
            }
            case 1186: {
                return data -> this.convertInterval(column, fieldDefn, data);
            }
            case 1083: {
                return data -> this.convertTime(column, fieldDefn, data);
            }
            case 1114: {
                return ((ValueConverter)data -> this.convertTimestampToLocalDateTime(column, fieldDefn, data)).and(super.converter(column, fieldDefn));
            }
            case 1184: {
                return data -> this.convertTimestampWithZone(column, fieldDefn, data);
            }
            case 1266: {
                return data -> this.convertTimeWithZone(column, fieldDefn, data);
            }
            case 26: {
                return data -> this.convertBigInt(column, fieldDefn, data);
            }
            case 114: 
            case 650: 
            case 774: 
            case 829: 
            case 869: 
            case 2950: 
            case 3802: 
            case 3904: 
            case 3906: 
            case 3908: 
            case 3910: 
            case 3912: 
            case 3926: {
                return data -> this.convertString(column, fieldDefn, data);
            }
            case 600: {
                return data -> this.convertPoint(column, fieldDefn, data);
            }
            case 790: {
                return data -> this.convertMoney(column, fieldDefn, data);
            }
            case 1700: {
                return data -> this.convertDecimal(column, fieldDefn, data, this.decimalMode);
            }
            case 17: {
                return data -> this.convertBinary(column, fieldDefn, data, this.binaryMode);
            }
            case 199: 
            case 651: 
            case 775: 
            case 1000: 
            case 1002: 
            case 1005: 
            case 1007: 
            case 1009: 
            case 1014: 
            case 1015: 
            case 1016: 
            case 1021: 
            case 1022: 
            case 1040: 
            case 1041: 
            case 1115: 
            case 1182: 
            case 1183: 
            case 1185: 
            case 1231: 
            case 1270: 
            case 2951: 
            case 3807: 
            case 3905: 
            case 3907: 
            case 3909: 
            case 3911: 
            case 3913: 
            case 3927: {
                return this.createArrayConverter(column, fieldDefn);
            }
            case 143: 
            case 791: 
            case 1001: 
            case 1003: 
            case 1017: 
            case 1028: 
            case 1187: 
            case 1563: 
            case 2201: {
                return super.converter(column, fieldDefn);
            }
        }
        if (oidValue == this.typeRegistry.geometryOid()) {
            return data -> this.convertGeometry(column, fieldDefn, data);
        }
        if (oidValue == this.typeRegistry.geographyOid()) {
            return data -> this.convertGeography(column, fieldDefn, data);
        }
        if (oidValue == this.typeRegistry.citextOid()) {
            return data -> this.convertCitext(column, fieldDefn, data);
        }
        if (oidValue == this.typeRegistry.hstoreOid()) {
            return data -> this.convertHStore(column, fieldDefn, data, this.hStoreMode);
        }
        if (oidValue == this.typeRegistry.ltreeOid()) {
            return data -> this.convertLtree(column, fieldDefn, data);
        }
        if (oidValue == this.typeRegistry.ltreeArrayOid()) {
            return data -> this.convertLtreeArray(column, fieldDefn, data);
        }
        if (oidValue == this.typeRegistry.geometryArrayOid() || oidValue == this.typeRegistry.geographyArrayOid() || oidValue == this.typeRegistry.citextArrayOid() || oidValue == this.typeRegistry.hstoreArrayOid()) {
            return this.createArrayConverter(column, fieldDefn);
        }
        PostgresType resolvedType = this.typeRegistry.get(oidValue);
        if (resolvedType.isArrayType()) {
            return this.createArrayConverter(column, fieldDefn);
        }
        ValueConverter jdbcConverter = super.converter(column, fieldDefn);
        if (jdbcConverter == null) {
            return this.includeUnknownDatatypes ? data -> this.convertBinary(column, fieldDefn, data, this.binaryMode) : null;
        }
        return jdbcConverter;
    }

    private ValueConverter createArrayConverter(Column column, Field fieldDefn) {
        PostgresType arrayType = this.typeRegistry.get(column.nativeType());
        PostgresType elementType = arrayType.getElementType();
        String elementTypeName = elementType.getName();
        String elementColumnName = column.name() + "-element";
        Column elementColumn = Column.editor().name(elementColumnName).jdbcType(elementType.getJdbcId()).nativeType(elementType.getOid()).type(elementTypeName).optional(true).scale((Integer)column.scale().orElse(null)).length(column.length()).create();
        Schema elementSchema = this.schemaBuilder(elementColumn).optional().build();
        Field elementField = new Field(elementColumnName, 0, elementSchema);
        ValueConverter elementConverter = this.converter(elementColumn, elementField);
        return data -> this.convertArray(column, fieldDefn, elementType, elementConverter, data);
    }

    protected Object convertTime(Column column, Field fieldDefn, Object data) {
        if (data instanceof String) {
            data = Strings.asDuration((String)((String)data));
        }
        return super.convertTime(column, fieldDefn, data);
    }

    protected Object convertDecimal(Column column, Field fieldDefn, Object data, JdbcValueConverters.DecimalMode mode) {
        SpecialValueDecimal value;
        if (data instanceof SpecialValueDecimal) {
            value = (SpecialValueDecimal)data;
            if (!value.getDecimalValue().isPresent()) {
                return SpecialValueDecimal.fromLogical((SpecialValueDecimal)value, (JdbcValueConverters.DecimalMode)mode, (String)column.name());
            }
        } else {
            Object o = this.toBigDecimal(column, fieldDefn, data);
            if (o == null || !(o instanceof BigDecimal)) {
                return o;
            }
            value = new SpecialValueDecimal((BigDecimal)o);
        }
        BigDecimal newDecimal = this.withScaleAdjustedIfNeeded(column, (BigDecimal)value.getDecimalValue().get());
        if (this.isVariableScaleDecimal(column) && mode == JdbcValueConverters.DecimalMode.PRECISE) {
            if ((newDecimal = newDecimal.stripTrailingZeros()).scale() < 0) {
                newDecimal = newDecimal.setScale(0);
            }
            return VariableScaleDecimal.fromLogical((Schema)fieldDefn.schema(), (SpecialValueDecimal)new SpecialValueDecimal(newDecimal));
        }
        return SpecialValueDecimal.fromLogical((SpecialValueDecimal)new SpecialValueDecimal(newDecimal), (JdbcValueConverters.DecimalMode)mode, (String)column.name());
    }

    protected Object convertHStore(Column column, Field fieldDefn, Object data, PostgresConnectorConfig.HStoreHandlingMode mode) {
        if (mode == PostgresConnectorConfig.HStoreHandlingMode.JSON) {
            return this.convertHstoreToJsonString(column, fieldDefn, data);
        }
        return this.convertHstoreToMap(column, fieldDefn, data);
    }

    private Object convertLtree(Column column, Field fieldDefn, Object data) {
        return this.convertValue(column, fieldDefn, data, "", r -> {
            if (data instanceof byte[]) {
                r.deliver((Object)new String((byte[])data, this.databaseCharset));
            }
            if (data instanceof String) {
                r.deliver(data);
            } else if (data instanceof PGobject) {
                r.deliver((Object)data.toString());
            }
        });
    }

    private Object convertLtreeArray(Column column, Field fieldDefn, Object data) {
        return this.convertValue(column, fieldDefn, data, Collections.emptyList(), r -> {
            if (data instanceof byte[]) {
                String s = new String((byte[])data, this.databaseCharset);
                s = s.substring(1, s.length() - 1);
                List<String> ltrees = Arrays.asList(s.split(","));
                r.deliver(ltrees);
            } else if (data instanceof List) {
                List list = (List)data;
                ArrayList<String> ltrees = new ArrayList<String>(list.size());
                for (Object value : list) {
                    ltrees.add(value.toString());
                }
                r.deliver(ltrees);
            } else if (data instanceof PgArray) {
                PgArray pgArray = (PgArray)data;
                try {
                    Object[] array = (Object[])pgArray.getArray();
                    ArrayList<String> ltrees = new ArrayList<String>(array.length);
                    for (Object value : array) {
                        ltrees.add(value.toString());
                    }
                    r.deliver(ltrees);
                }
                catch (SQLException e) {
                    this.logger.error("Failed to parse PgArray: " + pgArray, (Throwable)e);
                }
            }
        });
    }

    private Object convertHstoreToMap(Column column, Field fieldDefn, Object data) {
        return this.convertValue(column, fieldDefn, data, Collections.emptyMap(), r -> {
            if (data instanceof String) {
                r.deliver((Object)HStoreConverter.fromString((String)((String)data)));
            } else if (data instanceof byte[]) {
                r.deliver((Object)HStoreConverter.fromString((String)this.asHstoreString((byte[])data)));
            } else if (data instanceof PGobject) {
                r.deliver((Object)HStoreConverter.fromString((String)data.toString()));
            }
        });
    }

    private String asHstoreString(byte[] data) {
        return new String(data, this.databaseCharset);
    }

    private Object convertHstoreToJsonString(Column column, Field fieldDefn, Object data) {
        return this.convertValue(column, fieldDefn, data, "{}", r -> {
            this.logger.trace("in ANON: value from data object: *** {} ***", data);
            this.logger.trace("in ANON: object type is: *** {} ***", data.getClass());
            if (data instanceof String) {
                r.deliver((Object)this.changePlainStringRepresentationToJsonStringRepresentation((String)data));
            } else if (data instanceof byte[]) {
                r.deliver((Object)this.changePlainStringRepresentationToJsonStringRepresentation(this.asHstoreString((byte[])data)));
            } else if (data instanceof PGobject) {
                r.deliver((Object)this.changePlainStringRepresentationToJsonStringRepresentation(data.toString()));
            } else if (data instanceof HashMap) {
                r.deliver((Object)this.convertMapToJsonStringRepresentation((Map)data));
            }
        });
    }

    private String changePlainStringRepresentationToJsonStringRepresentation(String text) {
        this.logger.trace("text value is: {}", (Object)text);
        try {
            Map map = HStoreConverter.fromString((String)text);
            return this.convertMapToJsonStringRepresentation(map);
        }
        catch (Exception e) {
            throw new RuntimeException("Couldn't serialize hstore value into JSON: " + text, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String convertMapToJsonStringRepresentation(Map<String, String> map) {
        StringWriter writer = new StringWriter();
        try (JsonGenerator jsonGenerator = this.jsonFactory.createGenerator((Writer)writer);){
            jsonGenerator.writeStartObject();
            for (Map.Entry<String, String> hstoreEntry : map.entrySet()) {
                jsonGenerator.writeStringField(hstoreEntry.getKey(), hstoreEntry.getValue());
            }
            jsonGenerator.writeEndObject();
            jsonGenerator.flush();
            String string = writer.getBuffer().toString();
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException("Couldn't serialize hstore value into JSON: " + map, e);
        }
    }

    protected Object convertBit(Column column, Field fieldDefn, Object data) {
        if (data instanceof String) {
            data = Integer.valueOf((String)data, 2);
        }
        return super.convertBit(column, fieldDefn, data);
    }

    protected Object convertBits(Column column, Field fieldDefn, Object data, int numBytes) {
        if (data instanceof PGobject) {
            data = ((PGobject)data).getValue();
        }
        if (data instanceof String) {
            String dataStr = (String)data;
            BitSet bitset = new BitSet(dataStr.length());
            int len = dataStr.length();
            for (int i = len - 1; i >= 0; --i) {
                if (dataStr.charAt(i) != '1') continue;
                bitset.set(len - i - 1);
            }
            int numBits = bitset.length();
            int bitBytes = numBits / 8 + (numBits % 8 == 0 ? 0 : 1);
            return super.convertBits(column, fieldDefn, (Object)bitset, bitBytes);
        }
        return super.convertBits(column, fieldDefn, data, numBytes);
    }

    protected Object convertMoney(Column column, Field fieldDefn, Object data) {
        return this.convertValue(column, fieldDefn, data, BigDecimal.ZERO.setScale(2), r -> {
            if (data instanceof Double) {
                r.deliver((Object)BigDecimal.valueOf((Double)data).setScale(2));
            } else if (data instanceof Number) {
                r.deliver((Object)BigDecimal.valueOf(((Number)data).longValue(), 2));
            }
        });
    }

    protected Object convertInterval(Column column, Field fieldDefn, Object data) {
        return this.convertValue(column, fieldDefn, data, NumberConversions.LONG_FALSE, r -> {
            if (data instanceof Number) {
                long micros = ((Number)data).longValue();
                if (this.intervalMode == PostgresConnectorConfig.IntervalHandlingMode.STRING) {
                    r.deliver((Object)Interval.toIsoString((int)0, (int)0, (int)0, (int)0, (int)0, (BigDecimal)new BigDecimal(micros).divide(MICROSECONDS_PER_SECOND)));
                } else {
                    r.deliver((Object)micros);
                }
            }
            if (data instanceof PGInterval) {
                PGInterval interval = (PGInterval)data;
                if (this.intervalMode == PostgresConnectorConfig.IntervalHandlingMode.STRING) {
                    r.deliver((Object)Interval.toIsoString((int)interval.getYears(), (int)interval.getMonths(), (int)interval.getDays(), (int)interval.getHours(), (int)interval.getMinutes(), (BigDecimal)new BigDecimal(interval.getSeconds())));
                } else {
                    r.deliver((Object)MicroDuration.durationMicros((int)interval.getYears(), (int)interval.getMonths(), (int)interval.getDays(), (int)interval.getHours(), (int)interval.getMinutes(), (double)interval.getSeconds(), (Double)30.4375));
                }
            }
        });
    }

    protected Object convertTimestampWithZone(Column column, Field fieldDefn, Object data) {
        if (data instanceof java.util.Date) {
            data = OffsetDateTime.ofInstant(((java.util.Date)data).toInstant(), ZoneOffset.UTC);
        }
        if (POSITIVE_INFINITY_OFFSET_DATE_TIME.equals(data)) {
            return "infinity";
        }
        if (NEGATIVE_INFINITY_OFFSET_DATE_TIME.equals(data)) {
            return "-infinity";
        }
        return super.convertTimestampWithZone(column, fieldDefn, data);
    }

    protected Object convertTimeWithZone(Column column, Field fieldDefn, Object data) {
        if (data instanceof String) {
            OffsetTime offsetTime = OffsetTime.parse((String)data, TIME_WITH_TIMEZONE_FORMATTER);
            data = offsetTime.withOffsetSameInstant(ZoneOffset.UTC);
        }
        return super.convertTimeWithZone(column, fieldDefn, data);
    }

    protected Object convertGeometry(Column column, Field fieldDefn, Object data) {
        PostgisGeometry empty = PostgisGeometry.createEmpty();
        return this.convertValue(column, fieldDefn, data, Geometry.createValue((Schema)fieldDefn.schema(), (byte[])empty.getWkb(), (Integer)empty.getSrid()), r -> {
            try {
                Schema schema = fieldDefn.schema();
                if (data instanceof byte[]) {
                    PostgisGeometry geom = PostgisGeometry.fromHexEwkb(new String((byte[])data, "ASCII"));
                    r.deliver((Object)Geometry.createValue((Schema)schema, (byte[])geom.getWkb(), (Integer)geom.getSrid()));
                } else if (data instanceof PGobject) {
                    PGobject pgo = (PGobject)data;
                    PostgisGeometry geom = PostgisGeometry.fromHexEwkb(pgo.getValue());
                    r.deliver((Object)Geometry.createValue((Schema)schema, (byte[])geom.getWkb(), (Integer)geom.getSrid()));
                } else if (data instanceof String) {
                    PostgisGeometry geom = PostgisGeometry.fromHexEwkb((String)data);
                    r.deliver((Object)Geometry.createValue((Schema)schema, (byte[])geom.getWkb(), (Integer)geom.getSrid()));
                }
            }
            catch (UnsupportedEncodingException | IllegalArgumentException e) {
                this.logger.warn("Error converting to a Geometry type", (Object)column);
            }
        });
    }

    protected Object convertGeography(Column column, Field fieldDefn, Object data) {
        PostgisGeometry empty = PostgisGeometry.createEmpty();
        return this.convertValue(column, fieldDefn, data, Geography.createValue((Schema)fieldDefn.schema(), (byte[])empty.getWkb(), (Integer)empty.getSrid()), r -> {
            Schema schema = fieldDefn.schema();
            try {
                if (data instanceof byte[]) {
                    PostgisGeometry geom = PostgisGeometry.fromHexEwkb(new String((byte[])data, "ASCII"));
                    r.deliver((Object)Geography.createValue((Schema)schema, (byte[])geom.getWkb(), (Integer)geom.getSrid()));
                } else if (data instanceof PGobject) {
                    PGobject pgo = (PGobject)data;
                    PostgisGeometry geom = PostgisGeometry.fromHexEwkb(pgo.getValue());
                    r.deliver((Object)Geography.createValue((Schema)schema, (byte[])geom.getWkb(), (Integer)geom.getSrid()));
                } else if (data instanceof String) {
                    PostgisGeometry geom = PostgisGeometry.fromHexEwkb((String)data);
                    r.deliver((Object)Geography.createValue((Schema)schema, (byte[])geom.getWkb(), (Integer)geom.getSrid()));
                }
            }
            catch (UnsupportedEncodingException | IllegalArgumentException e) {
                this.logger.warn("Error converting to a Geography type", (Object)column);
            }
        });
    }

    protected Object convertCitext(Column column, Field fieldDefn, Object data) {
        return this.convertValue(column, fieldDefn, data, "", r -> {
            if (data instanceof byte[]) {
                r.deliver((Object)new String((byte[])data));
            } else if (data instanceof String) {
                r.deliver(data);
            } else if (data instanceof PGobject) {
                r.deliver((Object)((PGobject)data).getValue());
            }
        });
    }

    protected Object convertPoint(Column column, Field fieldDefn, Object data) {
        return this.convertValue(column, fieldDefn, data, Point.createValue((Schema)fieldDefn.schema(), (double)0.0, (double)0.0), r -> {
            Schema schema = fieldDefn.schema();
            if (data instanceof PGpoint) {
                PGpoint pgPoint = (PGpoint)data;
                r.deliver((Object)Point.createValue((Schema)schema, (double)pgPoint.x, (double)pgPoint.y));
            } else if (data instanceof String) {
                String dataString = data.toString();
                try {
                    PGpoint pgPoint = new PGpoint(dataString);
                    r.deliver((Object)Point.createValue((Schema)schema, (double)pgPoint.x, (double)pgPoint.y));
                }
                catch (SQLException e) {
                    this.logger.warn("Error converting the string '{}' to a PGPoint type for the column '{}'", (Object)dataString, (Object)column);
                }
            } else if (data instanceof PgProto.Point) {
                r.deliver((Object)Point.createValue((Schema)schema, (double)((PgProto.Point)data).getX(), (double)((PgProto.Point)data).getY()));
            }
        });
    }

    protected Object convertArray(Column column, Field fieldDefn, PostgresType elementType, ValueConverter elementConverter, Object data) {
        return this.convertValue(column, fieldDefn, data, Collections.emptyList(), r -> {
            if (data instanceof List) {
                r.deliver(((List)data).stream().map(value -> this.resolveArrayValue(value, elementType)).map(arg_0 -> ((ValueConverter)elementConverter).convert(arg_0)).collect(Collectors.toList()));
            } else if (data instanceof PgArray) {
                try {
                    Object[] values = (Object[])((PgArray)data).getArray();
                    ArrayList<Object> converted = new ArrayList<Object>(values.length);
                    for (Object value2 : values) {
                        converted.add(elementConverter.convert(this.resolveArrayValue(value2, elementType)));
                    }
                    r.deliver(converted);
                }
                catch (SQLException e) {
                    throw new ConnectException("Failed to read value of array " + column.name());
                }
            }
        });
    }

    private Object resolveArrayValue(Object value, PostgresType elementType) {
        switch (elementType.getOid()) {
            case 1266: {
                if (!(value instanceof Time)) break;
                ZonedDateTime zonedDateTime = ZonedDateTime.of(LocalDate.now(), ((Time)value).toLocalTime(), ZoneId.systemDefault());
                zonedDateTime = zonedDateTime.plus(ZoneId.systemDefault().getRules().getDaylightSavings(zonedDateTime.toInstant()));
                return OffsetTime.of(zonedDateTime.withZoneSameInstant(ZoneOffset.UTC).toLocalTime(), ZoneOffset.UTC);
            }
            case 1184: {
                if (!(value instanceof Timestamp)) break;
                ZonedDateTime zonedDateTime = ZonedDateTime.of(((Timestamp)value).toLocalDateTime(), ZoneId.systemDefault());
                return OffsetDateTime.of(zonedDateTime.withZoneSameInstant(ZoneOffset.UTC).toLocalDateTime(), ZoneOffset.UTC);
            }
        }
        return value;
    }

    private boolean isVariableScaleDecimal(Column column) {
        return column.length() == 131089 && column.scale().orElseGet(() -> 0) == 0;
    }

    public static Optional<SpecialValueDecimal> toSpecialValue(String value) {
        switch (value) {
            case "NaN": {
                return Optional.of(SpecialValueDecimal.NOT_A_NUMBER);
            }
            case "Infinity": {
                return Optional.of(SpecialValueDecimal.POSITIVE_INF);
            }
            case "-Infinity": {
                return Optional.of(SpecialValueDecimal.NEGATIVE_INF);
            }
        }
        return Optional.empty();
    }

    protected Object convertTimestampToLocalDateTime(Column column, Field fieldDefn, Object data) {
        if (data == null) {
            return null;
        }
        if (!(data instanceof Timestamp)) {
            return data;
        }
        Timestamp timestamp = (Timestamp)data;
        if (POSITIVE_INFINITY_TIMESTAMP.equals(timestamp)) {
            return POSITIVE_INFINITY_LOCAL_DATE_TIME;
        }
        if (NEGATIVE_INFINITY_TIMESTAMP.equals(timestamp)) {
            return NEGATIVE_INFINITY_LOCAL_DATE_TIME;
        }
        Instant instant = timestamp.toInstant();
        LocalDateTime utcTime = LocalDateTime.ofInstant(instant, ZoneOffset.systemDefault());
        return utcTime;
    }

    protected int getTimePrecision(Column column) {
        return column.scale().orElse(-1);
    }

    protected Object convertBinaryToBytes(Column column, Field fieldDefn, Object data) {
        if (data == UnchangedToastedReplicationMessageColumn.UNCHANGED_TOAST_VALUE) {
            return this.toastPlaceholderBinary;
        }
        if (data instanceof PgArray) {
            data = ((PgArray)data).toString();
        }
        return super.convertBinaryToBytes(column, fieldDefn, data instanceof PGobject ? ((PGobject)data).getValue() : data);
    }

    protected Object convertBinaryToBase64(Column column, Field fieldDefn, Object data) {
        return super.convertBinaryToBase64(column, fieldDefn, data instanceof PGobject ? ((PGobject)data).getValue() : data);
    }

    protected Object convertBinaryToHex(Column column, Field fieldDefn, Object data) {
        return super.convertBinaryToHex(column, fieldDefn, data instanceof PGobject ? ((PGobject)data).getValue() : data);
    }

    protected Object convertString(Column column, Field fieldDefn, Object data) {
        if (data == UnchangedToastedReplicationMessageColumn.UNCHANGED_TOAST_VALUE) {
            return this.toastPlaceholderString;
        }
        return super.convertString(column, fieldDefn, data);
    }

    protected Object handleUnknownData(Column column, Field fieldDefn, Object data) {
        if (data == UnchangedToastedReplicationMessageColumn.UNCHANGED_TOAST_VALUE) {
            return this.toastPlaceholderString;
        }
        return super.handleUnknownData(column, fieldDefn, data);
    }
}

