/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.postgresql;

import io.debezium.annotation.Immutable;
import io.debezium.connector.postgresql.PostgresConnectorConfig;
import io.debezium.relational.Selectors;
import io.debezium.relational.Tables;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;

@Immutable
public class Filters {
    protected static final List<String> SYSTEM_SCHEMAS = Arrays.asList("pg_catalog", "information_schema");
    protected static final String SYSTEM_SCHEMA_BLACKLIST = String.join((CharSequence)",", SYSTEM_SCHEMAS);
    protected static final Predicate<String> IS_SYSTEM_SCHEMA = SYSTEM_SCHEMAS::contains;
    protected static final String TEMP_TABLE_BLACKLIST = ".*\\.pg_temp.*";
    private final Tables.TableFilter tableFilter;
    private final Tables.ColumnNameFilter columnFilter;

    public Filters(PostgresConnectorConfig config) {
        String schemaBlacklist = config.schemaBlacklist();
        schemaBlacklist = schemaBlacklist != null ? schemaBlacklist + "," + SYSTEM_SCHEMA_BLACKLIST : SYSTEM_SCHEMA_BLACKLIST;
        String tableBlacklist = config.tableBlacklist();
        tableBlacklist = tableBlacklist != null ? tableBlacklist + "," + TEMP_TABLE_BLACKLIST : TEMP_TABLE_BLACKLIST;
        this.tableFilter = Tables.TableFilter.fromPredicate((Predicate)Selectors.tableSelector().includeTables(config.tableWhitelist()).excludeTables(tableBlacklist).includeSchemas(config.schemaWhitelist()).excludeSchemas(schemaBlacklist).build());
        String columnWhitelist = config.columnWhitelist();
        this.columnFilter = columnWhitelist != null ? Tables.ColumnNameFilterFactory.createWhitelistFilter((String)config.columnWhitelist()) : Tables.ColumnNameFilterFactory.createBlacklistFilter((String)config.columnBlacklist());
    }

    protected Tables.TableFilter tableFilter() {
        return this.tableFilter;
    }

    protected Tables.ColumnNameFilter columnFilter() {
        return this.columnFilter;
    }
}

