/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.postgresql;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.config.Field;
import io.debezium.connector.AbstractSourceInfo;
import io.debezium.connector.SourceInfoStructMaker;
import io.debezium.connector.postgresql.LegacyV1PostgresSourceInfoStructMaker;
import io.debezium.connector.postgresql.Module;
import io.debezium.connector.postgresql.PostgresSourceInfoStructMaker;
import io.debezium.connector.postgresql.connection.MessageDecoder;
import io.debezium.connector.postgresql.connection.MessageDecoderConfig;
import io.debezium.connector.postgresql.connection.pgoutput.PgOutputMessageDecoder;
import io.debezium.connector.postgresql.connection.pgproto.PgProtoMessageDecoder;
import io.debezium.connector.postgresql.connection.wal2json.NonStreamingWal2JsonMessageDecoder;
import io.debezium.connector.postgresql.connection.wal2json.StreamingWal2JsonMessageDecoder;
import io.debezium.connector.postgresql.snapshot.AlwaysSnapshotter;
import io.debezium.connector.postgresql.snapshot.ExportedSnapshotter;
import io.debezium.connector.postgresql.snapshot.InitialOnlySnapshotter;
import io.debezium.connector.postgresql.snapshot.InitialSnapshotter;
import io.debezium.connector.postgresql.snapshot.NeverSnapshotter;
import io.debezium.connector.postgresql.spi.Snapshotter;
import io.debezium.heartbeat.Heartbeat;
import io.debezium.jdbc.JdbcConfiguration;
import io.debezium.relational.RelationalDatabaseConnectorConfig;
import io.debezium.relational.TableId;
import io.debezium.relational.Tables;
import io.debezium.util.Strings;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigValue;

public class PostgresConnectorConfig
extends RelationalDatabaseConnectorConfig {
    protected static final String DATABASE_CONFIG_PREFIX = "database.";
    protected static final int DEFAULT_PORT = 5432;
    protected static final int DEFAULT_SNAPSHOT_FETCH_SIZE = 10240;
    protected static final int DEFAULT_MAX_RETRIES = 6;
    protected static final Duration DEFAULT_RETRY_DELAY = Duration.ofSeconds(10L);
    private static final String TABLE_WHITELIST_NAME = "table.whitelist";
    public static final Field PLUGIN_NAME = Field.create((String)"plugin.name").withDisplayName("Plugin").withEnum(LogicalDecoder.class, (Enum)LogicalDecoder.DECODERBUFS).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.MEDIUM).withDescription("The name of the Postgres logical decoding plugin installed on the server. Supported values are '" + LogicalDecoder.DECODERBUFS.getValue() + "' and '" + LogicalDecoder.WAL2JSON.getValue() + "'. Defaults to '" + LogicalDecoder.DECODERBUFS.getValue() + "'.");
    public static final Field SLOT_NAME = Field.create((String)"slot.name").withDisplayName("Slot").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.MEDIUM).withDefault("debezium").withValidation(new Field.Validator[]{PostgresConnectorConfig::validateReplicationSlotName}).withDescription("The name of the Postgres logical decoding slot created for streaming changes from a plugin.Defaults to 'debezium");
    public static final Field DROP_SLOT_ON_STOP = Field.create((String)"slot.drop.on.stop").withDisplayName("Drop slot on stop").withType(ConfigDef.Type.BOOLEAN).withDefault(false).withImportance(ConfigDef.Importance.MEDIUM).withDescription("Whether or not to drop the logical replication slot when the connector finishes orderlyBy default the replication is kept so that on restart progress can resume from the last recorded location");
    public static final Field PUBLICATION_NAME = Field.create((String)"publication.name").withDisplayName("Publication").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.MEDIUM).withDefault("dbz_publication").withDescription("The name of the Postgres 10+ publication used for streaming changes from a plugin.Defaults to 'dbz_publication'");
    public static final Field STREAM_PARAMS = Field.create((String)"slot.stream.params").withDisplayName("Optional parameters to pass to the logical decoder when the stream is started.").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.LOW).withDescription("Any optional parameters used by logical decoding plugin. Semi-colon separated. E.g. 'add-tables=public.table,public.table2;include-lsn=true'");
    public static final Field MAX_RETRIES = Field.create((String)"slot.max.retries").withDisplayName("Retry count").withType(ConfigDef.Type.INT).withImportance(ConfigDef.Importance.LOW).withDefault(6).withValidation(new Field.Validator[]{Field::isInteger}).withDescription("How many times to retry connecting to a replication slot when an attempt fails.");
    public static final Field RETRY_DELAY_MS = Field.create((String)"slot.retry.delay.ms").withDisplayName("Retry delay").withType(ConfigDef.Type.LONG).withImportance(ConfigDef.Importance.LOW).withDefault(DEFAULT_RETRY_DELAY.toMillis()).withValidation(new Field.Validator[]{Field::isInteger}).withDescription("The number of milli-seconds to wait between retry attempts when the connector fails to connect to a replication slot.");
    public static final Field HOSTNAME = Field.create((String)("database." + JdbcConfiguration.HOSTNAME)).withDisplayName("Hostname").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.HIGH).withValidation(new Field.Validator[]{Field::isRequired}).withDescription("Resolvable hostname or IP address of the Postgres database server.");
    public static final Field PORT = Field.create((String)("database." + JdbcConfiguration.PORT)).withDisplayName("Port").withType(ConfigDef.Type.INT).withWidth(ConfigDef.Width.SHORT).withDefault(5432).withImportance(ConfigDef.Importance.HIGH).withValidation(new Field.Validator[]{Field::isInteger}).withDescription("Port of the Postgres database server.");
    public static final Field USER = Field.create((String)("database." + JdbcConfiguration.USER)).withDisplayName("User").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.HIGH).withValidation(new Field.Validator[]{Field::isRequired}).withDescription("Name of the Postgres database user to be used when connecting to the database.");
    public static final Field PASSWORD = Field.create((String)("database." + JdbcConfiguration.PASSWORD)).withDisplayName("Password").withType(ConfigDef.Type.PASSWORD).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.HIGH).withDescription("Password of the Postgres database user to be used when connecting to the database.");
    public static final Field DATABASE_NAME = Field.create((String)("database." + JdbcConfiguration.DATABASE)).withDisplayName("Database").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.HIGH).withValidation(new Field.Validator[]{Field::isRequired}).withDescription("The name of the database the connector should be monitoring");
    public static final Field ON_CONNECT_STATEMENTS = Field.create((String)("database." + JdbcConfiguration.ON_CONNECT_STATEMENTS)).withDisplayName("Initial statements").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.LOW).withDescription("A semicolon separated list of SQL statements to be executed when a JDBC connection to the database is established. Note that the connector may establish JDBC connections at its own discretion, so this should typically be used for configurationof session parameters only, but not for executing DML statements. Use doubled semicolon (';;') to use a semicolon as a character and not as a delimiter.");
    public static final Field SSL_MODE = Field.create((String)"database.sslmode").withDisplayName("SSL mode").withEnum(SecureConnectionMode.class, (Enum)SecureConnectionMode.DISABLED).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.MEDIUM).withDescription("Whether to use an encrypted connection to Postgres. Options include'disable' (the default) to use an unencrypted connection; 'require' to use a secure (encrypted) connection, and fail if one cannot be established; 'verify-ca' like 'required' but additionally verify the server TLS certificate against the configured Certificate Authority (CA) certificates, or fail if no valid matching CA certificates are found; or'verify-full' like 'verify-ca' but additionally verify that the server certificate matches the host to which the connection is attempted.");
    public static final Field SSL_CLIENT_CERT = Field.create((String)"database.sslcert").withDisplayName("SSL Client Certificate").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.MEDIUM).withDescription("File containing the SSL Certificate for the client. See the Postgres SSL docs for further information");
    public static final Field SSL_CLIENT_KEY = Field.create((String)"database.sslkey").withDisplayName("SSL Client Key").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.MEDIUM).withDescription("File containing the SSL private key for the client. See the Postgres SSL docs for further information");
    public static final Field SSL_CLIENT_KEY_PASSWORD = Field.create((String)"database.sslpassword").withDisplayName("SSL Client Key Password").withType(ConfigDef.Type.PASSWORD).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.MEDIUM).withDescription("Password to access the client private key from the file specified by 'database.sslkey'. See the Postgres SSL docs for further information");
    public static final Field SSL_ROOT_CERT = Field.create((String)"database.sslrootcert").withDisplayName("SSL Root Certificate").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.MEDIUM).withDescription("File containing the root certificate(s) against which the server is validated. See the Postgres JDBC SSL docs for further information");
    public static final Field SSL_SOCKET_FACTORY = Field.create((String)"database.sslfactory").withDisplayName("SSL Root Certificate").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.MEDIUM).withDescription("A name of class to that creates SSL Sockets. Use org.postgresql.ssl.NonValidatingFactory to disable SSL validation in development environments");
    public static final Field TABLE_WHITELIST = Field.create((String)"table.whitelist").withDisplayName("Tables").withType(ConfigDef.Type.LIST).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.HIGH).withValidation(new Field.Validator[]{Field::isListOfRegex}).withDescription("The tables for which changes are to be captured");
    public static final Field TABLE_BLACKLIST = Field.create((String)"table.blacklist").withDisplayName("Exclude Tables").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.MEDIUM).withValidation(new Field.Validator[]{Field::isListOfRegex, PostgresConnectorConfig::validateTableBlacklist}).withInvisibleRecommender();
    public static final Field INCLUDE_SCHEMA_CHANGES = Field.create((String)"include.schema.changes").withDisplayName("Include database schema changes").withType(ConfigDef.Type.BOOLEAN).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.MEDIUM).withDescription("Whether the connector should publish changes in the database schema to a Kafka topic with the same name as the database server name.The default is 'false' because atm this feature is not supported by Postgres logical decoding").withDefault(false);
    public static final Field SNAPSHOT_MODE = Field.create((String)"snapshot.mode").withDisplayName("Snapshot mode").withEnum(SnapshotMode.class, (Enum)SnapshotMode.INITIAL).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.MEDIUM).withDescription("The criteria for running a snapshot upon startup of the connector. Options include: 'always' to specify that the connector run a snapshot each time it starts up; 'initial' (the default) to specify the connector can run a snapshot only when no offsets are available for the logical server name; 'initial_only' same as 'initial' except the connector should stop after completing the snapshot and before it would normally start emitting changes;'never' to specify the connector should never run a snapshot and that upon first startup the connector should read from the last position (LSN) recorded by the server; and'exported' to specify the connector should run a snapshot based on the position when the replication slot was created; 'custom' to specify a custom class with 'snapshot.custom_class' which will be loaded and used to determine the snapshot, see docs for more details.");
    public static final Field SNAPSHOT_MODE_CLASS = Field.create((String)"snapshot.custom.class").withDisplayName("Snapshot Mode Custom Class").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.MEDIUM).withValidation(new Field.Validator[]{(config, field, output) -> {
        if (config.getString(SNAPSHOT_MODE).toLowerCase().equals("custom") && config.getString(field).isEmpty()) {
            output.accept(field, (Object)"", "snapshot.custom_class cannot be empty when snapshot.mode 'custom' is defined");
            return 1;
        }
        return 0;
    }}).withDescription("When 'snapshot.mode' is set as custom, this setting must be set to specify a fully qualified class name to load (via the default class loader).This class must implement the 'Snapshotter' interface and is called on each app boot to determine whether to do a snapshot and how to build queries.");
    public static final Field HSTORE_HANDLING_MODE = Field.create((String)"hstore.handling.mode").withDisplayName("HStore Handling").withEnum(HStoreHandlingMode.class, (Enum)HStoreHandlingMode.JSON).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.LOW).withDescription("Specify how HSTORE columns should be represented in change events, including:'json' represents values as string-ified JSON (default)'map' represents values as a key/value map");
    public static final Field INTERVAL_HANDLING_MODE = Field.create((String)"interval.handling.mode").withDisplayName("Interval Handling").withEnum(IntervalHandlingMode.class, (Enum)IntervalHandlingMode.NUMERIC).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.LOW).withDescription("Specify how INTERVAL columns should be represented in change events, including:'string' represents values as an exact ISO formatted string'numeric' (default) represents values using the inexact conversion into microseconds");
    public static final Field STATUS_UPDATE_INTERVAL_MS = Field.create((String)"status.update.interval.ms").withDisplayName("Status update interval (ms)").withType(ConfigDef.Type.INT).withDefault(10000).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.MEDIUM).withDescription("Frequency in milliseconds for sending replication connection status updates to the server. Defaults to 10 seconds (10000 ms).").withValidation(new Field.Validator[]{Field::isPositiveInteger});
    public static final Field TCP_KEEPALIVE = Field.create((String)"database.tcpKeepAlive").withDisplayName("TCP keep-alive probe").withType(ConfigDef.Type.BOOLEAN).withDefault(true).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.MEDIUM).withDescription("Enable or disable TCP keep-alive probe to avoid dropping TCP connection").withValidation(new Field.Validator[]{Field::isBoolean});
    public static final Field INCLUDE_UNKNOWN_DATATYPES = Field.create((String)"include.unknown.datatypes").withDisplayName("Include unknown datatypes").withType(ConfigDef.Type.BOOLEAN).withDefault(false).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.MEDIUM).withDescription("Specify whether the fields of data type not supported by Debezium should be processed:'false' (the default) omits the fields; 'true' converts the field into an implementation dependent binary representation.");
    public static final Field SCHEMA_REFRESH_MODE = Field.create((String)"schema.refresh.mode").withDisplayName("Schema refresh mode").withEnum(SchemaRefreshMode.class, (Enum)SchemaRefreshMode.COLUMNS_DIFF).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.MEDIUM).withDescription("Specify the conditions that trigger a refresh of the in-memory schema for a table. 'columns_diff' (the default) is the safest mode, ensuring the in-memory schema stays in-sync with the database table's schema at all times. 'columns_diff_exclude_unchanged_toast' instructs the connector to refresh the in-memory schema cache if there is a discrepancy between it and the schema derived from the incoming message, unless unchanged TOASTable data fully accounts for the discrepancy. This setting can improve connector performance significantly if there are frequently-updated tables that have TOASTed data that are rarely part of these updates. However, it is possible for the in-memory schema to become outdated if TOASTable columns are dropped from the table.");
    public static final Field XMIN_FETCH_INTERVAL = Field.create((String)"xmin.fetch.interval.ms").withDisplayName("Xmin fetch interval (ms)").withType(ConfigDef.Type.LONG).withWidth(ConfigDef.Width.SHORT).withDefault(0L).withImportance(ConfigDef.Importance.MEDIUM).withDescription("Specify how often (in ms) the xmin will be fetched from the replication slot. This xmin value is exposed by the slot which gives a lower bound of where a new replication slot could start from. The lower the value, the more likely this value is to be the current 'true' value, but the bigger the performance cost. The bigger the value, the less likely this value is to be the current 'true' value, but the lower the performance penalty. The default is set to 0 ms, which disables tracking xmin.").withValidation(new Field.Validator[]{Field::isNonNegativeLong});
    public static final Field TOASTED_VALUE_PLACEHOLDER = Field.create((String)"toasted.value.placeholder").withDisplayName("Toasted value placeholder").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.MEDIUM).withDefault("__debezium_unavailable_value").withImportance(ConfigDef.Importance.MEDIUM).withDescription("Specify the constant that will be provided by Debezium to indicate that the original value is a toasted value not provided by the database.If starts with 'hex:' prefix it is expected that the rest of the string repesents hexadecimally encoded octets.");
    public static Field.Set ALL_FIELDS = Field.setOf((Field[])new Field[]{PLUGIN_NAME, SLOT_NAME, DROP_SLOT_ON_STOP, PUBLICATION_NAME, STREAM_PARAMS, MAX_RETRIES, RETRY_DELAY_MS, DATABASE_NAME, USER, PASSWORD, HOSTNAME, PORT, ON_CONNECT_STATEMENTS, RelationalDatabaseConnectorConfig.SERVER_NAME, CommonConnectorConfig.MAX_BATCH_SIZE, CommonConnectorConfig.MAX_QUEUE_SIZE, CommonConnectorConfig.POLL_INTERVAL_MS, CommonConnectorConfig.SNAPSHOT_DELAY_MS, CommonConnectorConfig.SNAPSHOT_FETCH_SIZE, Heartbeat.HEARTBEAT_INTERVAL, Heartbeat.HEARTBEAT_TOPICS_PREFIX, SCHEMA_WHITELIST, SCHEMA_BLACKLIST, TABLE_WHITELIST, TABLE_BLACKLIST, MSG_KEY_COLUMNS, COLUMN_BLACKLIST, SNAPSHOT_MODE, TIME_PRECISION_MODE, DECIMAL_HANDLING_MODE, HSTORE_HANDLING_MODE, INTERVAL_HANDLING_MODE, SSL_MODE, SSL_CLIENT_CERT, SSL_CLIENT_KEY_PASSWORD, SSL_ROOT_CERT, SSL_CLIENT_KEY, RelationalDatabaseConnectorConfig.SNAPSHOT_LOCK_TIMEOUT_MS, SSL_SOCKET_FACTORY, STATUS_UPDATE_INTERVAL_MS, TCP_KEEPALIVE, INCLUDE_UNKNOWN_DATATYPES, RelationalDatabaseConnectorConfig.SNAPSHOT_SELECT_STATEMENT_OVERRIDES_BY_TABLE, SCHEMA_REFRESH_MODE, CommonConnectorConfig.TOMBSTONES_ON_DELETE, CommonConnectorConfig.PROVIDE_TRANSACTION_METADATA, XMIN_FETCH_INTERVAL, TOASTED_VALUE_PLACEHOLDER, SNAPSHOT_MODE_CLASS, CommonConnectorConfig.SOURCE_STRUCT_MAKER_VERSION, CommonConnectorConfig.EVENT_PROCESSING_FAILURE_HANDLING_MODE});
    private final HStoreHandlingMode hStoreHandlingMode;
    private final IntervalHandlingMode intervalHandlingMode;
    private final SnapshotMode snapshotMode;
    private final SchemaRefreshMode schemaRefreshMode;

    public static final Field MASK_COLUMN(int length) {
        if (length <= 0) {
            throw new IllegalArgumentException("The mask length must be positive");
        }
        return Field.create((String)("column.mask.with." + length + ".chars")).withValidation(new Field.Validator[]{Field::isInteger}).withDescription("A comma-separated list of regular expressions matching fully-qualified names of columns that should be masked with " + length + " asterisk ('*') characters.");
    }

    protected PostgresConnectorConfig(Configuration config) {
        super(config, config.getString(RelationalDatabaseConnectorConfig.SERVER_NAME), (Tables.TableFilter)new SystemTablesPredicate(), x -> x.schema() + "." + x.table(), 10240);
        HStoreHandlingMode hStoreHandlingMode;
        String hstoreHandlingModeStr = config.getString(HSTORE_HANDLING_MODE);
        this.hStoreHandlingMode = hStoreHandlingMode = HStoreHandlingMode.parse(hstoreHandlingModeStr);
        this.intervalHandlingMode = IntervalHandlingMode.parse(config.getString(INTERVAL_HANDLING_MODE));
        this.snapshotMode = SnapshotMode.parse(config.getString(SNAPSHOT_MODE));
        this.schemaRefreshMode = SchemaRefreshMode.parse(config.getString(SCHEMA_REFRESH_MODE));
    }

    protected String hostname() {
        return this.getConfig().getString(HOSTNAME);
    }

    protected int port() {
        return this.getConfig().getInteger(PORT);
    }

    protected String databaseName() {
        return this.getConfig().getString(DATABASE_NAME);
    }

    protected LogicalDecoder plugin() {
        return LogicalDecoder.parse(this.getConfig().getString(PLUGIN_NAME));
    }

    protected String slotName() {
        return this.getConfig().getString(SLOT_NAME);
    }

    protected boolean dropSlotOnStop() {
        if (this.getConfig().hasKey(DROP_SLOT_ON_STOP.name())) {
            return this.getConfig().getBoolean(DROP_SLOT_ON_STOP);
        }
        return this.getConfig().getBoolean(DROP_SLOT_ON_STOP);
    }

    protected String publicationName() {
        return this.getConfig().getString(PUBLICATION_NAME);
    }

    protected String streamParams() {
        return this.getConfig().getString(STREAM_PARAMS);
    }

    protected int maxRetries() {
        return this.getConfig().getInteger(MAX_RETRIES);
    }

    protected Duration retryDelay() {
        return Duration.ofMillis(this.getConfig().getInteger(RETRY_DELAY_MS));
    }

    protected Duration statusUpdateInterval() {
        return Duration.ofMillis(this.getConfig().getLong(STATUS_UPDATE_INTERVAL_MS));
    }

    protected HStoreHandlingMode hStoreHandlingMode() {
        return this.hStoreHandlingMode;
    }

    protected IntervalHandlingMode intervalHandlingMode() {
        return this.intervalHandlingMode;
    }

    protected boolean includeUnknownDatatypes() {
        return this.getConfig().getBoolean(INCLUDE_UNKNOWN_DATATYPES);
    }

    public Configuration jdbcConfig() {
        return this.getConfig().subset(DATABASE_CONFIG_PREFIX, true);
    }

    protected Map<String, ConfigValue> validate() {
        return this.getConfig().validate(ALL_FIELDS);
    }

    protected String schemaBlacklist() {
        return this.getConfig().getString(SCHEMA_BLACKLIST);
    }

    protected String schemaWhitelist() {
        return this.getConfig().getString(SCHEMA_WHITELIST);
    }

    protected String tableBlacklist() {
        return this.getConfig().getString(TABLE_BLACKLIST);
    }

    protected String tableWhitelist() {
        return this.getConfig().getString(TABLE_WHITELIST);
    }

    protected String columnBlacklist() {
        return this.getConfig().getString(COLUMN_BLACKLIST);
    }

    protected Snapshotter getSnapshotter() {
        return this.snapshotMode.getSnapshotter(this.getConfig());
    }

    protected boolean skipRefreshSchemaOnMissingToastableData() {
        return SchemaRefreshMode.COLUMNS_DIFF_EXCLUDE_UNCHANGED_TOAST == this.schemaRefreshMode;
    }

    protected Duration xminFetchInterval() {
        return Duration.ofMillis(this.getConfig().getLong(XMIN_FETCH_INTERVAL));
    }

    protected byte[] toastedValuePlaceholder() {
        String placeholder = this.getConfig().getString(TOASTED_VALUE_PLACEHOLDER);
        if (placeholder.startsWith("hex:")) {
            return Strings.hexStringToByteArray((String)placeholder.substring(4));
        }
        return placeholder.getBytes();
    }

    protected SourceInfoStructMaker<? extends AbstractSourceInfo> getSourceInfoStructMaker(CommonConnectorConfig.Version version) {
        switch (version) {
            case V1: {
                return new LegacyV1PostgresSourceInfoStructMaker(Module.name(), Module.version(), (CommonConnectorConfig)this);
            }
        }
        return new PostgresSourceInfoStructMaker(Module.name(), Module.version(), (CommonConnectorConfig)this);
    }

    protected static ConfigDef configDef() {
        ConfigDef config = new ConfigDef();
        Field.group((ConfigDef)config, (String)"Postgres", (Field[])new Field[]{SLOT_NAME, PUBLICATION_NAME, PLUGIN_NAME, RelationalDatabaseConnectorConfig.SERVER_NAME, DATABASE_NAME, HOSTNAME, PORT, USER, PASSWORD, ON_CONNECT_STATEMENTS, SSL_MODE, SSL_CLIENT_CERT, SSL_CLIENT_KEY_PASSWORD, SSL_ROOT_CERT, SSL_CLIENT_KEY, DROP_SLOT_ON_STOP, STREAM_PARAMS, MAX_RETRIES, RETRY_DELAY_MS, SSL_SOCKET_FACTORY, STATUS_UPDATE_INTERVAL_MS, TCP_KEEPALIVE, XMIN_FETCH_INTERVAL});
        Field.group((ConfigDef)config, (String)"Events", (Field[])new Field[]{SCHEMA_WHITELIST, SCHEMA_BLACKLIST, TABLE_WHITELIST, TABLE_BLACKLIST, COLUMN_BLACKLIST, MSG_KEY_COLUMNS, INCLUDE_UNKNOWN_DATATYPES, SNAPSHOT_SELECT_STATEMENT_OVERRIDES_BY_TABLE, CommonConnectorConfig.TOMBSTONES_ON_DELETE, CommonConnectorConfig.PROVIDE_TRANSACTION_METADATA, Heartbeat.HEARTBEAT_INTERVAL, Heartbeat.HEARTBEAT_TOPICS_PREFIX, CommonConnectorConfig.SOURCE_STRUCT_MAKER_VERSION, TOASTED_VALUE_PLACEHOLDER, CommonConnectorConfig.EVENT_PROCESSING_FAILURE_HANDLING_MODE});
        Field.group((ConfigDef)config, (String)"Connector", (Field[])new Field[]{CommonConnectorConfig.POLL_INTERVAL_MS, CommonConnectorConfig.MAX_BATCH_SIZE, CommonConnectorConfig.MAX_QUEUE_SIZE, CommonConnectorConfig.SNAPSHOT_DELAY_MS, CommonConnectorConfig.SNAPSHOT_FETCH_SIZE, SNAPSHOT_MODE, RelationalDatabaseConnectorConfig.SNAPSHOT_LOCK_TIMEOUT_MS, TIME_PRECISION_MODE, DECIMAL_HANDLING_MODE, HSTORE_HANDLING_MODE, INTERVAL_HANDLING_MODE, SCHEMA_REFRESH_MODE, SNAPSHOT_MODE_CLASS});
        return config;
    }

    private static int validateTableBlacklist(Configuration config, Field field, Field.ValidationOutput problems) {
        String whitelist = config.getString(TABLE_WHITELIST);
        String blacklist = config.getString(TABLE_BLACKLIST);
        if (whitelist != null && blacklist != null) {
            problems.accept(TABLE_BLACKLIST, (Object)blacklist, "Table whitelist is already specified");
            return 1;
        }
        return 0;
    }

    private static int validateReplicationSlotName(Configuration config, Field field, Field.ValidationOutput problems) {
        String name = config.getString(field);
        int errors = 0;
        if (name != null && !name.matches("[a-z0-9_]{1,63}")) {
            problems.accept(field, (Object)name, "Valid replication slot name must contain only digits, lowercase characters and underscores with length <= 63");
            ++errors;
        }
        return errors;
    }

    public String getContextName() {
        return Module.contextName();
    }

    private static class SystemTablesPredicate
    implements Tables.TableFilter {
        protected static final List<String> SYSTEM_SCHEMAS = Arrays.asList("pg_catalog", "information_schema");

        private SystemTablesPredicate() {
        }

        public boolean isIncluded(TableId t) {
            return !SYSTEM_SCHEMAS.contains(t.schema().toLowerCase());
        }
    }

    public static enum SchemaRefreshMode implements EnumeratedValue
    {
        COLUMNS_DIFF("columns_diff"),
        COLUMNS_DIFF_EXCLUDE_UNCHANGED_TOAST("columns_diff_exclude_unchanged_toast");

        private final String value;

        private SchemaRefreshMode(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static SchemaRefreshMode parse(String value) {
            if (value == null) {
                return null;
            }
            value = value.trim();
            for (SchemaRefreshMode option : SchemaRefreshMode.values()) {
                if (!option.getValue().equalsIgnoreCase(value)) continue;
                return option;
            }
            return null;
        }
    }

    public static enum LogicalDecoder implements EnumeratedValue
    {
        PGOUTPUT("pgoutput"){

            @Override
            public MessageDecoder messageDecoder(MessageDecoderConfig config) {
                return new PgOutputMessageDecoder(config);
            }

            @Override
            public String getPostgresPluginName() {
                return this.getValue();
            }
        }
        ,
        DECODERBUFS("decoderbufs"){

            @Override
            public MessageDecoder messageDecoder(MessageDecoderConfig config) {
                return new PgProtoMessageDecoder();
            }

            @Override
            public String getPostgresPluginName() {
                return this.getValue();
            }
        }
        ,
        WAL2JSON_STREAMING("wal2json_streaming"){

            @Override
            public MessageDecoder messageDecoder(MessageDecoderConfig config) {
                return new StreamingWal2JsonMessageDecoder();
            }

            @Override
            public String getPostgresPluginName() {
                return "wal2json";
            }

            @Override
            public boolean hasUnchangedToastColumnMarker() {
                return false;
            }

            @Override
            public boolean sendsNullToastedValuesInOld() {
                return false;
            }
        }
        ,
        WAL2JSON_RDS_STREAMING("wal2json_rds_streaming"){

            @Override
            public MessageDecoder messageDecoder(MessageDecoderConfig config) {
                return new StreamingWal2JsonMessageDecoder();
            }

            @Override
            public boolean forceRds() {
                return true;
            }

            @Override
            public String getPostgresPluginName() {
                return "wal2json";
            }

            @Override
            public boolean hasUnchangedToastColumnMarker() {
                return false;
            }

            @Override
            public boolean sendsNullToastedValuesInOld() {
                return false;
            }
        }
        ,
        WAL2JSON("wal2json"){

            @Override
            public MessageDecoder messageDecoder(MessageDecoderConfig config) {
                return new NonStreamingWal2JsonMessageDecoder();
            }

            @Override
            public String getPostgresPluginName() {
                return "wal2json";
            }

            @Override
            public boolean hasUnchangedToastColumnMarker() {
                return false;
            }

            @Override
            public boolean sendsNullToastedValuesInOld() {
                return false;
            }
        }
        ,
        WAL2JSON_RDS("wal2json_rds"){

            @Override
            public MessageDecoder messageDecoder(MessageDecoderConfig config) {
                return new NonStreamingWal2JsonMessageDecoder();
            }

            @Override
            public boolean forceRds() {
                return true;
            }

            @Override
            public String getPostgresPluginName() {
                return "wal2json";
            }

            @Override
            public boolean hasUnchangedToastColumnMarker() {
                return false;
            }

            @Override
            public boolean sendsNullToastedValuesInOld() {
                return false;
            }
        };

        private final String decoderName;

        private LogicalDecoder(String decoderName) {
            this.decoderName = decoderName;
        }

        public abstract MessageDecoder messageDecoder(MessageDecoderConfig var1);

        public boolean forceRds() {
            return false;
        }

        public boolean hasUnchangedToastColumnMarker() {
            return true;
        }

        public boolean sendsNullToastedValuesInOld() {
            return true;
        }

        public static LogicalDecoder parse(String s) {
            return LogicalDecoder.valueOf(s.trim().toUpperCase());
        }

        public String getValue() {
            return this.decoderName;
        }

        public abstract String getPostgresPluginName();
    }

    public static enum SecureConnectionMode implements EnumeratedValue
    {
        DISABLED("disable"),
        REQUIRED("require"),
        VERIFY_CA("verify-ca"),
        VERIFY_FULL("verify-full");

        private final String value;

        private SecureConnectionMode(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static SecureConnectionMode parse(String value) {
            if (value == null) {
                return null;
            }
            value = value.trim();
            for (SecureConnectionMode option : SecureConnectionMode.values()) {
                if (!option.getValue().equalsIgnoreCase(value)) continue;
                return option;
            }
            return null;
        }

        public static SecureConnectionMode parse(String value, String defaultValue) {
            SecureConnectionMode mode = SecureConnectionMode.parse(value);
            if (mode == null && defaultValue != null) {
                mode = SecureConnectionMode.parse(defaultValue);
            }
            return mode;
        }
    }

    public static enum SnapshotMode implements EnumeratedValue
    {
        ALWAYS("always", c -> new AlwaysSnapshotter()),
        INITIAL("initial", c -> new InitialSnapshotter()),
        NEVER("never", c -> new NeverSnapshotter()),
        INITIAL_ONLY("initial_only", c -> new InitialOnlySnapshotter()),
        EXPORTED("exported", c -> new ExportedSnapshotter()),
        CUSTOM("custom", c -> (Snapshotter)c.getInstance(SNAPSHOT_MODE_CLASS, Snapshotter.class));

        private final String value;
        private final SnapshotterBuilder builderFunc;

        private SnapshotMode(String value, SnapshotterBuilder buildSnapshotter) {
            this.value = value;
            this.builderFunc = buildSnapshotter;
        }

        public Snapshotter getSnapshotter(Configuration config) {
            return this.builderFunc.buildSnapshotter(config);
        }

        public String getValue() {
            return this.value;
        }

        public static SnapshotMode parse(String value) {
            if (value == null) {
                return null;
            }
            value = value.trim();
            for (SnapshotMode option : SnapshotMode.values()) {
                if (!option.getValue().equalsIgnoreCase(value)) continue;
                return option;
            }
            return null;
        }

        public static SnapshotMode parse(String value, String defaultValue) {
            SnapshotMode mode = SnapshotMode.parse(value);
            if (mode == null && defaultValue != null) {
                mode = SnapshotMode.parse(defaultValue);
            }
            return mode;
        }

        @FunctionalInterface
        public static interface SnapshotterBuilder {
            public Snapshotter buildSnapshotter(Configuration var1);
        }
    }

    public static enum IntervalHandlingMode implements EnumeratedValue
    {
        NUMERIC("numeric"),
        STRING("string");

        private final String value;

        private IntervalHandlingMode(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static IntervalHandlingMode parse(String value) {
            if (value == null) {
                return null;
            }
            value = value.trim();
            for (IntervalHandlingMode option : IntervalHandlingMode.values()) {
                if (!option.getValue().equalsIgnoreCase(value)) continue;
                return option;
            }
            return null;
        }

        public static IntervalHandlingMode parse(String value, String defaultValue) {
            IntervalHandlingMode mode = IntervalHandlingMode.parse(value);
            if (mode == null && defaultValue != null) {
                mode = IntervalHandlingMode.parse(defaultValue);
            }
            return mode;
        }
    }

    public static enum HStoreHandlingMode implements EnumeratedValue
    {
        JSON("json"),
        MAP("map");

        private final String value;

        private HStoreHandlingMode(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static HStoreHandlingMode parse(String value) {
            if (value == null) {
                return null;
            }
            value = value.trim();
            for (HStoreHandlingMode option : HStoreHandlingMode.values()) {
                if (!option.getValue().equalsIgnoreCase(value)) continue;
                return option;
            }
            return null;
        }

        public static HStoreHandlingMode parse(String value, String defaultValue) {
            HStoreHandlingMode mode = HStoreHandlingMode.parse(value);
            if (mode == null && defaultValue != null) {
                mode = HStoreHandlingMode.parse(defaultValue);
            }
            return mode;
        }
    }
}

