/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.postgresql.connection.pgproto;

import io.debezium.connector.postgresql.PostgresStreamingChangeEventSource;
import io.debezium.connector.postgresql.PostgresType;
import io.debezium.connector.postgresql.TypeRegistry;
import io.debezium.connector.postgresql.UnchangedToastedReplicationMessageColumn;
import io.debezium.connector.postgresql.connection.AbstractReplicationMessageColumn;
import io.debezium.connector.postgresql.connection.ReplicationMessage;
import io.debezium.connector.postgresql.connection.ReplicationMessageColumnValueResolver;
import io.debezium.connector.postgresql.connection.pgproto.PgProtoColumnValue;
import io.debezium.connector.postgresql.proto.PgProto;
import io.debezium.util.Strings;
import java.time.Instant;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PgProtoReplicationMessage
implements ReplicationMessage {
    private static final Logger LOGGER = LoggerFactory.getLogger(PgProtoReplicationMessage.class);
    private final PgProto.RowMessage rawMessage;
    private final TypeRegistry typeRegistry;

    public PgProtoReplicationMessage(PgProto.RowMessage rawMessage, TypeRegistry typeRegistry) {
        this.rawMessage = rawMessage;
        this.typeRegistry = typeRegistry;
    }

    @Override
    public ReplicationMessage.Operation getOperation() {
        switch (this.rawMessage.getOp()) {
            case INSERT: {
                return ReplicationMessage.Operation.INSERT;
            }
            case UPDATE: {
                return ReplicationMessage.Operation.UPDATE;
            }
            case DELETE: {
                return ReplicationMessage.Operation.DELETE;
            }
        }
        throw new IllegalArgumentException("Unknown operation '" + (Object)((Object)this.rawMessage.getOp()) + "' in replication stream message");
    }

    @Override
    public Instant getCommitTime() {
        return Instant.ofEpochSecond(0L, this.rawMessage.getCommitTime() * 1000L);
    }

    @Override
    public long getTransactionId() {
        return Integer.toUnsignedLong(this.rawMessage.getTransactionId());
    }

    @Override
    public String getTable() {
        return this.rawMessage.getTable();
    }

    @Override
    public List<ReplicationMessage.Column> getOldTupleList() {
        return this.transform(this.rawMessage.getOldTupleList(), null);
    }

    @Override
    public List<ReplicationMessage.Column> getNewTupleList() {
        return this.transform(this.rawMessage.getNewTupleList(), this.rawMessage.getNewTypeinfoList());
    }

    @Override
    public boolean hasTypeMetadata() {
        return this.rawMessage.getNewTypeinfoList() != null && !this.rawMessage.getNewTypeinfoList().isEmpty();
    }

    private List<ReplicationMessage.Column> transform(List<PgProto.DatumMessage> messageList, List<PgProto.TypeInfo> typeInfoList) {
        return IntStream.range(0, messageList.size()).mapToObj(index -> {
            final PgProto.DatumMessage datum = (PgProto.DatumMessage)messageList.get(index);
            Optional<Object> typeInfo = Optional.ofNullable(this.hasTypeMetadata() && typeInfoList != null ? (PgProto.TypeInfo)typeInfoList.get(index) : null);
            final String columnName = Strings.unquoteIdentifierPart((String)datum.getColumnName());
            final PostgresType type = this.typeRegistry.get((int)datum.getColumnType());
            if (datum.hasDatumMissing()) {
                return new UnchangedToastedReplicationMessageColumn(columnName, type, typeInfo.map(PgProto.TypeInfo::getModifier).orElse(null), typeInfo.map(PgProto.TypeInfo::getValueOptional).orElse(Boolean.FALSE), this.hasTypeMetadata());
            }
            final String fullType = typeInfo.map(PgProto.TypeInfo::getModifier).orElse(null);
            return new AbstractReplicationMessageColumn(columnName, type, fullType, typeInfo.map(PgProto.TypeInfo::getValueOptional).orElse(Boolean.FALSE), this.hasTypeMetadata()){

                @Override
                public Object getValue(PostgresStreamingChangeEventSource.PgConnectionSupplier connection, boolean includeUnknownDatatypes) {
                    return PgProtoReplicationMessage.this.getValue(columnName, type, fullType, datum, connection, includeUnknownDatatypes);
                }

                public String toString() {
                    return datum.toString();
                }
            };
        }).collect(Collectors.toList());
    }

    @Override
    public boolean isLastEventForLsn() {
        return true;
    }

    public Object getValue(String columnName, PostgresType type, String fullType, PgProto.DatumMessage datumMessage, PostgresStreamingChangeEventSource.PgConnectionSupplier connection, boolean includeUnknownDatatypes) {
        PgProtoColumnValue columnValue = new PgProtoColumnValue(datumMessage);
        return ReplicationMessageColumnValueResolver.resolveValue(columnName, type, fullType, columnValue, connection, includeUnknownDatatypes, this.typeRegistry);
    }
}

