/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.postgresql;

import io.debezium.connector.postgresql.PostgresType;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.postgresql.core.TypeInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypeRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(TypeRegistry.class);
    public static final String TYPE_NAME_GEOGRAPHY = "geography";
    public static final String TYPE_NAME_GEOMETRY = "geometry";
    public static final String TYPE_NAME_CITEXT = "citext";
    public static final String TYPE_NAME_HSTORE = "hstore";
    public static final String TYPE_NAME_LTREE = "ltree";
    public static final String TYPE_NAME_HSTORE_ARRAY = "_hstore";
    public static final String TYPE_NAME_GEOGRAPHY_ARRAY = "_geography";
    public static final String TYPE_NAME_GEOMETRY_ARRAY = "_geometry";
    public static final String TYPE_NAME_CITEXT_ARRAY = "_citext";
    public static final String TYPE_NAME_LTREE_ARRAY = "_ltree";
    public static final int NO_TYPE_MODIFIER = -1;
    public static final int UNKNOWN_LENGTH = -1;
    private static final Map<String, String> LONG_TYPE_NAMES = Collections.unmodifiableMap(TypeRegistry.getLongTypeNames());
    private final Map<String, PostgresType> nameToType;
    private final Map<Integer, PostgresType> oidToType;
    private final int geometryOid;
    private final int geographyOid;
    private final int citextOid;
    private final int hstoreOid;
    private final int ltreeOid;
    private final int hstoreArrayOid;
    private final int geometryArrayOid;
    private final int geographyArrayOid;
    private final int citextArrayOid;
    private final int ltreeArrayOid;

    private static Map<String, String> getLongTypeNames() {
        HashMap<String, String> longTypeNames = new HashMap<String, String>();
        longTypeNames.put("bigint", "int8");
        longTypeNames.put("bit varying", "varbit");
        longTypeNames.put("boolean", "bool");
        longTypeNames.put("character", "bpchar");
        longTypeNames.put("character varying", "varchar");
        longTypeNames.put("double precision", "float8");
        longTypeNames.put("integer", "int4");
        longTypeNames.put("real", "float4");
        longTypeNames.put("smallint", "int2");
        longTypeNames.put("timestamp without time zone", "timestamp");
        longTypeNames.put("timestamp with time zone", "timestamptz");
        longTypeNames.put("time without time zone", "time");
        longTypeNames.put("time with time zone", "timetz");
        return longTypeNames;
    }

    public static Builder create(TypeInfo typeInfo) {
        return new Builder();
    }

    private TypeRegistry(Builder builder) {
        this.nameToType = Collections.unmodifiableMap(builder.nameToType);
        this.oidToType = Collections.unmodifiableMap(builder.oidToType);
        this.geometryOid = builder.geometryOid;
        this.geographyOid = builder.geographyOid;
        this.citextOid = builder.citextOid;
        this.hstoreOid = builder.hstoreOid;
        this.ltreeOid = builder.ltreeOid;
        this.hstoreArrayOid = builder.hstoreArrayOid;
        this.geometryArrayOid = builder.geometryArrayOid;
        this.geographyArrayOid = builder.geographyArrayOid;
        this.citextArrayOid = builder.citextArrayOid;
        this.ltreeArrayOid = builder.ltreeArrayOid;
    }

    public PostgresType get(int oid) {
        PostgresType r = this.oidToType.get(oid);
        if (r == null) {
            LOGGER.warn("Unknown OID {} requested", (Object)oid);
            r = PostgresType.UNKNOWN;
        }
        return r;
    }

    public PostgresType get(String name) {
        PostgresType r;
        switch (name) {
            case "serial": {
                name = "int4";
                break;
            }
            case "smallserial": {
                name = "int2";
                break;
            }
            case "bigserial": {
                name = "int8";
            }
        }
        String[] parts = name.split("\\.");
        if (parts.length > 1) {
            name = parts[1];
        }
        if (name.charAt(0) == '\"') {
            name = name.substring(1, name.length() - 1);
        }
        if ((r = this.nameToType.get(name)) == null) {
            LOGGER.warn("Unknown type named {} requested", (Object)name);
            r = PostgresType.UNKNOWN;
        }
        return r;
    }

    public int geometryOid() {
        return this.geometryOid;
    }

    public int geographyOid() {
        return this.geographyOid;
    }

    public int citextOid() {
        return this.citextOid;
    }

    public int hstoreOid() {
        return this.hstoreOid;
    }

    public int ltreeOid() {
        return this.ltreeOid;
    }

    public int hstoreArrayOid() {
        return this.hstoreArrayOid;
    }

    public int geometryArrayOid() {
        return this.geometryArrayOid;
    }

    public int geographyArrayOid() {
        return this.geographyArrayOid;
    }

    public int citextArrayOid() {
        return this.citextArrayOid;
    }

    public int ltreeArrayOid() {
        return this.ltreeArrayOid;
    }

    public static String normalizeTypeName(String typeName) {
        return LONG_TYPE_NAMES.getOrDefault(typeName, typeName);
    }

    public static final class Builder {
        private final Map<String, PostgresType> nameToType = new HashMap<String, PostgresType>();
        private final Map<Integer, PostgresType> oidToType = new HashMap<Integer, PostgresType>();
        private int geometryOid = Integer.MIN_VALUE;
        private int geographyOid = Integer.MIN_VALUE;
        private int citextOid = Integer.MIN_VALUE;
        private int hstoreOid = Integer.MIN_VALUE;
        private int ltreeOid = Integer.MIN_VALUE;
        private int hstoreArrayOid = Integer.MIN_VALUE;
        private int geometryArrayOid = Integer.MIN_VALUE;
        private int geographyArrayOid = Integer.MIN_VALUE;
        private int citextArrayOid = Integer.MIN_VALUE;
        private int ltreeArrayOid = Integer.MIN_VALUE;

        private Builder() {
        }

        public Builder addType(PostgresType type) {
            this.oidToType.put(type.getOid(), type);
            this.nameToType.put(type.getName(), type);
            if (TypeRegistry.TYPE_NAME_GEOMETRY.equals(type.getName())) {
                this.geometryOid = type.getOid();
            } else if (TypeRegistry.TYPE_NAME_GEOGRAPHY.equals(type.getName())) {
                this.geographyOid = type.getOid();
            } else if (TypeRegistry.TYPE_NAME_CITEXT.equals(type.getName())) {
                this.citextOid = type.getOid();
            } else if (TypeRegistry.TYPE_NAME_HSTORE.equals(type.getName())) {
                this.hstoreOid = type.getOid();
            } else if (TypeRegistry.TYPE_NAME_LTREE.equals(type.getName())) {
                this.ltreeOid = type.getOid();
            } else if (TypeRegistry.TYPE_NAME_HSTORE_ARRAY.equals(type.getName())) {
                this.hstoreArrayOid = type.getOid();
            } else if (TypeRegistry.TYPE_NAME_GEOMETRY_ARRAY.equals(type.getName())) {
                this.geometryArrayOid = type.getOid();
            } else if (TypeRegistry.TYPE_NAME_GEOGRAPHY_ARRAY.equals(type.getName())) {
                this.geographyArrayOid = type.getOid();
            } else if (TypeRegistry.TYPE_NAME_CITEXT_ARRAY.equals(type.getName())) {
                this.citextArrayOid = type.getOid();
            } else if (TypeRegistry.TYPE_NAME_LTREE_ARRAY.equals(type.getName())) {
                this.ltreeArrayOid = type.getOid();
            }
            return this;
        }

        public PostgresType get(int oid) {
            return this.oidToType.get(oid);
        }

        public TypeRegistry build() {
            return new TypeRegistry(this);
        }
    }
}

