/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.postgresql.connection;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

public class ServerInfo {
    private String server;
    private String username;
    private String database;
    private Map<String, String> permissionsByRoleName = new HashMap<String, String>();

    protected ServerInfo() {
    }

    protected ServerInfo withServer(String server) {
        this.server = server;
        return this;
    }

    protected ServerInfo withUsername(String username) {
        this.username = username;
        return this;
    }

    protected ServerInfo withDatabase(String database) {
        this.database = database;
        return this;
    }

    protected ServerInfo addRole(String roleName, String permissions) {
        this.permissionsByRoleName.put(roleName, permissions);
        return this;
    }

    public String server() {
        return this.server;
    }

    public String username() {
        return this.username;
    }

    public String database() {
        return this.database;
    }

    public Map<String, String> permissionsByRoleName() {
        return this.permissionsByRoleName;
    }

    public String toString() {
        String lineSeparator = System.lineSeparator();
        String roles = this.permissionsByRoleName.entrySet().stream().map(entry -> "\trole '" + (String)entry.getKey() + "' [" + (String)entry.getValue() + "]").collect(Collectors.joining(lineSeparator));
        return "user '" + this.username + "' connected to database '" + this.database + "' on " + this.server + " with roles:" + lineSeparator + roles;
    }

    protected static class ReplicationSlot {
        protected static final ReplicationSlot INVALID = new ReplicationSlot(false, null);
        private boolean active;
        private Long latestFlushedLSN;

        protected ReplicationSlot(boolean active, Long latestFlushedLSN) {
            this.active = active;
            this.latestFlushedLSN = latestFlushedLSN;
        }

        protected boolean active() {
            return this.active;
        }

        protected Long latestFlushedLSN() {
            return this.latestFlushedLSN;
        }

        protected boolean hasValidFlushedLSN() {
            return this.latestFlushedLSN != null;
        }
    }

    public static enum ReplicaIdentity {
        NOTHING("UPDATE and DELETE events will not contain any old values"),
        FULL("UPDATE AND DELETE events will contain the previous values of all the columns"),
        DEFAULT("UPDATE and DELETE events will contain previous values only for PK columns"),
        INDEX("UPDATE and DELETE events will contain previous values only for columns present in the REPLICA IDENTITY index"),
        UNKNOWN("Unknown REPLICA IDENTITY");

        private String description;

        public String description() {
            return this.description;
        }

        private ReplicaIdentity(String description) {
            this.description = description;
        }

        protected static ReplicaIdentity parseFromDB(String s) {
            switch (s) {
                case "n": {
                    return NOTHING;
                }
                case "d": {
                    return DEFAULT;
                }
                case "i": {
                    return INDEX;
                }
                case "f": {
                    return FULL;
                }
            }
            return UNKNOWN;
        }
    }
}

