/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.postgresql.connection.wal2json;

import io.debezium.connector.postgresql.TypeRegistry;
import io.debezium.connector.postgresql.connection.MessageDecoder;
import io.debezium.connector.postgresql.connection.ReplicationStream;
import io.debezium.connector.postgresql.connection.wal2json.DateTimeFormat;
import io.debezium.connector.postgresql.connection.wal2json.Wal2JsonReplicationMessage;
import io.debezium.document.Array;
import io.debezium.document.Document;
import io.debezium.document.DocumentReader;
import io.debezium.document.Value;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.kafka.connect.errors.ConnectException;
import org.postgresql.replication.fluent.logical.ChainedLogicalStreamBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Wal2JsonMessageDecoder
implements MessageDecoder {
    private static final Logger LOGGER = LoggerFactory.getLogger(Wal2JsonMessageDecoder.class);
    private final DateTimeFormat dateTime = DateTimeFormat.get();
    private boolean containsMetadata = false;

    @Override
    public void processMessage(ByteBuffer buffer, ReplicationStream.ReplicationMessageProcessor processor, TypeRegistry typeRegistry) throws SQLException, InterruptedException {
        try {
            if (!buffer.hasArray()) {
                throw new IllegalStateException("Invalid buffer received from PG server during streaming replication");
            }
            byte[] source = buffer.array();
            byte[] content = Arrays.copyOfRange(source, buffer.arrayOffset(), source.length);
            Document message = DocumentReader.floatNumbersAsTextReader().read(content);
            LOGGER.debug("Message arrived for decoding {}", (Object)message);
            int txId = message.getInteger((CharSequence)"xid");
            String timestamp = message.getString((CharSequence)"timestamp");
            long commitTime = this.dateTime.systemTimestamp(timestamp);
            Array changes = message.getArray((CharSequence)"change");
            Iterator it = changes.iterator();
            while (it.hasNext()) {
                Value value = ((Array.Entry)it.next()).getValue();
                processor.process(new Wal2JsonReplicationMessage(txId, commitTime, value.asDocument(), this.containsMetadata, !it.hasNext(), typeRegistry));
            }
        }
        catch (IOException e) {
            throw new ConnectException((Throwable)e);
        }
    }

    @Override
    public ChainedLogicalStreamBuilder optionsWithMetadata(ChainedLogicalStreamBuilder builder) {
        return this.optionsWithoutMetadata(builder).withSlotOption("include-not-null", "true");
    }

    @Override
    public ChainedLogicalStreamBuilder optionsWithoutMetadata(ChainedLogicalStreamBuilder builder) {
        return builder.withSlotOption("pretty-print", 1).withSlotOption("write-in-chunks", 0).withSlotOption("include-xids", 1).withSlotOption("include-timestamp", 1);
    }

    @Override
    public void setContainsMetadata(boolean containsMetadata) {
        this.containsMetadata = containsMetadata;
    }
}

