/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.postgresql;

import io.debezium.connector.postgresql.connection.ReplicationMessage;
import io.debezium.relational.Column;
import io.debezium.relational.ColumnEditor;
import io.debezium.relational.TableId;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.postgresql.core.Oid;
import org.postgresql.jdbc.PgConnection;
import org.postgresql.util.PSQLException;

public final class PgOid
extends Oid {
    public static final int JSONB_JDBC_OID = 1111;
    public static final int JSONB_OID = 3802;
    public static final int TSTZRANGE_OID = 3910;
    private static final Map<String, String> LONG_TYPE_NAMES = Collections.unmodifiableMap(PgOid.getLongTypeNames());
    public static final int POSTGIS_GEOMETRY = -101;
    public static final int POSTGIS_GEOGRAPHY = -102;
    public static final int POSTGIS_GEOMETRY_ARRAY = -201;
    public static final int POSTGIS_GEOGRAPHY_ARRAY = -202;

    private static Map<String, String> getLongTypeNames() {
        HashMap<String, String> longTypeNames = new HashMap<String, String>();
        longTypeNames.put("bigint", "int8");
        longTypeNames.put("bit varying", "varbit");
        longTypeNames.put("boolean", "bool");
        longTypeNames.put("character", "bpchar");
        longTypeNames.put("character varying", "varchar");
        longTypeNames.put("double precision", "float8");
        longTypeNames.put("integer", "int4");
        longTypeNames.put("real", "float4");
        longTypeNames.put("smallint", "int2");
        longTypeNames.put("timestamp without time zone", "timestamp");
        longTypeNames.put("timestamp with time zone", "timestamptz");
        longTypeNames.put("time without time zone", "time");
        longTypeNames.put("time with time zone", "timetz");
        return longTypeNames;
    }

    private PgOid() {
    }

    protected static int jdbcColumnToOid(Column column) {
        String typeName = TableId.parse((String)column.typeName()).table().toUpperCase();
        if (column.jdbcType() == 2003) {
            return column.typeName() != null ? PgOid.typeNameToOid(column.typeName().substring(1) + "_array") : column.componentType();
        }
        return PgOid.typeNameToOid(typeName);
    }

    public static int typeNameToOid(String typeName) {
        switch (typeName.toUpperCase()) {
            case "TSTZRANGE": {
                return 3910;
            }
            case "SMALLSERIAL": {
                return 21;
            }
            case "SERIAL": {
                return 23;
            }
            case "BIGSERIAL": {
                return 20;
            }
            case "JSONB": {
                return 3802;
            }
            case "GEOMETRY": {
                return -101;
            }
            case "GEOGRAPHY": {
                return -102;
            }
        }
        try {
            return Oid.valueOf((String)typeName);
        }
        catch (PSQLException e) {
            return 0;
        }
    }

    public static String normalizeTypeName(String typeName) {
        return LONG_TYPE_NAMES.getOrDefault(typeName, typeName);
    }

    public static void reconcileJdbcOidTypeConstraints(ReplicationMessage.ColumnTypeMetadata columnTypeMetadata, ColumnEditor columnEditor) {
        switch (columnTypeMetadata.getName()) {
            case "money": {
                columnEditor.scale(0);
                break;
            }
            case "timestamp": {
                columnEditor.length(29);
                columnEditor.scale(6);
                break;
            }
            case "time": {
                columnEditor.length(15);
                columnEditor.scale(6);
            }
        }
    }

    public static String oidToTypeName(PgConnection conn, int oid) throws SQLException {
        String typeName = conn.getTypeInfo().getPGType(oid);
        return TableId.parse((String)typeName).table().toUpperCase();
    }
}

