/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.postgresql;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.Configuration;
import io.debezium.config.Field;
import io.debezium.connector.base.ChangeEventQueue;
import io.debezium.connector.common.BaseSourceTask;
import io.debezium.connector.common.CdcSourceTaskContext;
import io.debezium.connector.postgresql.Module;
import io.debezium.connector.postgresql.PostgresChangeEventSourceFactory;
import io.debezium.connector.postgresql.PostgresChangeRecordEmitter;
import io.debezium.connector.postgresql.PostgresConnector;
import io.debezium.connector.postgresql.PostgresConnectorConfig;
import io.debezium.connector.postgresql.PostgresEventMetadataProvider;
import io.debezium.connector.postgresql.PostgresOffsetContext;
import io.debezium.connector.postgresql.PostgresSchema;
import io.debezium.connector.postgresql.PostgresTaskContext;
import io.debezium.connector.postgresql.PostgresTopicSelector;
import io.debezium.connector.postgresql.SourceInfo;
import io.debezium.connector.postgresql.TypeRegistry;
import io.debezium.connector.postgresql.connection.PostgresConnection;
import io.debezium.connector.postgresql.connection.ReplicationConnection;
import io.debezium.connector.postgresql.spi.SlotCreationResult;
import io.debezium.connector.postgresql.spi.SlotState;
import io.debezium.connector.postgresql.spi.Snapshotter;
import io.debezium.pipeline.ChangeEventSourceCoordinator;
import io.debezium.pipeline.DataChangeEvent;
import io.debezium.pipeline.ErrorHandler;
import io.debezium.pipeline.EventDispatcher;
import io.debezium.pipeline.source.spi.ChangeEventSourceFactory;
import io.debezium.pipeline.source.spi.EventMetadataProvider;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.relational.RelationalDatabaseSchema;
import io.debezium.relational.TableId;
import io.debezium.schema.DataCollectionFilters;
import io.debezium.schema.DatabaseSchema;
import io.debezium.schema.TopicSelector;
import io.debezium.util.Clock;
import io.debezium.util.LoggingContext;
import java.nio.charset.Charset;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.source.SourceRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostgresConnectorTask
extends BaseSourceTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(PostgresConnectorTask.class);
    private static final String CONTEXT_NAME = "postgres-connector-task";
    private final AtomicReference<State> state = new AtomicReference<State>(State.STOPPED);
    private volatile PostgresTaskContext taskContext;
    private volatile ChangeEventQueue<DataChangeEvent> queue;
    private volatile PostgresConnection jdbcConnection;
    private volatile ChangeEventSourceCoordinator coordinator;
    private volatile ErrorHandler errorHandler;
    private volatile PostgresSchema schema;
    private volatile Map<String, ?> lastOffset;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(Configuration config) {
        if (!this.state.compareAndSet(State.STOPPED, State.RUNNING)) {
            LOGGER.info("Connector has already been started");
            return;
        }
        PostgresConnectorConfig connectorConfig = new PostgresConnectorConfig(config);
        TopicSelector<TableId> topicSelector = PostgresTopicSelector.create(connectorConfig);
        Snapshotter snapshotter = connectorConfig.getSnapshotter();
        if (snapshotter == null) {
            throw new ConnectException("Unable to load snapshotter, if using custom snapshot mode, double check your settings");
        }
        this.jdbcConnection = new PostgresConnection(connectorConfig.jdbcConfig());
        TypeRegistry typeRegistry = this.jdbcConnection.getTypeRegistry();
        Charset databaseCharset = this.jdbcConnection.getDatabaseCharset();
        this.schema = new PostgresSchema(connectorConfig, typeRegistry, databaseCharset, topicSelector);
        this.taskContext = new PostgresTaskContext(connectorConfig, this.schema, topicSelector);
        PostgresOffsetContext previousOffset = (PostgresOffsetContext)this.getPreviousOffset(new PostgresOffsetContext.Loader(connectorConfig));
        Clock clock = Clock.system();
        SourceInfo sourceInfo = new SourceInfo(connectorConfig);
        LoggingContext.PreviousContext previousContext = this.taskContext.configureLoggingContext(CONTEXT_NAME);
        try {
            SlotState slotInfo = null;
            try (PostgresConnection connection = this.taskContext.createConnection();){
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info(connection.serverInfo().toString());
                }
                slotInfo = connection.getReplicationSlotState(connectorConfig.slotName(), connectorConfig.plugin().getPostgresPluginName());
            }
            catch (SQLException e) {
                LOGGER.warn("unable to load info of replication slot, Debezium will try to create the slot");
            }
            if (previousOffset == null) {
                LOGGER.info("No previous offset found");
                snapshotter.init(connectorConfig, null, slotInfo);
            } else {
                LOGGER.info("Found previous offset {}", (Object)sourceInfo);
                snapshotter.init(connectorConfig, previousOffset.asOffsetState(), slotInfo);
            }
            ReplicationConnection replicationConnection = null;
            SlotCreationResult slotCreatedInfo = null;
            if (snapshotter.shouldStream()) {
                boolean shouldExport = snapshotter.exportSnapshot();
                try {
                    replicationConnection = this.taskContext.createReplicationConnection(shouldExport);
                    slotCreatedInfo = slotInfo == null ? (SlotCreationResult)replicationConnection.createReplicationSlot().orElse(null) : null;
                }
                catch (SQLException ex) {
                    throw new ConnectException((Throwable)ex);
                }
            }
            this.queue = new ChangeEventQueue.Builder().pollInterval(connectorConfig.getPollInterval()).maxBatchSize(connectorConfig.getMaxBatchSize()).maxQueueSize(connectorConfig.getMaxQueueSize()).loggingContextSupplier(() -> this.taskContext.configureLoggingContext(CONTEXT_NAME)).build();
            this.errorHandler = new ErrorHandler(PostgresConnector.class, connectorConfig.getLogicalName(), this.queue, this::cleanupResources);
            EventDispatcher dispatcher = new EventDispatcher((CommonConnectorConfig)connectorConfig, topicSelector, (DatabaseSchema)this.schema, this.queue, (DataCollectionFilters.DataCollectionFilter)connectorConfig.getTableFilters().dataCollectionFilter(), DataChangeEvent::new, PostgresChangeRecordEmitter::updateSchema);
            this.coordinator = new ChangeEventSourceCoordinator((OffsetContext)previousOffset, this.errorHandler, PostgresConnector.class, connectorConfig.getLogicalName(), (ChangeEventSourceFactory)new PostgresChangeEventSourceFactory(connectorConfig, snapshotter, this.jdbcConnection, this.errorHandler, (EventDispatcher<TableId>)dispatcher, clock, this.schema, this.taskContext, replicationConnection, slotCreatedInfo), dispatcher, (RelationalDatabaseSchema)this.schema);
            this.coordinator.start((CdcSourceTaskContext)this.taskContext, this.queue, (EventMetadataProvider)new PostgresEventMetadataProvider());
        }
        finally {
            previousContext.restore();
        }
    }

    public void commit() throws InterruptedException {
        if (this.coordinator != null) {
            this.coordinator.commitOffset(this.lastOffset);
        }
    }

    public List<SourceRecord> poll() throws InterruptedException {
        List records = this.queue.poll();
        List<SourceRecord> sourceRecords = records.stream().map(DataChangeEvent::getRecord).collect(Collectors.toList());
        if (!sourceRecords.isEmpty()) {
            this.lastOffset = sourceRecords.get(sourceRecords.size() - 1).sourceOffset();
        }
        return sourceRecords;
    }

    public void stop() {
        this.cleanupResources();
    }

    private void cleanupResources() {
        if (!this.state.compareAndSet(State.RUNNING, State.STOPPED)) {
            LOGGER.info("Connector has already been stopped");
            return;
        }
        try {
            if (this.coordinator != null) {
                this.coordinator.stop();
            }
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            LOGGER.error("Interrupted while stopping coordinator", (Throwable)e);
            throw new ConnectException("Interrupted while stopping coordinator, failing the task");
        }
        try {
            if (this.errorHandler != null) {
                this.errorHandler.stop();
            }
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            LOGGER.error("Interrupted while stopping", (Throwable)e);
        }
        if (this.jdbcConnection != null) {
            this.jdbcConnection.close();
        }
        if (this.schema != null) {
            this.schema.close();
        }
    }

    public String version() {
        return Module.version();
    }

    protected Iterable<Field> getAllConfigurationFields() {
        return PostgresConnectorConfig.ALL_FIELDS;
    }

    public PostgresTaskContext getTaskContext() {
        return this.taskContext;
    }

    private static enum State {
        RUNNING,
        STOPPED;

    }
}

