/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.cassandra;

import io.debezium.connector.cassandra.exceptions.CassandraConnectorDataException;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CommitLogUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommitLogUtil.class);
    private static final Pattern FILENAME_REGEX_PATTERN = Pattern.compile("CommitLog-\\d+-(\\d+).log");

    private CommitLogUtil() {
    }

    public static boolean moveCommitLog(File file, Path toDir) {
        try {
            Matcher filenameMatcher = FILENAME_REGEX_PATTERN.matcher(file.getName());
            if (!filenameMatcher.matches()) {
                LOGGER.warn("Cannot move file {} because it does not appear to be a CommitLog.", (Object)file.getName());
                return false;
            }
            Files.move(file.toPath(), toDir.resolve(file.getName()), StandardCopyOption.REPLACE_EXISTING);
            LOGGER.debug("Moved CommitLog file {} from {} to {}.", new Object[]{file.getName(), file.getParent(), toDir});
            return true;
        }
        catch (Exception e) {
            LOGGER.warn("Failed to move CommitLog file {} from {} to {}. Error:", new Object[]{file.getName(), file.getParent(), toDir, e});
            return false;
        }
    }

    public static boolean deleteCommitLog(File file) {
        try {
            Matcher filenameMatcher = FILENAME_REGEX_PATTERN.matcher(file.getName());
            if (!filenameMatcher.matches()) {
                LOGGER.warn("Cannot delete file {} because it does not appear to be a CommitLog", (Object)file.getName());
                return false;
            }
            Files.delete(file.toPath());
            LOGGER.debug("Deleted CommitLog file {} from {}.", (Object)file.getName(), (Object)file.getParent());
            return true;
        }
        catch (Exception e) {
            LOGGER.warn("Failed to delete CommitLog file {} from {}. Error: ", new Object[]{file.getName(), file.getParent(), e});
            return false;
        }
    }

    public static File[] getCommitLogs(File directory) {
        if (!directory.isDirectory()) {
            throw new IllegalArgumentException("Given directory does not exist: " + directory);
        }
        return directory.listFiles(f -> f.isFile() && FILENAME_REGEX_PATTERN.matcher(f.getName()).matches());
    }

    public static int compareCommitLogs(File file1, File file2) {
        if (file1.equals(file2)) {
            return 0;
        }
        long ts1 = CommitLogUtil.extractTimestamp(file1.getName());
        long ts2 = CommitLogUtil.extractTimestamp(file2.getName());
        return Long.compare(ts1, ts2);
    }

    public static int compareCommitLogs(String filename1, String filename2) {
        if (filename1.equals(filename2)) {
            return 0;
        }
        long ts1 = CommitLogUtil.extractTimestamp(filename1);
        long ts2 = CommitLogUtil.extractTimestamp(filename2);
        return Long.compare(ts1, ts2);
    }

    private static long extractTimestamp(String commitLogFileName) {
        Matcher filenameMatcher = FILENAME_REGEX_PATTERN.matcher(commitLogFileName);
        if (!filenameMatcher.matches()) {
            throw new CassandraConnectorDataException("Cannot extract timestamp because " + commitLogFileName + " does not appear to be a CommitLog");
        }
        return Long.parseLong(filenameMatcher.group(1));
    }
}

