/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.cassandra;

import io.debezium.connector.SourceInfoStructMaker;
import io.debezium.connector.base.ChangeEventQueue;
import io.debezium.connector.cassandra.CassandraClient;
import io.debezium.connector.cassandra.CassandraConnectorConfig;
import io.debezium.connector.cassandra.Event;
import io.debezium.connector.cassandra.FileOffsetWriter;
import io.debezium.connector.cassandra.OffsetWriter;
import io.debezium.connector.cassandra.SchemaHolder;
import io.debezium.connector.cassandra.SourceInfo;
import io.debezium.connector.cassandra.exceptions.CassandraConnectorTaskException;
import io.debezium.connector.common.CdcSourceTaskContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.config.Schema;
import org.apache.kafka.clients.producer.KafkaProducer;

public class CassandraConnectorContext
extends CdcSourceTaskContext {
    private final CassandraConnectorConfig config;
    private final CassandraClient cassandraClient;
    private final List<ChangeEventQueue<Event>> queues;
    private final KafkaProducer kafkaProducer;
    private final SchemaHolder schemaHolder;
    private final OffsetWriter offsetWriter;
    private final Set<String> erroneousCommitLogs;

    public CassandraConnectorContext(CassandraConnectorConfig config) throws Exception {
        super(config.getContextName(), config.getLogicalName(), Collections::emptySet);
        this.config = config;
        try {
            this.erroneousCommitLogs = ConcurrentHashMap.newKeySet();
            this.loadDdlFromDisk(this.config.cassandraConfig());
            this.cassandraClient = new CassandraClient(this.config);
            this.queues = new ArrayList<ChangeEventQueue<Event>>();
            int numOfChangeEventQueues = this.config.numOfChangeEventQueues();
            for (int i = 0; i < numOfChangeEventQueues; ++i) {
                ChangeEventQueue queue = new ChangeEventQueue.Builder().pollInterval(this.config.pollInterval()).maxBatchSize(this.config.maxBatchSize()).maxQueueSize(this.config.maxQueueSize()).loggingContextSupplier(() -> this.configureLoggingContext(this.config.getContextName())).build();
                this.queues.add((ChangeEventQueue<Event>)queue);
            }
            this.kafkaProducer = new KafkaProducer(this.config.getKafkaConfigs());
            this.schemaHolder = new SchemaHolder(this.cassandraClient, this.config.kafkaTopicPrefix(), (SourceInfoStructMaker<SourceInfo>)this.config.getSourceInfoStructMaker());
            this.offsetWriter = new FileOffsetWriter(this.config.offsetBackingStoreDir());
        }
        catch (Exception e) {
            this.cleanUp();
            throw new CassandraConnectorTaskException("Failed to initialize Cassandra Connector Context.", e);
        }
    }

    public void loadDdlFromDisk(String yamlConfig) {
        System.setProperty("cassandra.config", "file:///" + yamlConfig);
        if (!DatabaseDescriptor.isDaemonInitialized() && !DatabaseDescriptor.isToolInitialized()) {
            DatabaseDescriptor.toolInitialization();
            Schema.instance.loadFromDisk(false);
        }
    }

    public void cleanUp() {
        if (this.schemaHolder != null) {
            this.schemaHolder.close();
        }
        if (this.cassandraClient != null) {
            this.cassandraClient.close();
        }
        if (this.offsetWriter != null) {
            this.offsetWriter.close();
        }
    }

    public CassandraConnectorConfig getCassandraConnectorConfig() {
        return this.config;
    }

    public CassandraClient getCassandraClient() {
        return this.cassandraClient;
    }

    public List<ChangeEventQueue<Event>> getQueues() {
        return this.queues;
    }

    public KafkaProducer getKafkaProducer() {
        return this.kafkaProducer;
    }

    public OffsetWriter getOffsetWriter() {
        return this.offsetWriter;
    }

    public SchemaHolder getSchemaHolder() {
        return this.schemaHolder;
    }

    public Set<String> getErroneousCommitLogs() {
        return this.erroneousCommitLogs;
    }
}

