/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.cassandra.transforms.type.deserializer;

import io.debezium.connector.cassandra.transforms.CassandraTypeKafkaSchemaBuilders;
import io.debezium.connector.cassandra.transforms.UuidUtil;
import io.debezium.connector.cassandra.transforms.type.deserializer.TypeDeserializer;
import java.nio.ByteBuffer;
import java.util.UUID;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Values;

public class UUIDTypeDeserializer
extends TypeDeserializer {
    @Override
    public Object deserialize(AbstractType<?> abstractType, ByteBuffer bb) {
        Object value = super.deserialize(abstractType, bb);
        byte[] bytes = UuidUtil.asBytes((UUID)value);
        return Values.convertToString((Schema)this.getSchemaBuilder(abstractType).build(), (Object)bytes);
    }

    @Override
    public SchemaBuilder getSchemaBuilder(AbstractType<?> abstractType) {
        return CassandraTypeKafkaSchemaBuilders.UUID_TYPE;
    }
}

