/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.cassandra.transforms;

import com.datastax.driver.core.DataType;
import io.debezium.connector.cassandra.transforms.type.converter.BasicTypeConverter;
import io.debezium.connector.cassandra.transforms.type.converter.ListTypeConverter;
import io.debezium.connector.cassandra.transforms.type.converter.MapTypeConverter;
import io.debezium.connector.cassandra.transforms.type.converter.SetTypeConverter;
import io.debezium.connector.cassandra.transforms.type.converter.TupleTypeConverter;
import io.debezium.connector.cassandra.transforms.type.converter.TypeConverter;
import io.debezium.connector.cassandra.transforms.type.converter.UserTypeConverter;
import java.util.HashMap;
import java.util.Map;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.AsciiType;
import org.apache.cassandra.db.marshal.BooleanType;
import org.apache.cassandra.db.marshal.ByteType;
import org.apache.cassandra.db.marshal.BytesType;
import org.apache.cassandra.db.marshal.CounterColumnType;
import org.apache.cassandra.db.marshal.DecimalType;
import org.apache.cassandra.db.marshal.DoubleType;
import org.apache.cassandra.db.marshal.DurationType;
import org.apache.cassandra.db.marshal.FloatType;
import org.apache.cassandra.db.marshal.InetAddressType;
import org.apache.cassandra.db.marshal.Int32Type;
import org.apache.cassandra.db.marshal.LongType;
import org.apache.cassandra.db.marshal.ShortType;
import org.apache.cassandra.db.marshal.SimpleDateType;
import org.apache.cassandra.db.marshal.TimeType;
import org.apache.cassandra.db.marshal.TimeUUIDType;
import org.apache.cassandra.db.marshal.TimestampType;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.db.marshal.UUIDType;

public final class CassandraTypeConverter {
    private static final Map<DataType.Name, TypeConverter<?>> typeMap = new HashMap();

    private CassandraTypeConverter() {
    }

    public static AbstractType<?> convert(DataType type) {
        TypeConverter<?> typeConverter = typeMap.get(type.getName());
        return typeConverter.convert(type);
    }

    static {
        typeMap.put(DataType.Name.ASCII, new BasicTypeConverter<AsciiType>(AsciiType.instance));
        typeMap.put(DataType.Name.BIGINT, new BasicTypeConverter<LongType>(LongType.instance));
        typeMap.put(DataType.Name.BLOB, new BasicTypeConverter<BytesType>(BytesType.instance));
        typeMap.put(DataType.Name.BOOLEAN, new BasicTypeConverter<BooleanType>(BooleanType.instance));
        typeMap.put(DataType.Name.COUNTER, new BasicTypeConverter<CounterColumnType>(CounterColumnType.instance));
        typeMap.put(DataType.Name.DATE, new BasicTypeConverter<SimpleDateType>(SimpleDateType.instance));
        typeMap.put(DataType.Name.DECIMAL, new BasicTypeConverter<DecimalType>(DecimalType.instance));
        typeMap.put(DataType.Name.DOUBLE, new BasicTypeConverter<DoubleType>(DoubleType.instance));
        typeMap.put(DataType.Name.DURATION, new BasicTypeConverter<DurationType>(DurationType.instance));
        typeMap.put(DataType.Name.FLOAT, new BasicTypeConverter<FloatType>(FloatType.instance));
        typeMap.put(DataType.Name.INET, new BasicTypeConverter<InetAddressType>(InetAddressType.instance));
        typeMap.put(DataType.Name.INT, new BasicTypeConverter<Int32Type>(Int32Type.instance));
        typeMap.put(DataType.Name.LIST, new ListTypeConverter());
        typeMap.put(DataType.Name.MAP, new MapTypeConverter());
        typeMap.put(DataType.Name.SET, new SetTypeConverter());
        typeMap.put(DataType.Name.SMALLINT, new BasicTypeConverter<ShortType>(ShortType.instance));
        typeMap.put(DataType.Name.TEXT, new BasicTypeConverter<UTF8Type>(UTF8Type.instance));
        typeMap.put(DataType.Name.TIME, new BasicTypeConverter<TimeType>(TimeType.instance));
        typeMap.put(DataType.Name.TIMESTAMP, new BasicTypeConverter<TimestampType>(TimestampType.instance));
        typeMap.put(DataType.Name.TIMEUUID, new BasicTypeConverter<TimeUUIDType>(TimeUUIDType.instance));
        typeMap.put(DataType.Name.TINYINT, new BasicTypeConverter<ByteType>(ByteType.instance));
        typeMap.put(DataType.Name.TUPLE, new TupleTypeConverter());
        typeMap.put(DataType.Name.UDT, new UserTypeConverter());
        typeMap.put(DataType.Name.UUID, new BasicTypeConverter<UUIDType>(UUIDType.instance));
    }
}

