/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.cassandra;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import io.debezium.connector.cassandra.CassandraConnectorTask;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class SnapshotProcessorMetrics {
    private final AtomicInteger tableCount = new AtomicInteger();
    private final AtomicInteger remainingTableCount = new AtomicInteger();
    private final AtomicBoolean snapshotRunning = new AtomicBoolean();
    private final AtomicBoolean snapshotCompleted = new AtomicBoolean();
    private final AtomicBoolean snapshotAborted = new AtomicBoolean();
    private final AtomicLong startTime = new AtomicLong();
    private final AtomicLong stopTime = new AtomicLong();
    private final ConcurrentMap<String, Long> rowsScanned = new ConcurrentHashMap<String, Long>();

    public void registerMetrics() {
        CassandraConnectorTask.METRIC_REGISTRY_INSTANCE.register("total-table-count", (Metric)((Gauge)this::getTotalTableCount));
        CassandraConnectorTask.METRIC_REGISTRY_INSTANCE.register("remaining-table-count", (Metric)((Gauge)this::getRemainingTableCount));
        CassandraConnectorTask.METRIC_REGISTRY_INSTANCE.register("snapshot-completed", (Metric)((Gauge)this::snapshotCompleted));
        CassandraConnectorTask.METRIC_REGISTRY_INSTANCE.register("snapshot-running", (Metric)((Gauge)this::snapshotRunning));
        CassandraConnectorTask.METRIC_REGISTRY_INSTANCE.register("snapshot-aborted", (Metric)((Gauge)this::snapshotAborted));
        CassandraConnectorTask.METRIC_REGISTRY_INSTANCE.register("row-scanned", (Metric)((Gauge)this::rowsScanned));
        CassandraConnectorTask.METRIC_REGISTRY_INSTANCE.register("snapshot-duration-in-seconds", (Metric)((Gauge)this::snapshotDurationInSeconds));
    }

    public void unregisterMetrics() {
        CassandraConnectorTask.METRIC_REGISTRY_INSTANCE.remove("total-table-count");
        CassandraConnectorTask.METRIC_REGISTRY_INSTANCE.remove("remaining-table-count");
        CassandraConnectorTask.METRIC_REGISTRY_INSTANCE.remove("snapshot-completed");
        CassandraConnectorTask.METRIC_REGISTRY_INSTANCE.remove("snapshot-running");
        CassandraConnectorTask.METRIC_REGISTRY_INSTANCE.remove("snapshot-aborted");
        CassandraConnectorTask.METRIC_REGISTRY_INSTANCE.remove("row-scanned");
        CassandraConnectorTask.METRIC_REGISTRY_INSTANCE.remove("snapshot-duration-in-seconds");
    }

    public void setTableCount(int value) {
        this.tableCount.set(value);
        this.remainingTableCount.set(value);
    }

    public void completeTable() {
        this.remainingTableCount.decrementAndGet();
    }

    public void startSnapshot() {
        this.snapshotRunning.set(true);
        this.snapshotCompleted.set(false);
        this.snapshotAborted.set(false);
        this.startTime.set(System.currentTimeMillis());
        this.stopTime.set(0L);
    }

    public void stopSnapshot() {
        this.snapshotCompleted.set(true);
        this.snapshotAborted.set(false);
        this.snapshotRunning.set(false);
        this.stopTime.set(System.currentTimeMillis());
    }

    public void abortSnapshot() {
        this.snapshotCompleted.set(false);
        this.snapshotAborted.set(true);
        this.snapshotRunning.set(false);
        this.stopTime.set(System.currentTimeMillis());
    }

    public void setRowsScanned(String key, Long value) {
        this.rowsScanned.put(key, value);
    }

    private int getTotalTableCount() {
        return this.tableCount.get();
    }

    private int getRemainingTableCount() {
        return this.remainingTableCount.get();
    }

    private boolean snapshotCompleted() {
        return this.snapshotCompleted.get();
    }

    private boolean snapshotRunning() {
        return this.snapshotRunning.get();
    }

    private boolean snapshotAborted() {
        return this.snapshotAborted.get();
    }

    private Map<String, Long> rowsScanned() {
        return this.rowsScanned;
    }

    private long snapshotDurationInSeconds() {
        long startMillis = this.startTime.get();
        if (startMillis == 0L) {
            return 0L;
        }
        long stopMillis = this.stopTime.get();
        if (stopMillis <= 0L) {
            stopMillis = System.currentTimeMillis();
        }
        return (stopMillis - startMillis) / 1000L;
    }
}

