/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.cassandra;

import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractProcessor.class);
    private final String name;
    private final long delay;
    private boolean running;

    public AbstractProcessor(String name, long delayMillis) {
        this.name = name;
        this.delay = delayMillis;
        this.running = false;
    }

    public abstract void process() throws InterruptedException, IOException;

    public void initialize() throws Exception {
    }

    public void destroy() throws Exception {
    }

    public boolean isRunning() {
        return this.running;
    }

    public final void start() throws Exception {
        if (this.running) {
            LOGGER.warn("Ignoring start signal for {} because it is already started", (Object)this.name);
            return;
        }
        LOGGER.info("Started {}", (Object)this.name);
        this.running = true;
        while (this.isRunning()) {
            this.process();
            Thread.sleep(this.delay);
        }
        LOGGER.info("Stopped {}", (Object)this.name);
    }

    public final void stop() {
        if (this.isRunning()) {
            LOGGER.info("Stopping {}", (Object)this.name);
            this.running = false;
        }
    }

    public String getName() {
        return this.name;
    }
}

