/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.cassandra;

import com.datastax.driver.core.ColumnMetadata;
import com.datastax.driver.core.TableMetadata;
import io.debezium.connector.SourceInfoStructMaker;
import io.debezium.connector.cassandra.CassandraClient;
import io.debezium.connector.cassandra.KeyspaceTable;
import io.debezium.connector.cassandra.RowData;
import io.debezium.connector.cassandra.exceptions.CassandraConnectorSchemaException;
import io.debezium.connector.cassandra.transforms.CassandraTypeConverter;
import io.debezium.connector.cassandra.transforms.CassandraTypeDeserializer;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaHolder {
    private static final String NAMESPACE = "io.debezium.connector.cassandra";
    private static final Logger LOGGER = LoggerFactory.getLogger(SchemaHolder.class);
    private final Map<KeyspaceTable, KeyValueSchema> tableToKVSchemaMap = new ConcurrentHashMap<KeyspaceTable, KeyValueSchema>();
    private final CassandraClient cassandraClient;
    private final String kafkaTopicPrefix;
    private final SourceInfoStructMaker sourceInfoStructMaker;

    public SchemaHolder(CassandraClient cassandraClient, String kafkaTopicPrefix, SourceInfoStructMaker sourceInfoStructMaker) {
        this.cassandraClient = cassandraClient;
        this.kafkaTopicPrefix = kafkaTopicPrefix;
        this.sourceInfoStructMaker = sourceInfoStructMaker;
        this.refreshSchemas();
    }

    public void refreshSchemas() {
        LOGGER.debug("Refreshing schemas...");
        Map<KeyspaceTable, TableMetadata> latest = this.getLatestTableMetadatas();
        this.removeDeletedTableSchemas(latest);
        this.createOrUpdateNewTableSchemas(latest);
        LOGGER.debug("Schemas are refreshed");
    }

    public KeyValueSchema getOrUpdateKeyValueSchema(KeyspaceTable kt) {
        if (!this.tableToKVSchemaMap.containsKey(kt)) {
            this.refreshSchema(kt);
        }
        return this.tableToKVSchemaMap.getOrDefault(kt, null);
    }

    public Set<TableMetadata> getCdcEnabledTableMetadataSet() {
        return this.tableToKVSchemaMap.values().stream().map(KeyValueSchema::tableMetadata).filter(tm -> tm.getOptions().isCDC()).collect(Collectors.toSet());
    }

    public static Schema getFieldSchema(String fieldName, Schema schema) {
        if (schema.type().equals((Object)Schema.Type.STRUCT)) {
            return schema.field(fieldName).schema();
        }
        throw new CassandraConnectorSchemaException("Only STRUCT type is supported for this method, but encountered " + schema.type());
    }

    private void refreshSchema(KeyspaceTable keyspaceTable) {
        LOGGER.debug("Refreshing schema for {}", (Object)keyspaceTable);
        TableMetadata existing = this.tableToKVSchemaMap.containsKey(keyspaceTable) ? this.tableToKVSchemaMap.get(keyspaceTable).tableMetadata() : null;
        TableMetadata latest = this.cassandraClient.getCdcEnabledTableMetadata(keyspaceTable.keyspace, keyspaceTable.table);
        if (existing != latest) {
            if (existing == null) {
                this.tableToKVSchemaMap.put(keyspaceTable, new KeyValueSchema(this.kafkaTopicPrefix, latest, this.sourceInfoStructMaker));
                LOGGER.debug("Updated schema for {}", (Object)keyspaceTable);
            }
            if (latest == null) {
                this.tableToKVSchemaMap.remove(keyspaceTable);
                LOGGER.debug("Removed schema for {}", (Object)keyspaceTable);
            }
        }
    }

    private Map<KeyspaceTable, TableMetadata> getLatestTableMetadatas() {
        HashMap<KeyspaceTable, TableMetadata> latest = new HashMap<KeyspaceTable, TableMetadata>();
        for (TableMetadata tm : this.cassandraClient.getCdcEnabledTableMetadataList()) {
            latest.put(new KeyspaceTable(tm), tm);
        }
        return latest;
    }

    private void removeDeletedTableSchemas(Map<KeyspaceTable, TableMetadata> latestTableMetadataMap) {
        Set<KeyspaceTable> existingTables = this.tableToKVSchemaMap.keySet();
        Set<KeyspaceTable> latestTables = latestTableMetadataMap.keySet();
        existingTables.removeAll(latestTables);
        this.tableToKVSchemaMap.keySet().removeAll(existingTables);
    }

    private void createOrUpdateNewTableSchemas(Map<KeyspaceTable, TableMetadata> latestTableMetadataMap) {
        latestTableMetadataMap.forEach((table, metadata) -> {
            TableMetadata existingTableMetadata;
            TableMetadata tableMetadata = existingTableMetadata = this.tableToKVSchemaMap.containsKey(table) ? this.tableToKVSchemaMap.get(table).tableMetadata() : null;
            if (existingTableMetadata != metadata) {
                KeyValueSchema keyValueSchema = new KeyValueSchema(this.kafkaTopicPrefix, (TableMetadata)metadata, this.sourceInfoStructMaker);
                this.tableToKVSchemaMap.put((KeyspaceTable)table, keyValueSchema);
                LOGGER.debug("Updated schema for {}", table);
            }
        });
    }

    public static class KeyValueSchema {
        private final TableMetadata tableMetadata;
        private final Schema keySchema;
        private final Schema valueSchema;

        KeyValueSchema(String kafkaTopicPrefix, TableMetadata tableMetadata, SourceInfoStructMaker sourceInfoStructMaker) {
            this.tableMetadata = tableMetadata;
            this.keySchema = this.getKeySchema(kafkaTopicPrefix, tableMetadata);
            this.valueSchema = this.getValueSchema(kafkaTopicPrefix, tableMetadata, sourceInfoStructMaker);
        }

        public TableMetadata tableMetadata() {
            return this.tableMetadata;
        }

        public Schema keySchema() {
            return this.keySchema;
        }

        public Schema valueSchema() {
            return this.valueSchema;
        }

        private Schema getKeySchema(String kafkaTopicPrefix, TableMetadata tm) {
            if (tm == null) {
                return null;
            }
            SchemaBuilder schemaBuilder = SchemaBuilder.struct().name("io.debezium.connector.cassandra." + KeyValueSchema.getKeyName(kafkaTopicPrefix, tm));
            for (ColumnMetadata cm : tm.getPrimaryKey()) {
                AbstractType<?> convertedType = CassandraTypeConverter.convert(cm.getType());
                Schema colSchema = CassandraTypeDeserializer.getSchemaBuilder(convertedType).build();
                if (colSchema == null) continue;
                schemaBuilder.field(cm.getName(), colSchema);
            }
            return schemaBuilder.build();
        }

        private Schema getValueSchema(String kafkaTopicPrefix, TableMetadata tm, SourceInfoStructMaker sourceInfoStructMaker) {
            if (tm == null) {
                return null;
            }
            return SchemaBuilder.struct().name("io.debezium.connector.cassandra." + KeyValueSchema.getValueName(kafkaTopicPrefix, tm)).field("ts_ms", Schema.INT64_SCHEMA).field("op", Schema.STRING_SCHEMA).field("source", sourceInfoStructMaker.schema()).field("after", RowData.rowSchema(tm)).build();
        }

        private static String getKeyName(String kafkaTopicPrefix, TableMetadata tm) {
            return kafkaTopicPrefix + "." + tm.getKeyspace().getName() + "." + tm.getName() + ".Key";
        }

        private static String getValueName(String kafkaTopicPrefix, TableMetadata tm) {
            return kafkaTopicPrefix + "." + tm.getKeyspace().getName() + "." + tm.getName() + ".Value";
        }
    }
}

