/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.cassandra;

import io.debezium.connector.cassandra.KafkaRecord;
import io.debezium.connector.cassandra.KeyspaceTable;
import io.debezium.connector.cassandra.Module;
import io.debezium.connector.cassandra.OffsetPosition;
import io.debezium.connector.cassandra.transforms.CassandraTypeKafkaSchemaBuilders;
import java.util.HashMap;
import java.util.Objects;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;

public class SourceInfo
implements KafkaRecord {
    public static final String DEBEZIUM_VERSION_KEY = "version";
    public static final String DEBEZIUM_CONNECTOR_KEY = "connector";
    public static final String CLUSTER_KEY = "cluster";
    public static final String COMMITLOG_FILENAME_KEY = "file";
    public static final String COMMITLOG_POSITION_KEY = "pos";
    public static final String KEYSPACE_NAME_KEY = "keyspace";
    public static final String TABLE_NAME_KEY = "table";
    public static final String SNAPSHOT_KEY = "snapshot";
    public static final String TIMESTAMP_KEY = "ts_micro";
    public static final Schema SOURCE_SCHEMA = SchemaBuilder.struct().name("source").field("version", Schema.STRING_SCHEMA).field("connector", Schema.STRING_SCHEMA).field("cluster", Schema.STRING_SCHEMA).field("file", Schema.STRING_SCHEMA).field("pos", Schema.INT32_SCHEMA).field("snapshot", Schema.BOOLEAN_SCHEMA).field("keyspace", Schema.STRING_SCHEMA).field("table", Schema.STRING_SCHEMA).field("ts_micro", (Schema)CassandraTypeKafkaSchemaBuilders.TIMESTAMP_MICRO_TYPE).build();
    public final String version = Module.version();
    public final String connector = Module.name();
    public final String cluster;
    public final OffsetPosition offsetPosition;
    public final KeyspaceTable keyspaceTable;
    public final boolean snapshot;
    public final long tsMicro;

    public SourceInfo(String cluster, OffsetPosition offsetPosition, KeyspaceTable keyspaceTable, boolean snapshot, long tsMicro) {
        this.cluster = cluster;
        this.offsetPosition = offsetPosition;
        this.keyspaceTable = keyspaceTable;
        this.tsMicro = tsMicro;
        this.snapshot = snapshot;
    }

    @Override
    public Struct record(Schema schema) {
        return new Struct(schema).put(DEBEZIUM_VERSION_KEY, (Object)this.version).put(DEBEZIUM_CONNECTOR_KEY, (Object)this.connector).put(CLUSTER_KEY, (Object)this.cluster).put(COMMITLOG_FILENAME_KEY, (Object)this.offsetPosition.fileName).put(COMMITLOG_POSITION_KEY, (Object)this.offsetPosition.filePosition).put(SNAPSHOT_KEY, (Object)this.snapshot).put(KEYSPACE_NAME_KEY, (Object)this.keyspaceTable.keyspace).put(TABLE_NAME_KEY, (Object)this.keyspaceTable.table).put(TIMESTAMP_KEY, (Object)this.tsMicro);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SourceInfo that = (SourceInfo)o;
        return this.version.equals(that.version) && this.connector.equals(that.connector) && this.cluster.equals(that.cluster) && this.offsetPosition == that.offsetPosition && this.snapshot == that.snapshot && this.keyspaceTable == that.keyspaceTable && this.tsMicro == that.tsMicro;
    }

    public int hashCode() {
        return Objects.hash(this.cluster, this.snapshot, this.offsetPosition, this.keyspaceTable, this.tsMicro);
    }

    public String toString() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(DEBEZIUM_VERSION_KEY, this.version);
        map.put(DEBEZIUM_CONNECTOR_KEY, this.connector);
        map.put(CLUSTER_KEY, this.cluster);
        map.put(SNAPSHOT_KEY, this.snapshot);
        map.put(COMMITLOG_FILENAME_KEY, this.offsetPosition.fileName);
        map.put(COMMITLOG_POSITION_KEY, this.offsetPosition.filePosition);
        map.put(KEYSPACE_NAME_KEY, this.keyspaceTable.keyspace);
        map.put(TABLE_NAME_KEY, this.keyspaceTable.table);
        map.put(TIMESTAMP_KEY, this.tsMicro);
        return ((Object)map).toString();
    }
}

