/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.cassandra;

import io.debezium.annotation.ThreadSafe;
import io.debezium.connector.cassandra.KeyspaceTable;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraTopicSelector {
    private static final Logger LOGGER = LoggerFactory.getLogger(CassandraTopicSelector.class);
    private static final String DEFAULT_DELIMITER = ".";
    private final String prefix;
    private final String delimiter;
    private final TableTopicNamer tableTopicNamer;

    private CassandraTopicSelector(String prefix, String delimiter, TableTopicNamer tableTopicNamer) {
        this.prefix = prefix;
        this.delimiter = delimiter;
        this.tableTopicNamer = new TopicNameCache(new TopicNameSanitizer(tableTopicNamer));
    }

    static CassandraTopicSelector defaultSelector(String topicPrefix) {
        return new CassandraTopicSelector(topicPrefix, DEFAULT_DELIMITER, (keyspaceTable, prefix, delimiter) -> String.join((CharSequence)delimiter, prefix, keyspaceTable.keyspace, keyspaceTable.table));
    }

    String topicNameFor(KeyspaceTable keyspaceTable) {
        return this.tableTopicNamer.topicNameFor(keyspaceTable, this.prefix, this.delimiter);
    }

    @ThreadSafe
    private static class TopicNameCache
    implements TableTopicNamer {
        private final ConcurrentHashMap<KeyspaceTable, String> topicNames = new ConcurrentHashMap();
        private final TableTopicNamer delegate;

        TopicNameCache(TableTopicNamer delegate) {
            this.delegate = delegate;
        }

        @Override
        public String topicNameFor(KeyspaceTable keyspaceTable, String prefix, String delimiter) {
            return this.topicNames.computeIfAbsent(keyspaceTable, i -> this.delegate.topicNameFor((KeyspaceTable)i, prefix, delimiter));
        }
    }

    private static class TopicNameSanitizer
    implements TableTopicNamer {
        private static final String REPLACEMENT_CHAR = "_";
        private final TableTopicNamer delegate;

        TopicNameSanitizer(TableTopicNamer delegate) {
            this.delegate = delegate;
        }

        @Override
        public String topicNameFor(KeyspaceTable keyspaceTable, String prefix, String delimiter) {
            String topicName = this.delegate.topicNameFor(keyspaceTable, prefix, delimiter);
            StringBuilder sanitizedNameBuilder = new StringBuilder(topicName.length());
            boolean changed = false;
            for (int i = 0; i < topicName.length(); ++i) {
                char c = topicName.charAt(i);
                if (this.isValidTopicNameCharacter(c)) {
                    sanitizedNameBuilder.append(c);
                    continue;
                }
                sanitizedNameBuilder.append(REPLACEMENT_CHAR);
                changed = true;
            }
            if (changed) {
                String sanitizedName = sanitizedNameBuilder.toString();
                LOGGER.warn("Topic '{}' name isn't a valid topic, replacing it with '{}'", (Object)topicName, (Object)sanitizedName);
                return sanitizedName;
            }
            return topicName;
        }

        private boolean isValidTopicNameCharacter(char c) {
            return c == '.' || c == '_' || c == '-' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9';
        }
    }

    @FunctionalInterface
    public static interface TableTopicNamer {
        public String topicNameFor(KeyspaceTable var1, String var2, String var3);
    }
}

