/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.cassandra;

import io.debezium.connector.cassandra.BlockingEventQueue;
import io.debezium.connector.cassandra.CassandraClient;
import io.debezium.connector.cassandra.CassandraConnectorConfig;
import io.debezium.connector.cassandra.Event;
import io.debezium.connector.cassandra.FileOffsetWriter;
import io.debezium.connector.cassandra.OffsetWriter;
import io.debezium.connector.cassandra.SchemaHolder;
import java.io.IOException;
import java.security.GeneralSecurityException;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.config.Schema;

public class CassandraConnectorContext {
    private final CassandraConnectorConfig config;
    private final CassandraClient cassandraClient;
    private final BlockingEventQueue<Event> queue;
    private final SchemaHolder schemaHolder;
    private final OffsetWriter offsetWriter;

    public CassandraConnectorContext(CassandraConnectorConfig config) throws GeneralSecurityException, IOException {
        this.config = config;
        this.loadDdlFromDisk(this.config.cassandraConfig());
        this.cassandraClient = new CassandraClient(this.config);
        this.queue = new BlockingEventQueue(this.config.pollIntervalMs(), this.config.maxQueueSize(), this.config.maxBatchSize());
        this.schemaHolder = new SchemaHolder(this.cassandraClient, this.config.connectorName());
        this.offsetWriter = new FileOffsetWriter(this.config.offsetBackingStoreDir());
    }

    public void loadDdlFromDisk(String yamlConfig) {
        System.setProperty("cassandra.config", "file:///" + yamlConfig);
        if (!DatabaseDescriptor.isDaemonInitialized() && !DatabaseDescriptor.isToolInitialized()) {
            DatabaseDescriptor.toolInitialization();
            Schema.instance.loadFromDisk(false);
        }
    }

    public void cleanUp() {
        this.cassandraClient.close();
        this.offsetWriter.close();
    }

    public CassandraConnectorConfig getCassandraConnectorConfig() {
        return this.config;
    }

    public CassandraClient getCassandraClient() {
        return this.cassandraClient;
    }

    public BlockingEventQueue<Event> getQueue() {
        return this.queue;
    }

    public OffsetWriter getOffsetWriter() {
        return this.offsetWriter;
    }

    public SchemaHolder getSchemaHolder() {
        return this.schemaHolder;
    }
}

