/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.binlog;

import com.github.shyiko.mysql.binlog.event.Event;
import com.github.shyiko.mysql.binlog.event.EventType;
import com.github.shyiko.mysql.binlog.event.MariadbGtidEventData;
import com.github.shyiko.mysql.binlog.event.QueryEventData;
import io.debezium.connector.binlog.BinlogOffsetContext;
import io.debezium.connector.binlog.BinlogPartition;
import io.debezium.connector.binlog.BinlogStreamingChangeEventSource;
import io.debezium.pipeline.source.spi.ChangeEventSource;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventBuffer<T extends BinlogStreamingChangeEventSource<P, O>, P extends BinlogPartition, O extends BinlogOffsetContext> {
    private static final Logger LOGGER = LoggerFactory.getLogger(EventBuffer.class);
    private final int capacity;
    private final Queue<Event> buffer;
    private final T streamingChangeEventSource;
    private final ChangeEventSource.ChangeEventSourceContext changeEventSourceContext;
    private boolean txStarted = false;
    private BinlogStreamingChangeEventSource.BinlogPosition largeTxNotBufferedPosition;
    private BinlogStreamingChangeEventSource.BinlogPosition forwardTillPosition;

    public EventBuffer(int capacity, T streamingChangeEventSource, ChangeEventSource.ChangeEventSourceContext changeEventSourceContext) {
        this.capacity = capacity;
        this.buffer = new ArrayBlockingQueue<Event>(capacity);
        this.streamingChangeEventSource = streamingChangeEventSource;
        this.changeEventSourceContext = changeEventSourceContext;
    }

    public void add(P partition, O offsetContext, Event event) {
        if (event == null) {
            return;
        }
        if (this.isReplayingEventsBeyondBufferCapacity()) {
            ((BinlogStreamingChangeEventSource)this.streamingChangeEventSource).handleEvent(partition, offsetContext, this.changeEventSourceContext, event);
            return;
        }
        if (event.getHeader().getEventType() == EventType.QUERY) {
            QueryEventData command = (QueryEventData)((BinlogStreamingChangeEventSource)this.streamingChangeEventSource).unwrapData(event);
            LOGGER.debug("Received query command: {}", (Object)event);
            String sql = command.getSql().trim();
            if (sql.equalsIgnoreCase("BEGIN")) {
                this.beginTransaction(partition, offsetContext, event);
            } else if (sql.equalsIgnoreCase("COMMIT")) {
                this.completeTransaction(partition, offsetContext, true, event);
            } else if (sql.equalsIgnoreCase("ROLLBACK")) {
                this.rollbackTransaction();
            } else {
                this.consumeEvent(partition, offsetContext, event);
            }
        } else if (event.getHeader().getEventType() == EventType.MARIADB_GTID) {
            MariadbGtidEventData gtidEventData = (MariadbGtidEventData)event.getData();
            if ((gtidEventData.getFlags() & 1) != 1) {
                this.beginTransaction(partition, offsetContext, event);
            }
        } else if (event.getHeader().getEventType() == EventType.XID) {
            this.completeTransaction(partition, offsetContext, true, event);
        } else {
            this.consumeEvent(partition, offsetContext, event);
        }
    }

    private boolean isReplayingEventsBeyondBufferCapacity() {
        if (this.forwardTillPosition != null) {
            if (this.forwardTillPosition.equals(((BinlogStreamingChangeEventSource)this.streamingChangeEventSource).getCurrentBinlogPosition())) {
                this.forwardTillPosition = null;
            }
            return true;
        }
        return false;
    }

    private void addToBuffer(Event event) {
        if (this.isInBufferFullMode()) {
            return;
        }
        if (this.buffer.size() == this.capacity) {
            this.switchToBufferFullMode();
        } else {
            this.buffer.add(event);
        }
    }

    private void switchToBufferFullMode() {
        this.largeTxNotBufferedPosition = ((BinlogStreamingChangeEventSource)this.streamingChangeEventSource).getCurrentBinlogPosition();
        LOGGER.info("Buffer full, will need to re-read part of the transaction from binlog from {}", (Object)this.largeTxNotBufferedPosition);
        ((BinlogStreamingChangeEventSource)this.streamingChangeEventSource).getMetrics().onLargeTransaction();
        if (this.buffer.peek().getHeader().getEventType() == EventType.TABLE_MAP) {
            this.buffer.remove();
        }
    }

    private boolean isInBufferFullMode() {
        return this.largeTxNotBufferedPosition != null;
    }

    private void consumeEvent(P partition, O offsetContext, Event event) {
        if (this.txStarted) {
            this.addToBuffer(event);
        } else {
            ((BinlogStreamingChangeEventSource)this.streamingChangeEventSource).handleEvent(partition, offsetContext, this.changeEventSourceContext, event);
        }
    }

    private void beginTransaction(P partition, O offsetContext, Event event) {
        if (this.txStarted) {
            LOGGER.warn("New transaction started but the previous was not completed, processing the buffer");
            this.completeTransaction(partition, offsetContext, false, null);
        } else {
            this.txStarted = true;
        }
        this.addToBuffer(event);
    }

    private void completeTransaction(P partition, O offsetContext, boolean wellFormed, Event event) {
        LOGGER.debug("Committing transaction");
        if (event != null) {
            this.addToBuffer(event);
        }
        if (!this.txStarted) {
            LOGGER.warn("Commit requested but TX was not started before");
            wellFormed = false;
        }
        LOGGER.debug("Executing events from buffer");
        for (Event e : this.buffer) {
            ((BinlogStreamingChangeEventSource)this.streamingChangeEventSource).handleEvent(partition, offsetContext, this.changeEventSourceContext, e);
        }
        LOGGER.debug("Executing events from binlog that have not fit into buffer");
        if (this.isInBufferFullMode()) {
            this.forwardTillPosition = ((BinlogStreamingChangeEventSource)this.streamingChangeEventSource).getCurrentBinlogPosition();
            ((BinlogStreamingChangeEventSource)this.streamingChangeEventSource).rewindBinaryLogClient(this.changeEventSourceContext, this.largeTxNotBufferedPosition);
        }
        ((BinlogStreamingChangeEventSource)this.streamingChangeEventSource).getMetrics().onCommittedTransaction();
        if (!wellFormed) {
            ((BinlogStreamingChangeEventSource)this.streamingChangeEventSource).getMetrics().onNotWellFormedTransaction();
        }
        this.clear();
    }

    private void rollbackTransaction() {
        LOGGER.debug("Rolling back transaction");
        boolean wellFormed = true;
        if (!this.txStarted) {
            LOGGER.warn("Rollback requested but TX was not started before");
            wellFormed = false;
        }
        ((BinlogStreamingChangeEventSource)this.streamingChangeEventSource).getMetrics().onRolledBackTransaction();
        if (!wellFormed) {
            ((BinlogStreamingChangeEventSource)this.streamingChangeEventSource).getMetrics().onNotWellFormedTransaction();
        }
        this.clear();
    }

    private void clear() {
        this.buffer.clear();
        this.largeTxNotBufferedPosition = null;
        this.txStarted = false;
    }
}

