/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.binlog.jdbc;

import io.debezium.connector.binlog.BinlogConnectorConfig;
import io.debezium.connector.binlog.charset.BinlogCharsetRegistry;
import io.debezium.relational.Column;
import io.debezium.relational.Table;
import io.debezium.relational.TableId;
import io.debezium.util.Collect;
import java.io.UnsupportedEncodingException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BinlogFieldReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(BinlogFieldReader.class);
    private static final Set<String> TEXT_DATA_TYPES = Collect.unmodifiableSet((Object[])new String[]{"CHAR", "VARCHAR", "TEXT"});
    private final BinlogConnectorConfig connectorConfig;

    public BinlogFieldReader(BinlogConnectorConfig connectorConfig) {
        this.connectorConfig = connectorConfig;
    }

    public Object readField(ResultSet rs, int columnIndex, Column column, Table table) throws SQLException {
        switch (column.jdbcType()) {
            case 92: {
                return this.readTimeField(rs, columnIndex, column, table);
            }
            case 91: {
                try {
                    return this.readDateField(rs, columnIndex, column, table);
                }
                catch (RuntimeException e) {
                    LOGGER.warn("Failed to read data value: '{}'. Trying default implementation.", (Object)e.getMessage());
                    return rs.getObject(columnIndex);
                }
            }
            case 93: {
                try {
                    return this.readTimestampField(rs, columnIndex, column, table);
                }
                catch (RuntimeException e) {
                    LOGGER.warn("Failed to read data value: '{}'. Trying default implementation.", (Object)e.getMessage());
                    return rs.getObject(columnIndex);
                }
            }
            case -6: 
            case 5: {
                return rs.getObject(columnIndex) == null ? null : Integer.valueOf(rs.getInt(columnIndex));
            }
        }
        if (this.hasValueConverter(column, table.id()) && TEXT_DATA_TYPES.contains(column.typeName())) {
            try {
                String data = rs.getString(columnIndex);
                if (data != null) {
                    return data.getBytes(this.getCharacterSet(column));
                }
            }
            catch (UnsupportedEncodingException e) {
                LOGGER.warn("Unsupported encoding '{}' for column '{}', sending value as String", (Object)e.getMessage(), (Object)column.name());
            }
        }
        return rs.getObject(columnIndex);
    }

    protected abstract Object readTimeField(ResultSet var1, int var2, Column var3, Table var4) throws SQLException;

    protected abstract Object readDateField(ResultSet var1, int var2, Column var3, Table var4) throws SQLException;

    protected abstract Object readTimestampField(ResultSet var1, int var2, Column var3, Table var4) throws SQLException;

    protected abstract String getCharacterSet(Column var1);

    protected void logInvalidValue(ResultSet rs, int columnIndex, Object value) throws SQLException {
        String columnName = rs.getMetaData().getColumnName(columnIndex);
        LOGGER.trace("Column '{}', detected an invalid value of '{}'.", (Object)columnName, value);
    }

    protected boolean hasValueConverter(Column column, TableId tableId) {
        return this.connectorConfig.customConverterRegistry().getValueConverter(tableId, column).isPresent();
    }

    protected BinlogCharsetRegistry getCharsetRegistry() {
        return (BinlogCharsetRegistry)this.connectorConfig.getServiceRegistry().getService(BinlogCharsetRegistry.class);
    }
}

