/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.binlog;

import io.debezium.connector.SnapshotRecord;
import io.debezium.connector.binlog.BinlogSourceInfo;
import io.debezium.pipeline.CommonOffsetContext;
import io.debezium.pipeline.source.snapshot.incremental.IncrementalSnapshotContext;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.pipeline.txmetadata.TransactionContext;
import io.debezium.relational.TableId;
import io.debezium.spi.schema.DataCollectionId;
import io.debezium.util.Strings;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.connect.data.Schema;

public class BinlogOffsetContext<T extends BinlogSourceInfo>
extends CommonOffsetContext<T> {
    public static final String SNAPSHOT_COMPLETED_KEY = "snapshot_completed";
    public static final String EVENTS_TO_SKIP_OFFSET_KEY = "event";
    public static final String TIMESTAMP_KEY = "ts_sec";
    public static final String GTID_SET_KEY = "gtids";
    public static final String NON_GTID_TRANSACTION_ID_FORMAT = "file=%s,pos=%s";
    private final Schema sourceInfoSchema;
    private final TransactionContext transactionContext;
    private final IncrementalSnapshotContext<TableId> incrementalSnapshotContext;
    private String restartGtidSet;
    private String currentGtidSet;
    private String restartBinlogFilename;
    private long restartBinlogPosition = 0L;
    private int restartRowsToSkip = 0;
    private long restartEventsToSkip = 0L;
    private long currentEventLengthInBytes = 0L;
    private boolean inTransaction = false;
    private boolean snapshotCompleted;
    private String transactionId = null;

    public BinlogOffsetContext(boolean snapshot, boolean snapshotCompleted, TransactionContext transactionContext, IncrementalSnapshotContext<TableId> incrementalSnapshotContext, T sourceInfo) {
        super(sourceInfo);
        this.sourceInfoSchema = sourceInfo.schema();
        this.snapshotCompleted = snapshotCompleted;
        if (this.snapshotCompleted) {
            this.postSnapshotCompletion();
        } else {
            sourceInfo.setSnapshot(snapshot ? SnapshotRecord.TRUE : SnapshotRecord.FALSE);
        }
        this.transactionContext = transactionContext;
        this.incrementalSnapshotContext = incrementalSnapshotContext;
    }

    public Map<String, ?> getOffset() {
        Map<String, Object> offset = this.offsetUsingPosition(this.restartRowsToSkip);
        if (((BinlogSourceInfo)this.sourceInfo).isSnapshot()) {
            if (!this.snapshotCompleted) {
                offset.put("snapshot", true);
            }
        } else {
            return this.incrementalSnapshotContext.store(this.transactionContext.store(offset));
        }
        return offset;
    }

    public Schema getSourceInfoSchema() {
        return this.sourceInfoSchema;
    }

    public boolean isSnapshotRunning() {
        return ((BinlogSourceInfo)this.sourceInfo).isSnapshot() && !this.snapshotCompleted;
    }

    public void preSnapshotStart() {
        ((BinlogSourceInfo)this.sourceInfo).setSnapshot(SnapshotRecord.TRUE);
        this.snapshotCompleted = false;
    }

    public void preSnapshotCompletion() {
        this.snapshotCompleted = true;
    }

    public void event(DataCollectionId tableId, Instant timestamp) {
        ((BinlogSourceInfo)this.sourceInfo).setSourceTime(timestamp);
        ((BinlogSourceInfo)this.sourceInfo).tableEvent((TableId)tableId);
    }

    public TransactionContext getTransactionContext() {
        return this.transactionContext;
    }

    public IncrementalSnapshotContext<?> getIncrementalSnapshotContext() {
        return this.incrementalSnapshotContext;
    }

    public boolean isSnapshotCompleted() {
        return this.snapshotCompleted;
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public void setInitialSkips(long restartEventsToSkip, int restartRowsToSkip) {
        this.restartEventsToSkip = restartEventsToSkip;
        this.restartRowsToSkip = restartRowsToSkip;
    }

    public void databaseEvent(String database, Instant timestamp) {
        ((BinlogSourceInfo)this.sourceInfo).setSourceTime(timestamp);
        ((BinlogSourceInfo)this.sourceInfo).databaseEvent(database);
        ((BinlogSourceInfo)this.sourceInfo).tableEvent((TableId)null);
    }

    public void tableEvent(String database, Set<TableId> tableIds, Instant timestamp) {
        ((BinlogSourceInfo)this.sourceInfo).setSourceTime(timestamp);
        ((BinlogSourceInfo)this.sourceInfo).databaseEvent(database);
        ((BinlogSourceInfo)this.sourceInfo).tableEvent(tableIds);
    }

    public void setBinlogStartPoint(String binlogFilename, long positionOfFirstEvent) {
        assert (positionOfFirstEvent >= 0L);
        if (binlogFilename != null) {
            ((BinlogSourceInfo)this.sourceInfo).setBinlogPosition(binlogFilename, positionOfFirstEvent);
            this.restartBinlogFilename = binlogFilename;
        } else {
            ((BinlogSourceInfo)this.sourceInfo).setBinlogPosition(((BinlogSourceInfo)this.sourceInfo).getCurrentBinlogFilename(), positionOfFirstEvent);
        }
        this.restartBinlogPosition = positionOfFirstEvent;
        this.restartRowsToSkip = 0;
        this.restartEventsToSkip = 0L;
    }

    public void setCompletedGtidSet(String gtidSet) {
        if (gtidSet != null && !gtidSet.trim().isEmpty()) {
            String trimmedGtidSet;
            this.currentGtidSet = trimmedGtidSet = gtidSet.replace("\n", "").replace("\r", "");
            this.restartGtidSet = trimmedGtidSet;
        }
    }

    public String gtidSet() {
        return this.currentGtidSet;
    }

    public void startGtid(String gtid, String gtidSet) {
        ((BinlogSourceInfo)this.sourceInfo).startGtid(gtid);
        if (gtidSet != null && !gtidSet.trim().isEmpty()) {
            String trimmedGtidSet = gtidSet.replace("\n", "").replace("\r", "");
            this.restartGtidSet = Strings.defaultIfBlank((String)this.currentGtidSet, (String)trimmedGtidSet);
            this.currentGtidSet = trimmedGtidSet;
        }
    }

    public T getSource() {
        return (T)((Object)((BinlogSourceInfo)this.sourceInfo));
    }

    public void startNextTransaction() {
        this.restartRowsToSkip = 0;
        this.restartEventsToSkip = 0L;
        this.restartBinlogFilename = ((BinlogSourceInfo)this.sourceInfo).binlogFilename();
        this.restartBinlogPosition = ((BinlogSourceInfo)this.sourceInfo).binlogPosition();
        this.inTransaction = true;
        this.setTransactionId();
    }

    public void commitTransaction() {
        this.restartGtidSet = this.currentGtidSet;
        this.restartBinlogFilename = ((BinlogSourceInfo)this.sourceInfo).binlogFilename();
        this.restartBinlogPosition = ((BinlogSourceInfo)this.sourceInfo).binlogPosition() + this.currentEventLengthInBytes;
        this.restartRowsToSkip = 0;
        this.restartEventsToSkip = 0L;
        this.inTransaction = false;
        ((BinlogSourceInfo)this.sourceInfo).setQuery(null);
        this.resetTransactionId();
    }

    public void completeEvent() {
        ++this.restartEventsToSkip;
    }

    public void setEventPosition(long positionOfCurrentEvent, long eventSizeInBytes) {
        ((BinlogSourceInfo)this.sourceInfo).setEventPosition(positionOfCurrentEvent);
        this.currentEventLengthInBytes = eventSizeInBytes;
        if (!this.inTransaction) {
            this.restartBinlogPosition = positionOfCurrentEvent + eventSizeInBytes;
            this.restartRowsToSkip = 0;
            this.restartEventsToSkip = 0L;
        }
    }

    public void setQuery(String query) {
        ((BinlogSourceInfo)this.sourceInfo).setQuery(query);
    }

    public void changeEventCompleted() {
        this.restartRowsToSkip = 0;
    }

    public long eventsToSkipUponRestart() {
        return this.restartEventsToSkip;
    }

    public int rowsToSkipUponRestart() {
        return this.restartRowsToSkip;
    }

    public void setRowNumber(int eventRowNumber, int totalNumberOfRows) {
        ((BinlogSourceInfo)this.sourceInfo).setRowNumber(eventRowNumber);
        this.restartRowsToSkip = eventRowNumber < totalNumberOfRows - 1 ? eventRowNumber + 1 : totalNumberOfRows;
    }

    public void setBinlogServerId(long serverId) {
        ((BinlogSourceInfo)this.sourceInfo).setBinlogServerId(serverId);
    }

    public void setBinlogThread(long threadId) {
        ((BinlogSourceInfo)this.sourceInfo).setBinlogThread(threadId);
    }

    private void setTransactionId() {
        this.transactionId = ((BinlogSourceInfo)this.sourceInfo).getCurrentGtid() != null ? ((BinlogSourceInfo)this.sourceInfo).getCurrentGtid() : String.format(NON_GTID_TRANSACTION_ID_FORMAT, this.restartBinlogFilename, this.restartBinlogPosition);
    }

    private void resetTransactionId() {
        this.transactionId = null;
    }

    private Map<String, Object> offsetUsingPosition(long rowsToSkip) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (((BinlogSourceInfo)this.sourceInfo).getServerId() != 0L) {
            map.put("server_id", ((BinlogSourceInfo)this.sourceInfo).getServerId());
        }
        if (this.restartGtidSet != null) {
            map.put(GTID_SET_KEY, this.restartGtidSet);
        }
        map.put("file", this.restartBinlogFilename);
        map.put("pos", this.restartBinlogPosition);
        if (this.restartEventsToSkip != 0L) {
            map.put(EVENTS_TO_SKIP_OFFSET_KEY, this.restartEventsToSkip);
        }
        if (rowsToSkip != 0L) {
            map.put("row", rowsToSkip);
        }
        if (((BinlogSourceInfo)this.sourceInfo).timestamp() != null) {
            map.put(TIMESTAMP_KEY, ((BinlogSourceInfo)this.sourceInfo).timestamp().getEpochSecond());
        }
        return map;
    }

    public String toString() {
        return "BinlogOffsetContext{sourceInfoSchema=" + this.sourceInfoSchema + ", sourceInfo=" + this.sourceInfo + ", snapshotCompleted=" + this.snapshotCompleted + ", transactionContext=" + this.transactionContext + ", restartGtidSet='" + this.restartGtidSet + "', currentGtidSet='" + this.currentGtidSet + "', restartBinlogFilename='" + this.restartBinlogFilename + "', restartBinlogPosition=" + this.restartBinlogPosition + ", restartRowsToSkip=" + this.restartRowsToSkip + ", restartEventsToSkip=" + this.restartEventsToSkip + ", currentEventLengthInBytes=" + this.currentEventLengthInBytes + ", inTransaction=" + this.inTransaction + ", transactionId='" + this.transactionId + "', incrementalSnapshotContext=" + this.incrementalSnapshotContext + "}";
    }

    public static abstract class Loader<O extends BinlogOffsetContext>
    implements OffsetContext.Loader<O> {
        protected static boolean isTrue(Map<String, ?> offset, String key) {
            return Boolean.TRUE.equals(offset.get(key)) || "true".equals(offset.get(key));
        }
    }
}

