/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.engine.spi;

import java.time.Duration;
import java.util.Properties;

@FunctionalInterface
public interface OffsetCommitPolicy {
    public static OffsetCommitPolicy always() {
        return new AlwaysCommitOffsetPolicy();
    }

    public static OffsetCommitPolicy periodic(Properties config) {
        return new PeriodicCommitOffsetPolicy(config);
    }

    public boolean performCommit(long var1, Duration var3);

    default public OffsetCommitPolicy or(OffsetCommitPolicy other) {
        if (other == null) {
            return this;
        }
        return (number, time) -> this.performCommit(number, time) || other.performCommit(number, time);
    }

    default public OffsetCommitPolicy and(OffsetCommitPolicy other) {
        if (other == null) {
            return this;
        }
        return (number, time) -> this.performCommit(number, time) && other.performCommit(number, time);
    }

    public static class AlwaysCommitOffsetPolicy
    implements OffsetCommitPolicy {
        @Override
        public boolean performCommit(long numberOfMessagesSinceLastCommit, Duration timeSinceLastCommit) {
            return true;
        }
    }

    public static class PeriodicCommitOffsetPolicy
    implements OffsetCommitPolicy {
        private static final Duration DEFAULT_COMMIT_OFFSET_INTERVAL = Duration.ofMinutes(1L);
        private final Duration minimumTime;

        public PeriodicCommitOffsetPolicy(Properties config) {
            this.minimumTime = config.containsKey("offset.flush.interval.ms") ? Duration.ofMillis(Long.valueOf(config.getProperty("offset.flush.interval.ms"))) : DEFAULT_COMMIT_OFFSET_INTERVAL;
        }

        @Override
        public boolean performCommit(long numberOfMessagesSinceLastCommit, Duration timeSinceLastCommit) {
            return timeSinceLastCommit.compareTo(this.minimumTime) >= 0;
        }
    }
}

