/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.ai.embeddings;

import dev.langchain4j.model.embedding.EmbeddingModel;
import dev.langchain4j.model.huggingface.HuggingFaceEmbeddingModel;
import io.debezium.ai.embeddings.EmbeddingsModelFactory;
import io.debezium.config.Configuration;
import io.debezium.config.Field;
import io.debezium.util.Strings;
import java.time.Duration;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.connect.connector.ConnectRecord;

public class HuggingFaceModelFactory<R extends ConnectRecord<R>>
implements EmbeddingsModelFactory {
    private static final int DEFAULT_OPERATION_TIMEOUT = 15000;
    public static final String HUGGING_FACE_PREFIX = "huggingface.";
    private static final Field HUGGING_FACE_BASE_URL = Field.create((String)"huggingface.baseUrl").withDisplayName("Hugging Face base URL.").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.HIGH).withDescription("Base URL for Hugging Face client. If not provided, default Hugging Face client URL will be used.");
    private static final Field HUGGING_FACE_ACCESS_TOKEN = Field.create((String)"huggingface.access.token").withDisplayName("Hugging Face API access token.").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.HIGH).withDescription("Access token for Hugging Face API.").required();
    private static final Field MODEL_NAME = Field.create((String)"huggingface.model.name").withDisplayName("Model name.").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.HIGH).withDescription("Name of the Hugging Face model which should be used.").required();
    private static final Field OPERATION_TIMEOUT = Field.create((String)"huggingface.operation.timeout.ms").withDisplayName("Operation timeout.").withType(ConfigDef.Type.INT).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.MEDIUM).withDefault(15000).withDescription("Milliseconds to wait for Hugging Face calculations to finish (defaults to %s).".formatted(15000));
    public static final Field.Set ALL_FIELDS = Field.setOf((Field[])new Field[]{HUGGING_FACE_BASE_URL, HUGGING_FACE_ACCESS_TOKEN, MODEL_NAME, OPERATION_TIMEOUT});
    private String baseUrl;
    private String accessToken;
    private String modelName;
    private int operationTimeout;

    public Field.Set getConfigFields() {
        return ALL_FIELDS;
    }

    public void configure(Configuration config) {
        this.baseUrl = config.getString(HUGGING_FACE_BASE_URL);
        this.accessToken = config.getString(HUGGING_FACE_ACCESS_TOKEN);
        this.modelName = config.getString(MODEL_NAME);
        this.operationTimeout = config.getInteger(OPERATION_TIMEOUT);
    }

    public void validateConfiguration() {
        if (Strings.isNullOrBlank((String)this.accessToken)) {
            throw new ConfigException(String.format("'%s' must be set to non-empty value.", HUGGING_FACE_ACCESS_TOKEN));
        }
        if (Strings.isNullOrBlank((String)this.modelName)) {
            throw new ConfigException(String.format("'%s' must be set to non-empty value.", MODEL_NAME));
        }
    }

    public EmbeddingModel getModel() {
        HuggingFaceEmbeddingModel.HuggingFaceEmbeddingModelBuilder builder = HuggingFaceEmbeddingModel.builder().accessToken(this.accessToken).modelId(this.modelName).waitForModel(Boolean.valueOf(true)).timeout(Duration.ofMillis(this.operationTimeout));
        if (!Strings.isNullOrBlank((String)this.baseUrl)) {
            builder.baseUrl(this.baseUrl);
        }
        return builder.build();
    }
}

