/*
 * Decompiled with CFR 0.152.
 */
package io.dapr.client.domain.query;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.dapr.client.domain.query.Pagination;
import io.dapr.client.domain.query.Sorting;
import io.dapr.client.domain.query.filters.Filter;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class Query {
    private Filter<?> filter;
    @JsonProperty
    private Sorting[] sort = new Sorting[0];
    @JsonProperty(value="page")
    private Pagination pagination = new Pagination();

    public Filter<?> getFilter() {
        return this.filter;
    }

    public Query setFilter(Filter<?> filter) {
        if (!filter.isValid().booleanValue()) {
            throw new IllegalArgumentException("the given filter is invalid configuration");
        }
        this.filter = filter;
        return this;
    }

    public List<Sorting> getSort() {
        return Collections.unmodifiableList(Arrays.asList(this.sort));
    }

    public Query setSort(List<Sorting> sort) {
        if (sort == null || sort.size() == 0) {
            throw new IllegalArgumentException("Sorting list is null or empty");
        }
        this.sort = sort.toArray(new Sorting[0]);
        return this;
    }

    public Pagination getPagination() {
        return this.pagination;
    }

    public Query setPagination(Pagination pagination) {
        this.pagination = pagination;
        return this;
    }
}

