/*
 * Decompiled with CFR 0.152.
 */
package io.dapr.client.domain;

import io.dapr.client.DaprHttp;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import okhttp3.HttpUrl;

public final class HttpExtension {
    public static final HttpExtension NONE = new HttpExtension(DaprHttp.HttpMethods.NONE);
    public static final HttpExtension GET = new HttpExtension(DaprHttp.HttpMethods.GET);
    public static final HttpExtension PUT = new HttpExtension(DaprHttp.HttpMethods.PUT);
    public static final HttpExtension POST = new HttpExtension(DaprHttp.HttpMethods.POST);
    public static final HttpExtension DELETE = new HttpExtension(DaprHttp.HttpMethods.DELETE);
    public static final HttpExtension HEAD = new HttpExtension(DaprHttp.HttpMethods.HEAD);
    public static final HttpExtension CONNECT = new HttpExtension(DaprHttp.HttpMethods.CONNECT);
    public static final HttpExtension OPTIONS = new HttpExtension(DaprHttp.HttpMethods.OPTIONS);
    public static final HttpExtension TRACE = new HttpExtension(DaprHttp.HttpMethods.TRACE);
    private DaprHttp.HttpMethods method;
    private Map<String, List<String>> queryParams;
    private Map<String, String> headers;

    public HttpExtension(DaprHttp.HttpMethods method, Map<String, List<String>> queryParams, Map<String, String> headers) {
        if (method == null) {
            throw new IllegalArgumentException("HttpExtension method cannot be null");
        }
        this.method = method;
        this.queryParams = Collections.unmodifiableMap(queryParams == null ? Collections.emptyMap() : queryParams);
        this.headers = Collections.unmodifiableMap(headers == null ? Collections.emptyMap() : headers);
    }

    public HttpExtension(DaprHttp.HttpMethods method) {
        this(method, null, null);
    }

    public DaprHttp.HttpMethods getMethod() {
        return this.method;
    }

    public Map<String, List<String>> getQueryParams() {
        return this.queryParams;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public String encodeQueryString() {
        if (this.queryParams == null || this.queryParams.isEmpty()) {
            return "";
        }
        HttpUrl.Builder urlBuilder = new HttpUrl.Builder();
        urlBuilder.scheme("http").host("localhost");
        Optional.ofNullable(this.queryParams).orElse(Collections.emptyMap()).entrySet().stream().forEach(urlParameter -> Optional.ofNullable((List)urlParameter.getValue()).orElse(Collections.emptyList()).stream().forEach(urlParameterValue -> urlBuilder.addQueryParameter((String)urlParameter.getKey(), urlParameterValue)));
        return urlBuilder.build().encodedQuery();
    }
}

