/*
 * Decompiled with CFR 0.152.
 */
package io.dapr.client;

import io.dapr.client.DaprApiProtocol;
import io.dapr.client.DaprClient;
import io.dapr.client.DaprClientGrpc;
import io.dapr.client.DaprClientHttp;
import io.dapr.client.DaprClientProxy;
import io.dapr.client.DaprHttpBuilder;
import io.dapr.client.DaprPreviewClient;
import io.dapr.config.Properties;
import io.dapr.serializer.DaprObjectSerializer;
import io.dapr.serializer.DefaultObjectSerializer;
import io.dapr.utils.Version;
import io.dapr.v1.DaprGrpc;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import java.io.Closeable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DaprClientBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(DaprClientBuilder.class);
    private final DaprApiProtocol apiProtocol;
    private final DaprApiProtocol methodInvocationApiProtocol;
    private final DaprHttpBuilder daprHttpBuilder;
    private DaprObjectSerializer objectSerializer = new DefaultObjectSerializer();
    private DaprObjectSerializer stateSerializer = new DefaultObjectSerializer();

    public DaprClientBuilder() {
        this.apiProtocol = Properties.API_PROTOCOL.get();
        this.methodInvocationApiProtocol = Properties.API_METHOD_INVOCATION_PROTOCOL.get();
        this.daprHttpBuilder = new DaprHttpBuilder();
    }

    public DaprClientBuilder withObjectSerializer(DaprObjectSerializer objectSerializer) {
        if (objectSerializer == null) {
            throw new IllegalArgumentException("Object serializer is required");
        }
        if (objectSerializer.getContentType() == null || objectSerializer.getContentType().isEmpty()) {
            throw new IllegalArgumentException("Content Type should not be null or empty");
        }
        this.objectSerializer = objectSerializer;
        return this;
    }

    public DaprClientBuilder withStateSerializer(DaprObjectSerializer stateSerializer) {
        if (stateSerializer == null) {
            throw new IllegalArgumentException("State serializer is required");
        }
        this.stateSerializer = stateSerializer;
        return this;
    }

    public DaprClient build() {
        if (this.apiProtocol == DaprApiProtocol.HTTP) {
            LOGGER.warn("HTTP client protocol is deprecated and will be removed in Dapr's Java SDK version 1.10.");
        }
        if (this.apiProtocol != this.methodInvocationApiProtocol) {
            return new DaprClientProxy(this.buildDaprClient(this.apiProtocol), this.buildDaprClient(this.methodInvocationApiProtocol));
        }
        return this.buildDaprClient(this.apiProtocol);
    }

    public DaprPreviewClient buildPreviewClient() {
        return (DaprPreviewClient)((Object)this.buildDaprClient(this.apiProtocol));
    }

    private DaprClient buildDaprClient(DaprApiProtocol protocol) {
        if (protocol == null) {
            throw new IllegalStateException("Protocol is required.");
        }
        switch (protocol) {
            case GRPC: {
                return this.buildDaprClientGrpc();
            }
            case HTTP: {
                return this.buildDaprClientHttp();
            }
        }
        throw new IllegalStateException("Unsupported protocol: " + protocol.name());
    }

    private DaprClient buildDaprClientGrpc() {
        int port = Properties.GRPC_PORT.get();
        if (port <= 0) {
            throw new IllegalArgumentException("Invalid port.");
        }
        ManagedChannel channel = ManagedChannelBuilder.forAddress((String)Properties.SIDECAR_IP.get(), (int)port).usePlaintext().userAgent(Version.getSdkVersion()).build();
        Closeable closeableChannel = () -> {
            if (channel != null && !channel.isShutdown()) {
                channel.shutdown();
            }
        };
        DaprGrpc.DaprStub asyncStub = DaprGrpc.newStub((Channel)channel);
        return new DaprClientGrpc(closeableChannel, asyncStub, this.objectSerializer, this.stateSerializer);
    }

    private DaprClient buildDaprClientHttp() {
        return new DaprClientHttp(this.daprHttpBuilder.build(), this.objectSerializer, this.stateSerializer);
    }
}

