/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.testngxmlformatter;

import io.cucumber.messages.Convertor;
import io.cucumber.messages.LocationComparator;
import io.cucumber.messages.types.Duration;
import io.cucumber.messages.types.Envelope;
import io.cucumber.messages.types.Feature;
import io.cucumber.messages.types.Pickle;
import io.cucumber.messages.types.PickleStep;
import io.cucumber.messages.types.Step;
import io.cucumber.messages.types.TestCaseFinished;
import io.cucumber.messages.types.TestCaseStarted;
import io.cucumber.messages.types.TestStep;
import io.cucumber.messages.types.TestStepFinished;
import io.cucumber.messages.types.TestStepResult;
import io.cucumber.messages.types.TestStepResultStatus;
import io.cucumber.messages.types.Timestamp;
import io.cucumber.query.Lineage;
import io.cucumber.query.NamingStrategy;
import io.cucumber.query.Query;
import io.cucumber.query.Repository;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.AbstractMap;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

class XmlReportData {
    private static final Duration ZERO_DURATION = new Duration(Long.valueOf(0L), Integer.valueOf(0));
    private static final TestStepResult SCENARIO_WITH_NO_STEPS = new TestStepResult(ZERO_DURATION, null, TestStepResultStatus.PASSED, null);
    private final Repository repository = Repository.builder().feature(Repository.RepositoryFeature.INCLUDE_GHERKIN_DOCUMENTS, true).build();
    private final Query query = new Query(this.repository);
    private final NamingStrategy namingStrategy;
    private static final Comparator<Pickle> pickleComparator = Comparator.comparing(Pickle::getUri).thenComparing(pickle -> pickle.getLocation().orElse(null), Comparator.nullsFirst(new LocationComparator()));

    XmlReportData(NamingStrategy namingStrategy) {
        this.namingStrategy = namingStrategy;
    }

    void collect(Envelope envelope) {
        this.repository.update(envelope);
    }

    long getSuiteDurationInMilliSeconds() {
        return this.query.findTestRunDuration().orElse(java.time.Duration.ZERO).toMillis();
    }

    long getDurationInMilliSeconds(TestCaseStarted testCaseStarted) {
        return this.query.findTestCaseDurationBy(testCaseStarted).orElse(java.time.Duration.ZERO).toMillis();
    }

    Map<TestStepResultStatus, Long> getTestCaseStatusCounts() {
        return this.query.countMostSevereTestStepResultStatus();
    }

    int getTestCaseCount() {
        return this.query.countTestCasesStarted();
    }

    String getPickleName(TestCaseStarted testCaseStarted) {
        Pickle pickle = (Pickle)this.query.findPickleBy(testCaseStarted).orElseThrow(() -> new IllegalStateException("No pickle for " + testCaseStarted.getId()));
        return this.query.findLineageBy(pickle).map(lineage -> (String)this.namingStrategy.reduce(lineage, pickle)).orElseGet(() -> ((Pickle)pickle).getName());
    }

    List<Map.Entry<String, String>> getStepsAndResult(TestCaseStarted testCaseStarted) {
        return this.query.findTestStepFinishedAndTestStepBy(testCaseStarted).stream().filter(entry -> ((TestStep)entry.getValue()).getPickleStepId().isPresent()).map(testStep -> {
            String key = this.renderTestStepText((TestStep)testStep.getValue());
            String value = this.renderTestStepResult((TestStepFinished)testStep.getKey());
            return new AbstractMap.SimpleEntry<String, String>(key, value);
        }).collect(Collectors.toList());
    }

    private String renderTestStepResult(TestStepFinished testStepFinished) {
        return testStepFinished.getTestStepResult().getStatus().toString().toLowerCase(Locale.ROOT);
    }

    private String renderTestStepText(TestStep testStep) {
        Optional pickleStep = this.query.findPickleStepBy(testStep);
        String stepKeyWord = pickleStep.flatMap(arg_0 -> ((Query)this.query).findStepBy(arg_0)).map(Step::getKeyword).orElse("");
        String stepText = pickleStep.map(PickleStep::getText).orElse("");
        return stepKeyWord + stepText;
    }

    Set<Map.Entry<Optional<Feature>, List<TestCaseStarted>>> getAllTestCaseStartedGroupedByFeature() {
        return this.query.findAllTestCaseStartedOrderBy(Query::findPickleBy, pickleComparator).stream().map(testCaseStarted -> {
            Optional feature = this.query.findLineageBy(testCaseStarted).flatMap(Lineage::feature);
            return new AbstractMap.SimpleEntry(feature, (TestCaseStarted)testCaseStarted);
        }).collect(Collectors.groupingBy(AbstractMap.SimpleEntry::getKey, LinkedHashMap::new, Collectors.collectingAndThen(Collectors.toList(), entries -> entries.stream().map(AbstractMap.SimpleEntry::getValue).collect(Collectors.toList())))).entrySet();
    }

    TestStepResult getTestCaseStatus(TestCaseStarted testCaseStarted) {
        return this.query.findMostSevereTestStepResultBy(testCaseStarted).orElse(SCENARIO_WITH_NO_STEPS);
    }

    String getStartedAt(TestCaseStarted testCaseStarted) {
        Instant instant = Convertor.toInstant((Timestamp)testCaseStarted.getTimestamp());
        return DateTimeFormatter.ISO_INSTANT.format(instant);
    }

    String getFinishedAt(TestCaseStarted testCaseStarted) {
        TestCaseFinished testCaseFinished = (TestCaseFinished)this.query.findTestCaseFinishedBy(testCaseStarted).orElseThrow(() -> new IllegalStateException("No test cased finished for " + String.valueOf(testCaseStarted)));
        Instant instant = Convertor.toInstant((Timestamp)testCaseFinished.getTimestamp());
        return DateTimeFormatter.ISO_INSTANT.format(instant);
    }
}

