/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.messages.com.google.gson;

import io.cucumber.messages.com.google.gson.JsonElement;
import io.cucumber.messages.com.google.gson.JsonIOException;
import io.cucumber.messages.com.google.gson.JsonParseException;
import io.cucumber.messages.com.google.gson.JsonSyntaxException;
import io.cucumber.messages.com.google.gson.internal.Streams;
import io.cucumber.messages.com.google.gson.stream.JsonReader;
import io.cucumber.messages.com.google.gson.stream.JsonToken;
import io.cucumber.messages.com.google.gson.stream.MalformedJsonException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;

public final class JsonParser {
    public JsonElement parse(String json) throws JsonSyntaxException {
        return this.parse(new StringReader(json));
    }

    public JsonElement parse(Reader json) throws JsonIOException, JsonSyntaxException {
        try {
            JsonReader jsonReader = new JsonReader(json);
            JsonElement element = this.parse(jsonReader);
            if (!element.isJsonNull() && jsonReader.peek() != JsonToken.END_DOCUMENT) {
                throw new JsonSyntaxException("Did not consume the entire document.");
            }
            return element;
        }
        catch (MalformedJsonException e) {
            throw new JsonSyntaxException(e);
        }
        catch (IOException e) {
            throw new JsonIOException(e);
        }
        catch (NumberFormatException e) {
            throw new JsonSyntaxException(e);
        }
    }

    public JsonElement parse(JsonReader json) throws JsonIOException, JsonSyntaxException {
        boolean lenient = json.isLenient();
        json.setLenient(true);
        try {
            JsonElement jsonElement = Streams.parse(json);
            return jsonElement;
        }
        catch (StackOverflowError e) {
            throw new JsonParseException("Failed parsing JSON source: " + json + " to Json", e);
        }
        catch (OutOfMemoryError e) {
            throw new JsonParseException("Failed parsing JSON source: " + json + " to Json", e);
        }
        finally {
            json.setLenient(lenient);
        }
    }
}

