/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.messages;

import io.cucumber.messages.internal.com.fasterxml.jackson.core.JsonProcessingException;
import io.cucumber.messages.internal.com.fasterxml.jackson.databind.DeserializationFeature;
import io.cucumber.messages.internal.com.fasterxml.jackson.databind.ObjectMapper;
import io.cucumber.messages.types.Envelope;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;

public final class NdjsonToMessageIterable
implements Iterable<Envelope> {
    private final ObjectMapper mapper = new ObjectMapper().enable(DeserializationFeature.READ_ENUMS_USING_TO_STRING).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    private final BufferedReader input;
    private Envelope next;

    public NdjsonToMessageIterable(InputStream input) {
        this.input = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8));
    }

    @Override
    public Iterator<Envelope> iterator() {
        return new Iterator<Envelope>(){

            @Override
            public boolean hasNext() {
                try {
                    String line = NdjsonToMessageIterable.this.input.readLine();
                    if (line == null) {
                        return false;
                    }
                    if (line.trim().equals("")) {
                        return this.hasNext();
                    }
                    try {
                        NdjsonToMessageIterable.this.next = NdjsonToMessageIterable.this.mapper.readValue(line, Envelope.class);
                    }
                    catch (JsonProcessingException e) {
                        throw new RuntimeException(String.format("Not JSON: %s", line), e);
                    }
                    return true;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public Envelope next() {
                if (NdjsonToMessageIterable.this.next == null) {
                    throw new IllegalStateException("next() should only be called after a call to hasNext() that returns true");
                }
                return NdjsonToMessageIterable.this.next;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

